/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

import com.lothrazar.cyclicmagic.block.buildershape.BlockStructureBuilder;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityStructureBuilder
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final int spotsSkippablePerTrigger = 50;
    private static final String NBT_BUILDTYPE = "build";
    private static final String NBT_SHAPEINDEX = "shapeindex";
    private int buildType;
    private int buildSize = 3;
    private int height;
    private int needsRedstone = 1;
    private int shapeIndex = 0;
    private int renderParticles = 1;
    private int rotations = 0;
    public static int maxSize;
    public static int maxHeight;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;

    public TileEntityStructureBuilder() {
        super(9);
        this.initEnergy(BlockStructureBuilder.FUEL_COST);
        this.setSlotsForInsert(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public List<BlockPos> getShape() {
        BuildType buildType = this.getBuildTypeEnum();
        List<BlockPos> shape = new ArrayList<BlockPos>();
        switch (buildType) {
            case CIRCLE: {
                shape = UtilShape.circleHorizontal(this.getPosTarget(), this.getSize() * 2);
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case FACING: {
                shape = UtilShape.line(this.getPosTarget(), this.getCurrentFacing(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SQUARE: {
                shape = UtilShape.squareHorizontalHollow(this.getPosTarget(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SOLID: {
                shape = UtilShape.squareHorizontalFull(this.getTargetFacing(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SPHERE: {
                shape = UtilShape.sphere(this.getPosTarget(), this.getSize());
                break;
            }
            case DOME: {
                shape = UtilShape.sphereDome(this.getPosTarget(), this.getSize());
                break;
            }
            case CUP: {
                shape = UtilShape.sphereCup(this.getPosTarget().func_177981_b(this.getSize()), this.getSize());
                break;
            }
            case DIAGONAL: {
                shape = UtilShape.diagonal(this.getPosTarget(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case PYRAMID: {
                shape = UtilShape.squarePyramid(this.getPosTarget(), this.getSize(), this.getHeight());
            }
        }
        return shape;
    }

    private BlockPos getPosTarget() {
        return this.func_174877_v().func_177982_a(this.offsetX, this.offsetY, this.offsetZ);
    }

    public BlockPos getTargetFacing() {
        return this.getPosTarget().func_177967_a(this.getCurrentFacing(), this.getSize() + 1);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case BUILDTYPE: {
                    return this.buildType;
                }
                case SPEED: {
                    return this.speed;
                }
                case SIZE: {
                    return this.buildSize;
                }
                case HEIGHT: {
                    return this.height;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case RENDERPARTICLES: {
                    return this.renderParticles;
                }
                case ROTATIONS: {
                    return this.rotations;
                }
                case OX: {
                    return this.offsetX;
                }
                case OY: {
                    return this.offsetY;
                }
                case OZ: {
                    return this.offsetZ;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case BUILDTYPE: {
                    if (value >= BuildType.values().length) {
                        value = 0;
                    }
                    this.buildType = value;
                    break;
                }
                case SPEED: {
                    this.speed = value;
                    break;
                }
                case SIZE: {
                    this.buildSize = value;
                    break;
                }
                case HEIGHT: {
                    if (value > maxHeight) {
                        value = maxHeight;
                    }
                    this.height = Math.max(1, value);
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case RENDERPARTICLES: {
                    this.renderParticles = value % 2;
                    break;
                }
                case ROTATIONS: {
                    this.rotations = Math.max(0, value);
                    break;
                }
                case OX: {
                    this.offsetX = value;
                    break;
                }
                case OY: {
                    this.offsetY = value;
                    break;
                }
                case OZ: {
                    this.offsetZ = value;
                }
            }
        }
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    public int getHeight() {
        return this.func_174887_a_(Fields.HEIGHT.ordinal());
    }

    public void setHeight(int value) {
        this.func_174885_b(Fields.HEIGHT.ordinal(), value);
    }

    public int getBuildType() {
        return this.func_174887_a_(Fields.BUILDTYPE.ordinal());
    }

    public void setBuildType(int value) {
        this.func_174885_b(Fields.BUILDTYPE.ordinal(), value);
    }

    public BuildType getBuildTypeEnum() {
        int bt = Math.min(this.getBuildType(), BuildType.values().length - 1);
        return BuildType.values()[bt];
    }

    public void setSize(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= maxSize) {
            s = maxSize;
        }
        this.func_174885_b(Fields.SIZE.ordinal(), s);
    }

    public int getSize() {
        int s = this.func_174887_a_(Fields.SIZE.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
        this.timer = tagCompound.func_74762_e("Timer");
        this.shapeIndex = tagCompound.func_74762_e(NBT_SHAPEINDEX);
        this.buildType = tagCompound.func_74762_e(NBT_BUILDTYPE);
        this.buildSize = tagCompound.func_74762_e("size");
        this.renderParticles = tagCompound.func_74762_e("render");
        this.rotations = tagCompound.func_74762_e("rotations");
        this.setHeight(tagCompound.func_74762_e("buildHeight"));
        this.offsetX = tagCompound.func_74762_e("ox");
        this.offsetY = tagCompound.func_74762_e("oy");
        this.offsetZ = tagCompound.func_74762_e("oz");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("buildHeight", this.height);
        tagCompound.func_74768_a("Timer", this.timer);
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        tagCompound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        tagCompound.func_74768_a(NBT_BUILDTYPE, this.getBuildType());
        tagCompound.func_74768_a("size", this.buildSize);
        tagCompound.func_74768_a("render", this.renderParticles);
        tagCompound.func_74768_a("rotations", this.rotations);
        tagCompound.func_74768_a("ox", this.offsetX);
        tagCompound.func_74768_a("oy", this.offsetY);
        tagCompound.func_74768_a("oz", this.offsetZ);
        return super.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        if (!this.isRunning() || this.isInventoryEmpty()) {
            return;
        }
        this.shiftAllUp();
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
        if (stuff == null) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        BlockPos nextPos = shape.get(this.shapeIndex);
        for (int i = 0; i < 50; ++i) {
            if (stuff.func_176196_c(this.field_145850_b, nextPos) && this.field_145850_b.func_190527_a(stuff, nextPos, true, EnumFacing.UP, null)) {
                IBlockState placeState = UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j());
                if (this.field_145850_b.field_72995_K || !UtilPlaceBlocks.placeStateSafe(this.field_145850_b, null, nextPos, placeState)) break;
                for (int j = 0; j < this.rotations; ++j) {
                    UtilPlaceBlocks.rotateBlockValidState(this.field_145850_b, null, nextPos, this.getCurrentFacing());
                }
                this.func_70298_a(0, 1);
                break;
            }
            nextPos = shape.get(this.shapeIndex);
            this.incrementPosition(shape);
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    static {
        maxHeight = 10;
    }

    public static enum BuildType {
        FACING,
        SQUARE,
        CIRCLE,
        SOLID,
        SPHERE,
        DIAGONAL,
        DOME,
        CUP,
        PYRAMID;


        public static BuildType getNextType(BuildType btype) {
            int type = btype.ordinal();
            if (++type > SPHERE.ordinal()) {
                type = FACING.ordinal();
            }
            return BuildType.values()[type];
        }

        public boolean hasHeight() {
            return this != SPHERE && this != DIAGONAL && this != DOME && this != CUP;
        }

        public String shortcode() {
            switch (this) {
                case CIRCLE: {
                    return "CI";
                }
                case DIAGONAL: {
                    return "DI";
                }
                case FACING: {
                    return "FA";
                }
                case SOLID: {
                    return "SO";
                }
                case SPHERE: {
                    return "SP";
                }
                case SQUARE: {
                    return "SQ";
                }
                case DOME: {
                    return "DO";
                }
                case CUP: {
                    return "CU";
                }
                case PYRAMID: {
                    return "PY";
                }
            }
            return "";
        }
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SPEED,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDERPARTICLES,
        ROTATIONS,
        OX,
        OY,
        OZ;

    }
}

