/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import io.netty.buffer.ByteBuf;
import knightminer.ceramics.network.PacketBase;
import knightminer.ceramics.tileentity.TileChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChannelConnectionPacket
extends PacketBase {
    protected BlockPos pos;
    protected EnumFacing side;
    protected boolean connect;

    public ChannelConnectionPacket() {
    }

    public ChannelConnectionPacket(BlockPos pos, EnumFacing side, boolean connect) {
        this.pos = pos;
        this.side = side;
        this.connect = connect;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.side = EnumFacing.func_82600_a((int)buf.readByte());
        this.connect = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeByte(this.side.func_176745_a());
        buf.writeBoolean(this.connect);
    }

    public static class ChannelConnectionsHandler
    implements IMessageHandler<ChannelConnectionPacket, IMessage> {
        public IMessage onMessage(ChannelConnectionPacket message, MessageContext ctx) {
            PacketBase.getMainThread(ctx).func_152344_a(() -> {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                if (te instanceof TileChannel) {
                    ((TileChannel)te).updateConnection(message.side, message.connect);
                }
            });
            return null;
        }
    }
}

