/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager.type;

import com.blamejared.recipestages.handlers.Recipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import net.darkhax.itemstages.compat.crt.ItemStagesCrT;
import uk.artdude.zenstages.stager.type.TypeBase;

public class TypeIngredient
extends TypeBase<IIngredient> {
    private boolean stageRecipe;

    public TypeIngredient(IIngredient ingredient, boolean stageRecipe) {
        super(ingredient);
        this.stageRecipe = stageRecipe;
    }

    private IIngredient getIngredient() {
        return (IIngredient)this.getValue();
    }

    private boolean shouldStageRecipe() {
        return this.stageRecipe;
    }

    @Override
    public boolean isStaged(IIngredient toCompare) {
        return false;
    }

    @Override
    public void build(String stageName) {
        try {
            if (this.getIngredient() instanceof ILiquidStack) {
                ItemStagesCrT.stageLiquid((String)stageName, (ILiquidStack)((ILiquidStack)this.getIngredient()));
            } else {
                ItemStagesCrT.addItemStage((String)stageName, (IIngredient)this.getIngredient());
                if (this.shouldStageRecipe()) {
                    Recipes.setRecipeStage((String)stageName, (IIngredient)this.getIngredient());
                }
            }
        }
        catch (Exception err) {
            CraftTweakerAPI.logError((String)String.format("[Stage] Failed to stage %s to stage %s.", this.getIngredient().toString(), stageName), (Throwable)err);
        }
    }

    @Override
    public void build(String[] stageNames) {
    }

    @Override
    public void buildRecipe(String stageName) {
    }
}

