/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.common.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import uk.artdude.zenstages.ZenStages;
import uk.artdude.zenstages.stager.ZenStager;

public class Commands
extends CommandBase {
    private final String[] COMMANDS = new String[]{"stages", "giveAll", "removeAll"};

    @Nonnull
    public String func_71517_b() {
        return "zenstages";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/zenstages <action> [arguments...]";
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos blockPos) {
        if (args.length == 1) {
            return Commands.func_71530_a((String[])args, (String[])this.COMMANDS);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNot enough arguments."));
        } else {
            String identifier = args[0];
            ArrayList stages = new ArrayList();
            ZenStager.getStageMap().forEach((name, stage) -> stages.add(stage.getStage()));
            try {
                EntityPlayerMP playerMP = Commands.func_71521_c((ICommandSender)sender);
                switch (identifier.toLowerCase()) {
                    case "giveall": {
                        stages.forEach(stage -> GameStageHelper.addStage((EntityPlayer)playerMP, (String)stage));
                        GameStageHelper.syncPlayer((EntityPlayerMP)playerMP);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.zenstages.giveAll.success", new Object[]{Integer.toString(stages.size()), sender.func_70005_c_()}));
                        break;
                    }
                    case "removeall": {
                        stages.forEach(stage -> GameStageHelper.removeStage((EntityPlayer)playerMP, (String)stage));
                        GameStageHelper.syncPlayer((EntityPlayerMP)playerMP);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.zenstages.removeAll.success", new Object[]{Integer.toString(stages.size()), sender.func_70005_c_()}));
                        break;
                    }
                    case "stages": {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.zenstages.stages.success", new Object[]{Arrays.toString(stages.toArray())}));
                        break;
                    }
                    default: {
                        throw new CommandException("Invalid Option!", new Object[0]);
                    }
                }
            }
            catch (Exception err) {
                ZenStages.logger.error(String.format("Failed to give all stages to player%s", sender.func_70005_c_()), (Throwable)err);
            }
        }
    }
}

