/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.parse;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleDrop;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.IRuleListParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ParserRuleDropItem
implements IRuleListParser {
    @Override
    public void parse(RecipeItemParser parser, RuleList ruleList, Rule rule, ILogger logger, DebugFileWrapper debugFileWrapper) {
        int dropIndex = 0;
        for (RuleDrop drop : rule.drops) {
            if (drop == null) {
                logger.warn("Malformed JSON caused null RuleDrop, skipping null RuleDrop");
                continue;
            }
            if (drop.item == null) {
                if (!rule.debug) continue;
                debugFileWrapper.debug(String.format("[PARSE] Drop item object not defined in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                continue;
            }
            if (drop.item.items == null || drop.item.items.length == 0) {
                if (!rule.debug) continue;
                debugFileWrapper.debug(String.format("[PARSE] Drop item.items object not defined or empty in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                continue;
            }
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Parsing drop items for IRuleDrop at index " + dropIndex);
            }
            for (String itemString : drop.item.items) {
                ParseResult parse;
                NBTTagCompound tag = null;
                String[] split = itemString.split("#");
                if (split.length > 1) {
                    String nbtString = split[1];
                    if (split.length > 2) {
                        StringBuilder sb = new StringBuilder(nbtString);
                        for (int i = 2; i < split.length; ++i) {
                            sb.append("#").append(split[i]);
                        }
                        nbtString = sb.toString();
                    }
                    try {
                        tag = JsonToNBT.func_180713_a((String)nbtString);
                    }
                    catch (Exception e) {
                        logger.error("[PARSE] Unable to parse nbt string: " + split[1]);
                        continue;
                    }
                    if (rule.debug) {
                        debugFileWrapper.debug("[PARSE] Parsed item drop nbt: " + nbtString);
                    }
                }
                try {
                    parse = parser.parse(split[0]);
                }
                catch (MalformedRecipeItemException e) {
                    logger.error("[PARSE] Unable to parse item drop <" + split[0] + "> in file: " + ruleList._filename, e);
                    continue;
                }
                if (rule.debug) {
                    debugFileWrapper.debug("[PARSE] Parsed item drop: " + parse);
                }
                if ("ore".equals(parse.getDomain())) {
                    NonNullList ores = OreDictionary.getOres((String)parse.getPath());
                    if (ores.isEmpty()) {
                        logger.warn("[PARSE] No entries found for oreDict entry <ore:" + parse.getPath() + "> in file: " + ruleList._filename);
                    } else if (rule.debug) {
                        debugFileWrapper.debug("[PARSE] Expanding oreDict entry: " + parse);
                    }
                    for (ItemStack ore : ores) {
                        if (ore.func_77973_b().func_77614_k()) {
                            ParserUtil.addSubItemsToList(ore.func_77973_b(), drop.item._items, debugFileWrapper, rule.debug);
                            continue;
                        }
                        ItemStack itemStack = new ItemStack(ore.func_77973_b(), 1, ore.func_77960_j());
                        if (tag != null) {
                            itemStack.func_77982_d(tag.func_74737_b());
                        }
                        drop.item._items.add(itemStack);
                        if (!rule.debug) continue;
                        debugFileWrapper.debug("[PARSE] Added itemStack to drop: " + itemStack);
                    }
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parse.getDomain(), parse.getPath()));
                if (item == null) {
                    logger.error("[PARSE] Unable to find registered item <" + parse.toString() + "> in file: " + ruleList._filename);
                    continue;
                }
                if (rule.debug) {
                    debugFileWrapper.debug("[PARSE] Found registered item: " + item);
                }
                if (parse.getMeta() == Short.MAX_VALUE) {
                    if (!item.func_77614_k()) {
                        logger.error("[PARSE] Wildcard used for item <" + parse.toString() + ">, but item has no subtypes: " + ruleList._filename);
                        continue;
                    }
                    ParserUtil.addSubItemsToList(item, drop.item._items, debugFileWrapper, rule.debug);
                    continue;
                }
                ItemStack itemStack = new ItemStack(item, 1, parse.getMeta());
                if (tag != null) {
                    itemStack.func_77982_d(tag.func_74737_b());
                }
                drop.item._items.add(itemStack);
                if (!rule.debug) continue;
                debugFileWrapper.debug("[PARSE] Added itemStack to drop: " + itemStack);
            }
            ++dropIndex;
        }
    }
}

