/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.api.reference.EnumListType;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatchHarvesterHeldItemMainHand;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HeldItemMainHandMatcher {
    public boolean matches(RuleMatchHarvesterHeldItemMainHand ruleMatchHarvesterHeldItemMainHand, ItemStack heldItemStack, IBlockState blockState, EntityPlayer harvester, DebugFileWrapper logFile, boolean debug) {
        Item item = heldItemStack.func_77973_b();
        String toolClass = ruleMatchHarvesterHeldItemMainHand._toolClass;
        if (toolClass != null) {
            int harvestLevel = item.getHarvestLevel(heldItemStack, toolClass, harvester, blockState);
            if (ruleMatchHarvesterHeldItemMainHand.type == EnumListType.WHITELIST) {
                Set toolClasses = item.getToolClasses(heldItemStack);
                if (!toolClasses.contains(toolClass)) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Held item doesn't have required tool class: " + toolClass);
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Held item has required tool class: " + toolClass);
                }
                if (harvestLevel < ruleMatchHarvesterHeldItemMainHand._minHarvestLevel || harvestLevel > ruleMatchHarvesterHeldItemMainHand._maxHarvestLevel) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Harvest tool outside of level range");
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Harvest tool inside of level range");
                }
            } else {
                Set toolClasses = item.getToolClasses(heldItemStack);
                boolean harvestLevelInRange = harvestLevel >= ruleMatchHarvesterHeldItemMainHand._minHarvestLevel && harvestLevel <= ruleMatchHarvesterHeldItemMainHand._maxHarvestLevel;
                boolean toolClassMatches = toolClasses.contains(toolClass);
                if (toolClassMatches && harvestLevelInRange) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Held item is excluded: " + toolClass + ";" + harvestLevel);
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Held item isn't excluded: " + toolClass + ";" + harvestLevel);
                }
            }
        }
        return this.checkItemList(ruleMatchHarvesterHeldItemMainHand, heldItemStack, logFile, debug);
    }

    private boolean checkItemList(RuleMatchHarvesterHeldItemMainHand ruleMatchHarvesterHeldItemMainHand, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        if (ruleMatchHarvesterHeldItemMainHand._items.isEmpty()) {
            if (debug) {
                logFile.debug("[MATCH] [OK] No item entries in heldItemMainHand to match");
            }
            return true;
        }
        if (ruleMatchHarvesterHeldItemMainHand.type == EnumListType.WHITELIST) {
            return this.checkAsWhitelist(ruleMatchHarvesterHeldItemMainHand, heldItemStack, logFile, debug);
        }
        return this.checkAsBlacklist(ruleMatchHarvesterHeldItemMainHand, heldItemStack, logFile, debug);
    }

    private boolean checkAsWhitelist(RuleMatchHarvesterHeldItemMainHand ruleMatchHarvesterHeldItemMainHand, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        Item heldItem = heldItemStack.func_77973_b();
        int metadata = heldItemStack.func_77960_j();
        for (ItemStack itemStack : ruleMatchHarvesterHeldItemMainHand._items) {
            if (itemStack.func_77973_b() != heldItem) {
                if (!debug) continue;
                logFile.debug(String.format("[MATCH] [!!] HeldItemMainHand item mismatch: (match) %s != %s (candidate)", itemStack.func_77973_b(), heldItem));
                continue;
            }
            if (debug) {
                logFile.debug(String.format("[MATCH] [OK] HeldItemMainHand item match: (match) %s == %s (candidate)", itemStack.func_77973_b(), heldItem));
            }
            if (itemStack.func_77960_j() == Short.MAX_VALUE || itemStack.func_77960_j() == metadata) {
                if (debug) {
                    logFile.debug(String.format("[MATCH] [OK] HeldItemMainHand meta match: (match) %d == %d (candidate)", itemStack.func_77960_j(), metadata));
                    logFile.debug("[MATCH] [OK] Found heldItemMainHand match in whitelist");
                }
                return true;
            }
            if (!debug) continue;
            logFile.debug(String.format("[MATCH] [!!] HeldItemMainHand meta mismatch: (match) %d != %d (candidate)", itemStack.func_77960_j(), metadata));
        }
        if (debug) {
            logFile.debug("[MATCH] [!!] Unable to find heldItemMainHand match in whitelist");
        }
        return false;
    }

    private boolean checkAsBlacklist(RuleMatchHarvesterHeldItemMainHand ruleMatchHarvesterHeldItemMainHand, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        Item heldItem = heldItemStack.func_77973_b();
        int metadata = heldItemStack.func_77960_j();
        for (ItemStack itemStack : ruleMatchHarvesterHeldItemMainHand._items) {
            if (itemStack.func_77973_b() != heldItem) {
                if (!debug) continue;
                logFile.debug(String.format("[MATCH] [OK] HeldItemMainHand item mismatch: (match) %s != %s (candidate)", itemStack.func_77973_b(), heldItem));
                continue;
            }
            if (debug) {
                logFile.debug(String.format("[MATCH] [!!] HeldItemMainHand item match: (match) %s == %s (candidate)", itemStack.func_77973_b(), heldItem));
            }
            if (itemStack.func_77960_j() == Short.MAX_VALUE || itemStack.func_77960_j() == metadata) {
                if (debug) {
                    logFile.debug(String.format("[MATCH] [!!] HeldItemMainHand meta match: (match) %d == %d (candidate)", itemStack.func_77960_j(), metadata));
                    logFile.debug("[MATCH] [!!] Found heldItemMainHand match in blacklist");
                }
                return false;
            }
            if (!debug) continue;
            logFile.debug(String.format("[MATCH] [OK] HeldItemMainHand meta mismatch: (match) %d != %d (candidate)", itemStack.func_77960_j(), metadata));
        }
        if (debug) {
            logFile.debug("[MATCH] [OK] Unable to find heldItemMainHand match in blacklist");
        }
        return true;
    }
}

