/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.api.reference.EnumHarvesterType;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatchHarvester;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.GameStageMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemCache;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemMainHandMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.PlayerNameMatcher;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;

public class HarvesterMatcher {
    private GameStageMatcher gameStageMatcher;
    private HeldItemMainHandMatcher heldItemMainHandMatcher;
    private PlayerNameMatcher playerNameMatcher;

    public HarvesterMatcher(GameStageMatcher gameStageMatcher, HeldItemMainHandMatcher heldItemMainHandMatcher, PlayerNameMatcher playerNameMatcher) {
        this.gameStageMatcher = gameStageMatcher;
        this.heldItemMainHandMatcher = heldItemMainHandMatcher;
        this.playerNameMatcher = playerNameMatcher;
    }

    public boolean matches(RuleMatchHarvester ruleMatchHarvester, HeldItemCache heldItemCache, @Nullable EntityPlayer harvester, IBlockState blockState, boolean isExplosion, DebugFileWrapper logFile, boolean debug) {
        if (debug) {
            logFile.debug("[MATCH] [--] Harvester type: " + (Object)((Object)ruleMatchHarvester.type));
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.ANY) {
            if (harvester != null) {
                boolean result;
                if (debug) {
                    logFile.debug("[MATCH] [--] Harvester detected, checking harvester: " + harvester);
                }
                boolean bl = result = this.heldItemMainHandMatcher.matches(ruleMatchHarvester.heldItemMainHand, heldItemCache.get(harvester.func_70005_c_()), blockState, harvester, logFile, debug) && this.playerNameMatcher.matches(ruleMatchHarvester.playerName, harvester.func_70005_c_(), logFile, debug) && this.gameStageMatcher.matches(ruleMatchHarvester.gamestages, harvester, logFile, debug);
                if (debug) {
                    if (result) {
                        logFile.debug("[MATCH] [OK] Harvester matching passed");
                    } else {
                        logFile.debug("[MATCH] [!!] Harvester matching failed");
                    }
                }
                return result;
            }
            if (debug) {
                logFile.debug("[MATCH] [OK] No harvester detected");
            }
            return true;
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.NON_PLAYER) {
            boolean result;
            boolean bl = result = harvester == null;
            if (debug) {
                if (result) {
                    logFile.debug("[MATCH] [OK] Harvester is null");
                } else {
                    logFile.debug("[MATCH] [!!] Harvester is not null: " + harvester);
                }
            }
            return result;
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.PLAYER) {
            boolean result;
            if (harvester == null) {
                if (debug) {
                    logFile.debug("[MATCH] [!!] Harvester is null");
                }
                return false;
            }
            if (debug) {
                logFile.debug("[MATCH] [--] Harvester detected, checking harvester: " + harvester);
            }
            boolean bl = result = this.heldItemMainHandMatcher.matches(ruleMatchHarvester.heldItemMainHand, heldItemCache.get(harvester.func_70005_c_()), blockState, harvester, logFile, debug) && this.playerNameMatcher.matches(ruleMatchHarvester.playerName, harvester.func_70005_c_(), logFile, debug) && this.gameStageMatcher.matches(ruleMatchHarvester.gamestages, harvester, logFile, debug);
            if (debug) {
                if (result) {
                    logFile.debug("[MATCH] [OK] Harvester matching passed");
                } else {
                    logFile.debug("[MATCH] [!!] Harvester matching failed");
                }
            }
            return result;
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.EXPLOSION) {
            if (debug) {
                if (isExplosion) {
                    logFile.debug("[MATCH] [OK] Harvester is an explosion");
                } else {
                    logFile.debug("[MATCH] [!!] Harvester is not an explosion: " + harvester);
                }
            }
            return isExplosion;
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.REAL_PLAYER) {
            if (harvester == null) {
                if (debug) {
                    logFile.debug("[MATCH] [!!] Harvester is null");
                }
                return false;
            }
            boolean realPlayer = this.isRealPlayer((Entity)harvester);
            if (debug) {
                if (realPlayer) {
                    logFile.debug("[MATCH] [OK] Harvester is a real player");
                } else {
                    logFile.debug("[MATCH] [!!] Harvester is not a real player: " + harvester);
                }
            }
            return realPlayer;
        }
        if (ruleMatchHarvester.type == EnumHarvesterType.FAKE_PLAYER) {
            if (harvester == null) {
                if (debug) {
                    logFile.debug("[MATCH] [!!] Harvester is null");
                }
                return false;
            }
            boolean fakePlayer = this.isFakePlayer((Entity)harvester);
            if (debug) {
                if (fakePlayer) {
                    logFile.debug("[MATCH] [OK] Harvester is a fake player");
                } else {
                    logFile.debug("[MATCH] [!!] Harvester is not a fake player: " + harvester);
                }
            }
            return fakePlayer;
        }
        return false;
    }

    private boolean isFakePlayer(Entity entity) {
        GameProfile gameProfile;
        UUID gameProfileId;
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        WorldServer worldServer = DimensionManager.getWorld((int)0);
        MinecraftServer minecraftServer = worldServer.func_73046_m();
        if (minecraftServer == null) {
            return false;
        }
        PlayerList playerList = minecraftServer.func_184103_al();
        EntityPlayerMP playerByUUID = playerList.func_177451_a(gameProfileId = (gameProfile = ((EntityPlayer)entity).func_146103_bH()).getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    private boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        return !this.isFakePlayer(entity);
    }
}

