/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.util.Injector;
import com.codetaylor.mc.dropt.api.DropBuilder;
import com.codetaylor.mc.dropt.api.DroptAPI;
import com.codetaylor.mc.dropt.api.HarvesterRuleBuilder;
import com.codetaylor.mc.dropt.api.RuleBuilder;
import com.codetaylor.mc.dropt.api.RuleRegistrationHandler;
import com.codetaylor.mc.dropt.modules.dropt.ConsoleLog;
import com.codetaylor.mc.dropt.modules.dropt.LogFileWriterProvider;
import com.codetaylor.mc.dropt.modules.dropt.ModuleDroptConfig;
import com.codetaylor.mc.dropt.modules.dropt.Util;
import com.codetaylor.mc.dropt.modules.dropt.command.Command;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.CTCompatEventHandler;
import com.codetaylor.mc.dropt.modules.dropt.events.EventHandler;
import com.codetaylor.mc.dropt.modules.dropt.rule.ProfileUtil;
import com.codetaylor.mc.dropt.modules.dropt.rule.RuleLoader;
import com.codetaylor.mc.dropt.modules.dropt.rule.RuleLocator;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.drop.DropModifier;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.LoggerWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.BiomeMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.BlockMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.DimensionMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.DropMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.ExperienceCache;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.GameStageMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HarvesterMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemCache;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemMainHandMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.PlayerNameMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.RuleMatcherFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleDropt
extends ModuleBase {
    public static final String MOD_ID = "dropt";
    public static final List<RuleList> RULE_LISTS = new ArrayList<RuleList>();
    public static final Map<IBlockState, List<Rule>> RULE_CACHE = new HashMap<IBlockState, List<Rule>>();
    public static Logger LOGGER;
    public static boolean MOD_GAMESTAGES;
    public static Path RULE_PATH;
    public static Path LOG_PATH;
    public static LogFileWriterProvider LOG_FILE_WRITER_PROVIDER;
    public static ConsoleLog CONSOLE_LOG;
    private final RuleRegistrationHandler ruleRegistrationHandler;

    public ModuleDropt() {
        super(0, MOD_ID);
        String[] plugins;
        for (String plugin : plugins = new String[]{"ZenDrop", "ZenDropt", "ZenHarvester", "ZenRange", "ZenRule", "ZenRuleList", "ZenWeight"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker." + plugin);
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler(new RuleLocator(new RuleMatcherFactory(new BlockMatcher(), new DropMatcher(), new HarvesterMatcher(new GameStageMatcher(), new HeldItemMainHandMatcher(), new PlayerNameMatcher()), new BiomeMatcher(), new DimensionMatcher()), RULE_CACHE), new DropModifier(), new HeldItemCache(new HashMap<String, ItemStack>()), new ExperienceCache(new HashMap<String, Integer>()), new HashSet<BlockPos>()));
        CONSOLE_LOG = new ConsoleLog(new HashSet<EntityPlayer>(), new LinkedHashMap<String, Integer>());
        this.ruleRegistrationHandler = new RuleRegistrationHandler(RULE_LISTS);
    }

    public void onConstructionEvent(FMLConstructionEvent event) {
        super.onConstructionEvent(event);
        Injector injector = new Injector();
        injector.inject(DroptAPI.class, "SUPPLIER_MOD_ID", () -> MOD_ID);
        injector.inject(DroptAPI.class, "SUPPLIER_RULE_BUILDER", RuleBuilder::new);
        injector.inject(DroptAPI.class, "SUPPLIER_HARVESTER_RULE_BUILDER", HarvesterRuleBuilder::new);
        injector.inject(DroptAPI.class, "SUPPLIER_DROP_BUILDER", DropBuilder::new);
        injector.inject(DroptAPI.class, "CONSUMER_RULE", (Object)this.ruleRegistrationHandler);
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onPreInitializationEvent(event);
        if (Loader.isModLoaded((String)"crafttweaker")) {
            MinecraftForge.EVENT_BUS.register((Object)new CTCompatEventHandler());
        }
        MOD_GAMESTAGES = Loader.isModLoaded((String)"gamestages");
        LOGGER = LogManager.getLogger((String)("dropt." + ((Object)((Object)this)).getClass().getSimpleName()));
        File configDir = event.getModConfigurationDirectory();
        RULE_PATH = configDir.toPath().resolve(MOD_ID);
        try {
            Files.createDirectories(RULE_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        LOG_PATH = configDir.toPath().resolve("../dropt.log");
        if (Files.exists(LOG_PATH, new LinkOption[0]) && Files.isRegularFile(LOG_PATH, new LinkOption[0])) {
            try {
                Files.delete(LOG_PATH);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        LOG_FILE_WRITER_PROVIDER = new LogFileWriterProvider(LOG_PATH, LOGGER);
        FileWriter logFileWriter = LOG_FILE_WRITER_PROVIDER.createLogFileWriter();
        DebugFileWrapper debugFileWrapper = new DebugFileWrapper(logFileWriter);
        RuleLoader.loadRuleLists(RULE_PATH, RULE_LISTS, new LoggerWrapper(LOGGER, logFileWriter), debugFileWrapper);
        debugFileWrapper.close();
    }

    public void onLoadCompleteEvent(FMLLoadCompleteEvent event) {
        super.onLoadCompleteEvent(event);
        FileWriter logFileWriter = LOG_FILE_WRITER_PROVIDER.createLogFileWriter();
        DebugFileWrapper debugFileWrapper = new DebugFileWrapper(logFileWriter);
        if (ModuleDroptConfig.INJECT_PROFILING_RULES) {
            ProfileUtil.injectRules(RULE_LISTS, debugFileWrapper);
        }
        RuleLoader.parseRuleLists(RULE_LISTS, new LoggerWrapper(LOGGER, logFileWriter), debugFileWrapper);
        Util.closeSilently(logFileWriter);
    }

    public void onServerStartingEvent(FMLServerStartingEvent event) {
        super.onServerStartingEvent(event);
        event.registerServerCommand((ICommand)new Command());
    }
}

