/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import java.util.List;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Logging;
import mcjty.rftools.ForgeEventHandlers;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ChargedPorterItem
extends GenericRFToolsItem
implements IEnergyItem,
INBTPreservingIngredient {
    private int capacity;
    private int maxReceive;
    private int maxExtract;

    public ChargedPorterItem() {
        this("charged_porter");
    }

    protected ChargedPorterItem(String name) {
        this(name, TeleportConfiguration.CHARGEDPORTER_MAXENERGY);
    }

    protected ChargedPorterItem(String name, int capacity) {
        super(name);
        this.capacity = capacity;
        this.func_77625_d(1);
        this.maxReceive = TeleportConfiguration.CHARGEDPORTER_RECEIVEPERTICK;
        this.maxExtract = 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_190926_b() != newStack.func_190926_b()) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                return;
            }
            if (!tagCompound.func_74764_b("tpTimer")) {
                return;
            }
            if (!(entityIn instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityIn;
            int timer = tagCompound.func_74762_e("tpTimer");
            if (--timer <= 0) {
                tagCompound.func_82580_o("tpTimer");
                TeleportDestinations destinations = TeleportDestinations.getDestinations(worldIn);
                int target = tagCompound.func_74762_e("target");
                GlobalCoordinate coordinate = destinations.getCoordinateForId(target);
                if (coordinate == null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Something went wrong! The target has disappeared!"));
                    TeleportationTools.applyEffectForSeverity(player, 3, false);
                    return;
                }
                TeleportDestination destination = destinations.getDestination(coordinate);
                ForgeEventHandlers.addPlayerToTeleportHere(destination, player);
            } else {
                tagCompound.func_74768_a("tpTimer", timer);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 8; ++i) {
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(domain, path + i), "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            int level;
            NBTTagCompound tagCompound = stack.func_77978_p();
            int energy = 0;
            if (tagCompound != null) {
                energy = tagCompound.func_74762_e("Energy");
            }
            if ((level = 9 * energy / this.capacity) < 0) {
                level = 0;
            } else if (level > 8) {
                level = 8;
            }
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            return new ModelResourceLocation(new ResourceLocation(domain, path + (8 - level)), "inventory");
        });
    }

    protected int getSpeedBonus() {
        return 1;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            this.startTeleport(stack, player, world);
        } else {
            this.selectReceiver(stack, world, player);
        }
        return super.func_77659_a(world, player, hand);
    }

    protected void selectReceiver(ItemStack stack, World world, EntityPlayer player) {
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            TileEntity te = world.func_175625_s(pos);
            this.setTarget(stack, player, world, te);
        } else {
            this.startTeleport(stack, player, world);
        }
        return EnumActionResult.SUCCESS;
    }

    private void startTeleport(ItemStack stack, EntityPlayer player, World world) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("target") || tagCompound.func_74762_e("target") == -1) {
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The charged porter has no target."));
            }
            return;
        }
        if (!world.field_72995_K) {
            if (tagCompound.func_74764_b("tpTimer")) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Already teleporting!"));
                return;
            }
            int target = tagCompound.func_74762_e("target");
            TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
            GlobalCoordinate coordinate = destinations.getCoordinateForId(target);
            if (coordinate == null) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Something went wrong! The target has disappeared!"));
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (!TeleportationTools.checkValidTeleport(player, world.field_73011_w.getDimension(), destination.getDimension())) {
                return;
            }
            BlockPos playerCoordinate = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            int cost = TeleportationTools.calculateRFCost(world, playerCoordinate, destination);
            long energy = this.getEnergyStoredL(stack);
            if ((long)(cost = (int)((float)cost * 1.5f)) > energy) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Not enough energy to start the teleportation!"));
                return;
            }
            this.extractEnergyNoMax(stack, cost, false);
            int ticks = TeleportationTools.calculateTime(world, playerCoordinate, destination);
            tagCompound.func_74768_a("tpTimer", ticks /= this.getSpeedBonus());
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Start teleportation!"));
        }
    }

    private void setTarget(ItemStack stack, EntityPlayer player, World world, TileEntity te) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        int id = -1;
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            if (!matterReceiverTileEntity.checkAccess(player.func_70005_c_())) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You have no access to target this receiver!"));
                return;
            }
            id = matterReceiverTileEntity.getId();
        }
        if (id != -1) {
            this.selectOnReceiver(player, world, tagCompound, id);
        } else {
            this.selectOnThinAir(player, world, tagCompound, stack);
        }
        stack.func_77982_d(tagCompound);
    }

    protected void selectOnReceiver(EntityPlayer player, World world, NBTTagCompound tagCompound, int id) {
        if (world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)("Charged porter target is set to " + id + "."));
        }
        tagCompound.func_74768_a("target", id);
    }

    protected void selectOnThinAir(EntityPlayer player, World world, NBTTagCompound tagCompound, ItemStack stack) {
        if (world.field_72995_K) {
            Logging.message((EntityPlayer)player, (String)"Charged porter is cleared.");
        }
        tagCompound.func_82580_o("target");
    }

    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
            if (tagCompound.func_74764_b("target")) {
                list.add(TextFormatting.BLUE + "Target: " + tagCompound.func_74762_e("target"));
            } else {
                list.add(TextFormatting.RED + "No target set! Sneak-Right click on receiver to set.");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This RF/charged item allows you to teleport to a");
            list.add("previously set matter receiver. Sneak-right click");
            list.add("on a receiver to set the destination.");
            list.add("Right click to perform the teleport.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, EnergyTools.unsignedClampToInt((long)maxExtract)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int extractEnergyNoMax(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }
}

