/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.item;

import com.timwoodcreates.roost.data.DataChicken;
import com.timwoodcreates.roost.tileentity.TileEntityRoost;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChicken
extends Item {
    private static String I18N_NAME = "entity.Chicken.name";

    public ItemChicken() {
        this.func_77625_d(16);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            DataChicken.getItemChickenSubItems(tab, subItems);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        DataChicken data = DataChicken.getDataFromStack(stack);
        if (data != null) {
            data.addInfoToTooltip(tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        DataChicken data = DataChicken.getDataFromStack(stack);
        if (data == null) {
            return I18n.func_135052_a((String)I18N_NAME, (Object[])new Object[0]);
        }
        return data.getDisplayName();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null && tileEntity instanceof TileEntityRoost) {
                this.putChickenIn(playerIn.func_184586_b(hand), (TileEntityRoost)tileEntity);
            } else {
                this.spawnChicken(playerIn.func_184586_b(hand), playerIn, worldIn, pos.func_177972_a(facing));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void putChickenIn(ItemStack stack, TileEntityRoost tileEntity) {
        tileEntity.putChickenIn(stack);
    }

    private void spawnChicken(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos) {
        DataChicken chickenData = DataChicken.getDataFromStack(stack);
        if (chickenData == null) {
            return;
        }
        chickenData.spawnEntity(worldIn, pos);
        stack.func_190918_g(1);
    }
}

