/*
 * Decompiled with CFR 0.152.
 */
package shadows.spawn.modifiers;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.config.Configuration;
import shadows.spawn.SpawnerModifiers;
import shadows.spawn.TileSpawnerExt;

public abstract class SpawnerModifier {
    public static final String ITEM = "item";
    public static final String VALUE = "value";
    protected Ingredient item;
    protected int value;

    public SpawnerModifier(Ingredient item, int value) {
        this.item = item;
        this.value = value;
    }

    public SpawnerModifier(ItemStack item, int value) {
        this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item}), value);
    }

    public boolean canModify(TileSpawnerExt spawner, ItemStack stack, boolean inverting) {
        return this.item.apply(stack);
    }

    public abstract boolean modify(TileSpawnerExt var1, ItemStack var2, boolean var3);

    public void load(Configuration cfg) {
        String s = cfg.getString(ITEM, this.getCategory(), this.getDefaultItem(), "The item that applies this modifier.");
        this.item = SpawnerModifiers.readStackCfg(s);
        this.value = cfg.getInt(VALUE, this.getCategory(), this.value, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount each item changes this stat.");
    }

    public Ingredient getIngredient() {
        return this.item;
    }

    public int getValue() {
        return this.value;
    }

    public void setIngredient(Ingredient item) {
        this.item = item;
    }

    public abstract String getCategory();

    public abstract String getDefaultItem();
}

