/*
 * Decompiled with CFR 0.152.
 */
package shadows.spawn;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;

public class TileSpawnerExt
extends TileEntityMobSpawner {
    public boolean ignoresPlayers = false;
    public boolean ignoresConditions = false;
    public boolean ignoresCap = false;
    public boolean redstoneEnabled = false;

    public TileSpawnerExt() {
        this.field_145882_a = new SpawnerLogicExt();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("ignore_players", this.ignoresPlayers);
        tag.func_74757_a("ignore_conditions", this.ignoresConditions);
        tag.func_74757_a("ignore_cap", this.ignoresPlayers);
        tag.func_74757_a("redstone_control", this.redstoneEnabled);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.ignoresPlayers = tag.func_74767_n("ignore_players");
        this.ignoresConditions = tag.func_74767_n("ignore_conditions");
        this.ignoresCap = tag.func_74767_n("ignore_cap");
        this.redstoneEnabled = tag.func_74767_n("redstone_control");
        super.func_145839_a(tag);
    }

    public void setIgnoresPlayers(boolean val) {
        this.ignoresPlayers = val;
    }

    public void setIgnoresConditions(boolean val) {
        this.ignoresConditions = val;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public class SpawnerLogicExt
    extends MobSpawnerBaseLogic {
        public void func_98267_a(int id) {
            TileSpawnerExt.this.field_145850_b.func_175641_c(TileSpawnerExt.this.field_174879_c, Blocks.field_150474_ac, id, 0);
        }

        public World func_98271_a() {
            return TileSpawnerExt.this.field_145850_b;
        }

        public BlockPos func_177221_b() {
            return TileSpawnerExt.this.field_174879_c;
        }

        public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
            super.func_184993_a(p_184993_1_);
            if (this.func_98271_a() != null) {
                IBlockState iblockstate = this.func_98271_a().func_180495_p(this.func_177221_b());
                this.func_98271_a().func_184138_a(TileSpawnerExt.this.field_174879_c, iblockstate, iblockstate, 4);
            }
        }

        private boolean isActivated() {
            BlockPos blockpos = this.func_177221_b();
            boolean flag = TileSpawnerExt.this.ignoresPlayers || this.func_98271_a().func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.field_98289_l);
            return flag && (!TileSpawnerExt.this.redstoneEnabled || TileSpawnerExt.this.field_145850_b.func_175640_z(blockpos));
        }

        private void resetTimer() {
            if (this.field_98293_h <= this.field_98283_g) {
                this.field_98286_b = this.field_98283_g;
            } else {
                int i = this.field_98293_h - this.field_98283_g;
                this.field_98286_b = this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(i);
            }
            if (!this.field_98285_e.isEmpty()) {
                this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, (List)this.field_98285_e));
            }
            this.func_98267_a(1);
        }

        public void func_98278_g() {
            if (!this.isActivated()) {
                this.field_98284_d = this.field_98287_c;
            } else {
                BlockPos blockpos = this.func_177221_b();
                if (this.func_98271_a().field_72995_K) {
                    double d3 = (float)blockpos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
                    double d4 = (float)blockpos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
                    double d5 = (float)blockpos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
                    this.func_98271_a().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                    this.func_98271_a().func_175688_a(EnumParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                    }
                    this.field_98284_d = this.field_98287_c;
                    this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
                } else {
                    if (this.field_98286_b == -1) {
                        this.resetTimer();
                    }
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                        return;
                    }
                    boolean flag = false;
                    for (int i = 0; i < this.field_98294_i; ++i) {
                        int k;
                        Entity entity;
                        double z;
                        NBTTagCompound tag = this.field_98282_f.func_185277_b();
                        NBTTagList posList = tag.func_150295_c("Pos", 6);
                        World world = this.func_98271_a();
                        int j = posList.func_74745_c();
                        double x = j >= 1 ? posList.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        double y = j >= 2 ? posList.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                        double d = z = j >= 3 ? posList.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        if (tag.func_74764_b("Offset")) {
                            NBTTagList offsets = tag.func_150295_c("Offset", 6);
                            j = posList.func_74745_c();
                            x = j >= 1 ? (double)this.func_177221_b().func_177958_n() + offsets.func_150309_d(0) : x;
                            y = j >= 2 ? (double)this.func_177221_b().func_177956_o() + offsets.func_150309_d(1) : y;
                            double d2 = z = j >= 3 ? (double)this.func_177221_b().func_177952_p() + offsets.func_150309_d(2) : z;
                        }
                        if ((entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)tag, (World)world, (double)x, (double)y, (double)z, (boolean)false)) == null) {
                            return;
                        }
                        if (!TileSpawnerExt.this.ignoresCap && (k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.field_98290_m)).size()) >= this.field_98292_k) {
                            this.resetTimer();
                            return;
                        }
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entityliving != null && !TileSpawnerExt.this.ignoresConditions && !ForgeEventFactory.canEntitySpawnSpawner((EntityLiving)entityliving, (World)this.func_98271_a(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (MobSpawnerBaseLogic)this)) continue;
                        if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8) && entity instanceof EntityLiving && !ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)this.func_98271_a(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (MobSpawnerBaseLogic)this)) {
                            ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                        }
                        AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
                        world.func_175718_b(2004, blockpos, 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.resetTimer();
                    }
                }
            }
        }
    }
}

