/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.config;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import shadows.deadly.DeadlyModule;
import shadows.deadly.config.DeadlyConstants;

public class DeadlyConfig {
    public static final IntList DIM_WHITELIST = new IntArrayList();
    public static final List<PotionEffect> BRUTAL_POTIONS = new ArrayList<PotionEffect>();
    public static List<Pair<Integer, ResourceLocation>> BRUTAL_MOBS = new ArrayList<Pair<Integer, ResourceLocation>>();
    public static List<Pair<Integer, ResourceLocation>> BOSS_MOBS = new ArrayList<Pair<Integer, ResourceLocation>>();
    public static List<Pair<Integer, ResourceLocation>> SWARM_MOBS = new ArrayList<Pair<Integer, ResourceLocation>>();
    public static Configuration config;
    public static int bossRegenLevel;
    public static int bossResistLevel;
    public static boolean bossFireRes;
    public static boolean bossWaterBreathing;
    public static float bossHealthMultiplier;
    public static float bossKnockbackResist;
    public static float bossSpeedMultiplier;
    public static float bossDamageBonus;
    public static float bossLevelUpChance;
    public static float bossEnchantChance;
    public static float bossPotionChance;
    public static float brutalSpawnerChance;
    public static float swarmSpawnerChance;
    public static float bossChance;
    public static float dungeonBrutalChance;
    public static float dungeonSwarmChance;

    public static void init() {
        String[] swarmFromCfg;
        String[] bossFromCfg;
        String[] brutalFromCfg;
        String[] dims;
        Configuration c = config;
        c.load();
        DeadlyConstants.BRUTAL_SPAWNER_STATS.load(c);
        DeadlyConstants.SWARM_SPAWNER_STATS.load(c);
        for (String s : dims = c.getStringList("Generation Dimension Whitelist", "general", new String[]{"0"}, "The dimensions that the deadly module will generate in.")) {
            try {
                DIM_WHITELIST.add(Integer.parseInt(s.trim()));
            }
            catch (NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid dim whitelist entry: " + s + ".  It will be ignored!  (Not a number)");
            }
        }
        bossRegenLevel = c.getInt("Regen Level", "Bosses", bossRegenLevel, 0, Integer.MAX_VALUE, "The regeneration level of bosses.  Set to 0 to disable.");
        bossResistLevel = c.getInt("Resistance Level", "Bosses", bossResistLevel, 0, Integer.MAX_VALUE, "The resistance level of bosses.  Set to 0 to disable.");
        bossFireRes = c.getBoolean("Fire Resistance", "Bosses", true, "If bosses have fire resistance.");
        bossWaterBreathing = c.getBoolean("Water Breathing", "Bosses", true, "If bosses have water breathing.");
        bossHealthMultiplier = c.getFloat("Health Multiplier", "Bosses", bossHealthMultiplier, 0.0f, 2.1474836E9f, "The amount boss health is multiplied by.  Base hp * factor = final hp.");
        bossKnockbackResist = c.getFloat("Knockback Resist", "Bosses", bossKnockbackResist, 0.0f, 2.1474836E9f, "The amount of knockback resist bosses have.");
        bossSpeedMultiplier = c.getFloat("Speed Multiplier", "Bosses", bossSpeedMultiplier, 0.0f, 2.1474836E9f, "The amount boss speed is multiplied by.  Base speed * factor = final speed.");
        bossDamageBonus = c.getFloat("Damage Bonus", "Bosses", bossDamageBonus, 0.0f, 2.1474836E9f, "The amount of extra damage bosses do, in half hearts.");
        bossLevelUpChance = c.getFloat("Level Up Chance", "Bosses", bossLevelUpChance, 0.0f, 2.1474836E9f, "The level up chance, this is rolled once per number of levels.  Levels determine gear.");
        bossEnchantChance = c.getFloat("Random Enchantment Chance", "Bosses", bossEnchantChance, 0.0f, 2.1474836E9f, "The chance a gear piece will be randomly enchanted.");
        bossPotionChance = c.getFloat("Random Potion Chance", "Bosses", bossPotionChance, 0.0f, 2.1474836E9f, "The chance a boss will have extra random potion effects.");
        brutalSpawnerChance = c.getFloat("Brutal Spawner Chance", "Frequencies", brutalSpawnerChance, 0.0f, 1.0f, "The chance (per chunk) for a brutal spawner to try spawning.");
        swarmSpawnerChance = c.getFloat("Swarm Spawner Chance", "Frequencies", swarmSpawnerChance, 0.0f, 1.0f, "The chance (per chunk) for a swarm spawner to try spawning.");
        bossChance = c.getFloat("Boss Chance", "Frequencies", bossChance, 0.0f, 1.0f, "The chance (per chunk) for a boss to try spawning.");
        dungeonBrutalChance = c.getFloat("Dungeon Brutal Chance", "Dungeons", dungeonBrutalChance, 0.0f, 1.0f, "The chance for a dungeon to have a brutal spawner.");
        dungeonSwarmChance = c.getFloat("Dungeon Swarm Chance", "Dungeons", dungeonSwarmChance, 0.0f, 1.0f, "The chance for a dungeon to have a swarm spawner.");
        for (String s : brutalFromCfg = c.getStringList("Brutal Spawner Mobs", "Brutal Spawners", DeadlyConstants.BRUTAL_DEFAULT_MOBS, "The possible spawn entries for brutal spawners.  Format is weight@entity, entity is a registry name.  apotheosis:random is a special name, used to generate a spawner that spawns any mob.")) {
            String[] split = s.split("@");
            try {
                int weight = Integer.parseInt(split[0]);
                ResourceLocation name = new ResourceLocation(split[1]);
                EntityEntry e = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
                if (weight > 0 && (e != null || name.equals((Object)DeadlyConstants.RANDOM))) {
                    BRUTAL_MOBS.add((Pair<Integer, ResourceLocation>)Pair.of((Object)weight, (Object)name));
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid brutal spawner entry: " + s + ".  It will be ignored! (Weight <= 0 or Entity does not exist)");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid brutal spawner entry: " + s + ".  It will be ignored!  (Invalid format)");
            }
        }
        for (String s : bossFromCfg = c.getStringList("Boss Spawner Mobs", "Bosses", DeadlyConstants.BOSS_DEFAULT_MOBS, "The possible mob types for bosses.  Format is weight@entity, entity is a registry name.")) {
            String[] split = s.split("@");
            try {
                int weight = Integer.parseInt(split[0]);
                ResourceLocation name = new ResourceLocation(split[1]);
                EntityEntry e = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
                if (weight > 0 && e != null) {
                    BOSS_MOBS.add((Pair<Integer, ResourceLocation>)Pair.of((Object)weight, (Object)name));
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid boss entry: " + s + ".  It will be ignored! (Weight <= 0 or Entity does not exist)");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid boss entry: " + s + ".  It will be ignored!  (Invalid format)");
            }
        }
        for (String s : swarmFromCfg = c.getStringList("Swarm Spawner Mobs", "Swarm Spawners", DeadlyConstants.SWARM_DEFAULT_MOBS, "The possible spawn entries for swarm spawners.  Format is weight@entity, entity is a registry name.")) {
            String[] split = s.split("@");
            try {
                int weight = Integer.parseInt(split[0]);
                ResourceLocation name = new ResourceLocation(split[1]);
                EntityEntry e = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
                if (weight > 0 && (e != null || name.equals((Object)DeadlyConstants.RANDOM))) {
                    SWARM_MOBS.add((Pair<Integer, ResourceLocation>)Pair.of((Object)weight, (Object)name));
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid swarm spawner entry: " + s + ".  It will be ignored! (Weight <= 0 or Entity does not exist)");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid swarm spawner entry: " + s + ".  It will be ignored!  (Invalid format)");
            }
        }
        String[] brutalPotions = c.getStringList("Brutal Potion Effects", "Brutal Spawners", DeadlyConstants.BRUTAL_POTIONS, "The potion effects applied to all brutal mobs.  Format is potion@level, potion is a registry name.");
        for (String s : brutalPotions) {
            String[] split = s.split("@");
            try {
                int level = Math.max(1, Integer.parseInt(split[1]));
                ResourceLocation name = new ResourceLocation(split[0]);
                Potion p = (Potion)ForgeRegistries.POTIONS.getValue(name);
                if (p != null) {
                    BRUTAL_POTIONS.add(new PotionEffect(p, Integer.MAX_VALUE, level - 1));
                    continue;
                }
                DeadlyModule.LOGGER.error("Invalid brutal potion entry: " + s + ".  It will be ignored! (Potion does not exist)");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                DeadlyModule.LOGGER.error("Invalid brutal potion entry: " + s + ".  It will be ignored! (Invalid format)");
            }
        }
        for (EntityEntry e : ForgeRegistries.ENTITIES) {
            if (!IMob.class.isAssignableFrom(e.getEntityClass())) continue;
            config.getInt(e.getRegistryName().toString(), "Random Spawners", e.getRegistryName().func_110624_b().equals("minecraft") ? 8 : 1, 0, 50, "");
        }
        if (c.hasChanged()) {
            c.save();
        }
    }

    public static int getWeightForEntry(EntityEntry e) {
        return config.getInt(e.getRegistryName().toString(), "Random Spawners", e.getRegistryName().func_110624_b().equals("minecraft") ? 8 : 1, 0, 50, "");
    }

    static {
        bossRegenLevel = 2;
        bossResistLevel = 1;
        bossFireRes = true;
        bossWaterBreathing = true;
        bossHealthMultiplier = 4.0f;
        bossKnockbackResist = 0.85f;
        bossSpeedMultiplier = 1.15f;
        bossDamageBonus = 4.0f;
        bossLevelUpChance = 0.25f;
        bossEnchantChance = 0.25f;
        bossPotionChance = 0.45f;
        brutalSpawnerChance = 0.12f;
        swarmSpawnerChance = 0.15f;
        bossChance = 0.08f;
        dungeonBrutalChance = 0.05f;
        dungeonSwarmChance = 0.1f;
    }
}

