/*
 * Decompiled with CFR 0.152.
 */
package shadows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.Apotheosis;
import shadows.ApotheosisObjects;
import shadows.ench.EnchModule;
import shadows.ench.ItemTypedBook;
import shadows.ench.altar.RenderPrismaticAltar;
import shadows.ench.altar.TilePrismaticAltar;
import shadows.placebo.Placebo;
import shadows.placebo.util.PlaceboUtil;

@Mod.EventBusSubscriber(modid="apotheosis", value={Side.CLIENT})
public class ApotheosisClient {
    public static final Item COBWEB = Item.func_150898_a((Block)Blocks.field_150321_G);
    private static final Map<IRegistryDelegate<Enchantment>, List<String>> ENCH_TOOLTIPS = new HashMap<IRegistryDelegate<Enchantment>, List<String>>();

    @SubscribeEvent
    public static void tooltips(ItemTooltipEvent e) {
        Item i = e.getItemStack().func_77973_b();
        if (Apotheosis.enableEnch) {
            if (EnchModule.allowWeb && i == COBWEB) {
                e.getToolTip().add(I18n.func_135052_a((String)"info.apotheosis.cobweb", (Object[])new Object[0]));
            } else if (i == ApotheosisObjects.PRISMATIC_WEB) {
                e.getToolTip().add(I18n.func_135052_a((String)"info.apotheosis.prismatic_cobweb", (Object[])new Object[0]));
            }
        }
        if (i == Items.field_151134_bR) {
            for (Map.Entry<IRegistryDelegate<Enchantment>, List<String>> ent : ENCH_TOOLTIPS.entrySet()) {
                if (!ApotheosisClient.onlyHasEnchant(e.getItemStack(), (Enchantment)ent.getKey().get())) continue;
                ent.getValue().forEach(s -> e.getToolTip().add(I18n.func_135052_a((String)s, (Object[])new Object[0])));
                return;
            }
        }
    }

    private static boolean onlyHasEnchant(ItemStack book, Enchantment ench) {
        NBTTagCompound tag;
        short id;
        Enchantment enchantment;
        NBTTagList list = ItemEnchantedBook.func_92110_g((ItemStack)book);
        return list.func_74745_c() == 1 && (enchantment = Enchantment.func_185262_c((int)(id = (tag = list.func_150305_b(0)).func_74765_d("id")))) == ench;
    }

    @SubscribeEvent
    public static void init(Apotheosis.ApotheosisInit e) {
        String masterwork = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"info.apotheosis.masterwork", (Object[])new Object[0]);
        String twisted = TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.apotheosis.twisted", (Object[])new Object[0]);
        String corrupted = TextFormatting.DARK_RED + I18n.func_135052_a((String)"info.apotheosis.corrupted", (Object[])new Object[0]);
        if (Apotheosis.enchTooltips) {
            if (Apotheosis.enableSpawner) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.CAPTURING, "enchantment.apotheosis.capturing.desc");
            }
            if (Apotheosis.enablePotion) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.TRUE_INFINITY, masterwork, "", "enchantment.apotheosis.true_infinity.desc");
            }
            if (Apotheosis.enableEnch) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.HELL_INFUSION, masterwork, "", "enchantment.apotheosis.hell_infusion.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.MOUNTED_STRIKE, "enchantment.apotheosis.mounted_strike.desc");
                ApotheosisClient.registerTooltip((Enchantment)ApotheosisObjects.DEPTH_MINER, twisted, "", "enchantment.apotheosis.depth_miner.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.STABLE_FOOTING, "enchantment.apotheosis.stable_footing.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SCAVENGER, masterwork, "", "enchantment.apotheosis.scavenger.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.LIFE_MENDING, corrupted, "", "enchantment.apotheosis.life_mending.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.ICY_THORNS, "enchantment.apotheosis.icy_thorns.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.TEMPTING, "enchantment.apotheosis.tempting.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SHIELD_BASH, "enchantment.apotheosis.shield_bash.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.REFLECTIVE, "enchantment.apotheosis.reflective.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.BERSERK, corrupted, "", "enchantment.apotheosis.berserk.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.KNOWLEDGE, masterwork, "", "enchantment.apotheosis.knowledge.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SPLITTING, "enchantment.apotheosis.splitting.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.NATURES_BLESSING, "enchantment.apotheosis.natures_blessing.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.REBOUNDING, "enchantment.apotheosis.rebounding.desc");
            }
        } else {
            if (Apotheosis.enablePotion) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.TRUE_INFINITY, masterwork);
            }
            if (Apotheosis.enableEnch) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.HELL_INFUSION, masterwork);
                ApotheosisClient.registerTooltip((Enchantment)ApotheosisObjects.DEPTH_MINER, twisted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.SCAVENGER, masterwork);
                ApotheosisClient.registerTooltip(ApotheosisObjects.LIFE_MENDING, corrupted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.BERSERK, corrupted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.KNOWLEDGE, masterwork);
            }
        }
        if (Apotheosis.enableEnch) {
            ClientRegistry.bindTileEntitySpecialRenderer(TilePrismaticAltar.class, (TileEntitySpecialRenderer)new RenderPrismaticAltar());
        }
    }

    @SubscribeEvent
    public static void models(ModelRegistryEvent e) {
        if (Apotheosis.enableEnch) {
            Placebo.PROXY.useRenamedMapper((Block)ApotheosisObjects.HELLSHELF, "hellshelf", "", "normal");
            PlaceboUtil.sMRL((Item)ApotheosisObjects.PRISMATIC_WEB, (int)0, (String)"inventory");
            for (ItemTypedBook b : EnchModule.TYPED_BOOKS) {
                PlaceboUtil.sMRL((String)"minecraft", (String)"enchanted_book", (Item)b, (int)0, (String)"inventory");
            }
            PlaceboUtil.sMRL((Block)ApotheosisObjects.PRISMATIC_ALTAR, (int)0, (String)"normal");
        }
        if (Apotheosis.enablePotion) {
            PlaceboUtil.sMRL((Item)ApotheosisObjects.LUCKY_FOOT, (int)0, (String)"inventory");
        }
    }

    public static void registerTooltip(Enchantment e, String ... keys) {
        List tips = ENCH_TOOLTIPS.computeIfAbsent((IRegistryDelegate<Enchantment>)e.delegate, d -> new ArrayList());
        for (String s : keys) {
            tips.add(s);
        }
    }
}

