/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.mana;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.block.fluid.ModFluids;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.crafting.mana.FluidCraftInstance;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FluidRecipeLoader {
    public static final FluidRecipeLoader INSTANCE = new FluidRecipeLoader();
    private File directory;

    private static Set<BlockPos> allLiquidInPool(World world, BlockPos pos, int needed, Fluid fluid) {
        if (needed <= 0) {
            return Sets.newHashSet();
        }
        Block block = fluid.getBlock();
        if (block == null) {
            return Sets.newHashSet();
        }
        IBlockState sourceBlock = block.func_176223_P();
        BlockPos.MutableBlockPos topPos = new BlockPos.MutableBlockPos(pos);
        IBlockState stateAt = world.func_180495_p((BlockPos)topPos);
        boolean lastWasFluid = false;
        while (stateAt.func_177230_c() == block) {
            lastWasFluid = stateAt == sourceBlock;
            stateAt = world.func_180495_p((BlockPos)topPos.func_181079_c(topPos.func_177958_n(), topPos.func_177956_o() + 1, topPos.func_177952_p()));
        }
        topPos.func_181079_c(topPos.func_177958_n(), topPos.func_177956_o() - 1, topPos.func_177952_p());
        BlockPos.MutableBlockPos tool = new BlockPos.MutableBlockPos();
        HashSet positions = Sets.newHashSet((Object[])new BlockPos[]{topPos.func_185334_h()});
        HashSet visited = Sets.newHashSet((Iterable)positions);
        HashSet resultants = Sets.newHashSet();
        if (lastWasFluid) {
            resultants.addAll(positions);
        }
        while (resultants.size() < needed && !positions.isEmpty() && visited.size() < 1000) {
            BlockPos point = (BlockPos)positions.iterator().next();
            positions.remove(point);
            for (int index = EnumFacing.field_82609_l.length - 1; index >= 0; --index) {
                EnumFacing facing = EnumFacing.func_82600_a((int)index);
                tool.func_181079_c(point.func_177958_n() + facing.func_82601_c(), point.func_177956_o() + facing.func_96559_d(), point.func_177952_p() + facing.func_82599_e());
                if (visited.contains(tool)) continue;
                BlockPos immutable = tool.func_185334_h();
                visited.add(immutable);
                stateAt = world.func_180495_p((BlockPos)tool);
                if (stateAt.func_177230_c() != block) continue;
                positions.add(immutable);
                if (stateAt != sourceBlock) continue;
                resultants.add(immutable);
                if (resultants.size() < needed) continue;
                return resultants;
            }
        }
        return resultants;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void processRecipes(Map<String, FluidCrafter> recipeRegistry, Multimap<Ingredient, FluidCrafter> recipes) {
        Wizardry.logger.info("<<========================================================================>>");
        Wizardry.logger.info("> Starting fluid recipe loading.");
        JsonContext context = new JsonContext("minecraft");
        LinkedList<File> recipeFiles = new LinkedList<File>();
        Stack<File> toProcess = new Stack<File>();
        toProcess.push(this.directory);
        while (!toProcess.isEmpty()) {
            File file = (File)toProcess.pop();
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children == null) continue;
                for (File child : children) {
                    toProcess.push(child);
                }
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".json")) continue;
            recipeFiles.add(file);
        }
        block6: for (File file : recipeFiles) {
            try {
                JsonElement typeElement;
                JsonElement element;
                if (!file.exists()) {
                    Wizardry.logger.error("  > SOMETHING WENT WRONG! " + file.getPath() + " can NOT be found. Ignoring file...");
                    continue;
                }
                try {
                    element = new JsonParser().parse((Reader)new FileReader(file));
                }
                catch (FileNotFoundException e) {
                    Wizardry.logger.error("  > SOMETHING WENT WRONG! " + file.getPath() + " can NOT be found. Ignoring file...");
                    continue;
                }
                if (element == null) {
                    Wizardry.logger.error("  > SOMETHING WENT WRONG! Could not parse " + file.getPath() + ". Ignoring file...");
                    continue;
                }
                if (!element.isJsonObject()) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT contain a JsonObject. Ignoring file...: " + element.toString());
                    continue;
                }
                JsonObject fileObject = element.getAsJsonObject();
                LinkedList<Ingredient> extraInputs = new LinkedList<Ingredient>();
                Fluid fluid = ModFluids.MANA.getActual();
                int duration = 100;
                int required = 1;
                boolean consume = false;
                boolean explode = false;
                boolean bubbling = true;
                boolean harp = true;
                boolean instant = true;
                if (recipeRegistry.containsKey(file.getPath())) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " already exists in the recipe map. Ignoring file...: " + element.toString());
                    continue;
                }
                if (!fileObject.has("output")) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT specify a recipe output. Ignoring file...: " + element.toString());
                    continue;
                }
                if (!fileObject.get("output").isJsonObject()) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide a valid output. Ignoring file...: " + element.toString());
                    continue;
                }
                if (!fileObject.has("input")) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide an initial input item. Ignoring file...: " + element.toString());
                    continue;
                }
                JsonElement inputObject = fileObject.get("input");
                Ingredient inputItem = CraftingHelper.getIngredient((JsonElement)inputObject, (JsonContext)context);
                if (inputItem == Ingredient.field_193370_a) {
                    Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide a valid input item. Ignoring file...: " + element.toString());
                    continue;
                }
                if (fileObject.has("extraInputs")) {
                    if (!fileObject.get("extraInputs").isJsonArray()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " has extra inputs NOT in a JsonArray format. Ignoring file...: " + element.toString());
                        continue;
                    }
                    JsonArray extraInputArray = fileObject.get("extraInputs").getAsJsonArray();
                    for (JsonElement extraInput : extraInputArray) {
                        Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)extraInput, (JsonContext)context);
                        if (ingredient == Ingredient.field_193370_a) {
                            Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide a valid extra input item. Ignoring file...: " + element.toString());
                            continue block6;
                        }
                        extraInputs.add(ingredient);
                    }
                }
                if (fileObject.has("fluid")) {
                    if (!fileObject.get("fluid").isJsonPrimitive() || !fileObject.getAsJsonPrimitive("fluid").isString()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give rfluid as a string. Ignoring file...: " + element.toString());
                        continue;
                    }
                    fluid = FluidRegistry.getFluid((String)fileObject.get("fluid").getAsString());
                }
                if (fileObject.has("duration")) {
                    if (!fileObject.get("duration").isJsonPrimitive() || !fileObject.getAsJsonPrimitive("duration").isNumber()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give duration as a number. Ignoring file...:" + element.toString());
                        continue;
                    }
                    duration = fileObject.get("duration").getAsInt();
                }
                if (fileObject.has("required")) {
                    if (!fileObject.get("required").isJsonPrimitive() || !fileObject.getAsJsonPrimitive("required").isNumber()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give required as a number. Ignoring file...: " + element.toString());
                        continue;
                    }
                    required = fileObject.get("required").getAsInt();
                }
                if (fileObject.has("consume")) {
                    if (!fileObject.get("consume").isJsonPrimitive()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give consume as a boolean. Ignoring file...: " + element.toString());
                        continue;
                    }
                    consume = fileObject.get("consume").getAsBoolean();
                }
                if (fileObject.has("explode")) {
                    if (!fileObject.get("explode").isJsonPrimitive()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give explode as a boolean. Ignoring file...: " + element.toString());
                        continue;
                    }
                    explode = fileObject.get("explode").getAsBoolean();
                }
                if (fileObject.has("harp")) {
                    if (!fileObject.get("harp").isJsonPrimitive()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give harp as a boolean. Ignoring file...: " + element.toString());
                        continue;
                    }
                    harp = fileObject.get("harp").getAsBoolean();
                }
                if (fileObject.has("bubbling")) {
                    if (!fileObject.get("bubbling").isJsonPrimitive()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give bubbling as a boolean. Ignoring file...: " + element.toString());
                        continue;
                    }
                    bubbling = fileObject.get("bubbling").getAsBoolean();
                }
                if (fileObject.has("instant")) {
                    if (!fileObject.get("instant").isJsonPrimitive()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT give instant as a boolean. Ignoring file...: " + element.toString());
                        continue;
                    }
                    instant = fileObject.get("instant").getAsBoolean();
                }
                String type = (typeElement = fileObject.get("type")) == null ? "item" : typeElement.getAsString();
                JsonObject output = fileObject.get("output").getAsJsonObject();
                if (type.equalsIgnoreCase("item")) {
                    ItemStack outputItem = CraftingHelper.getItemStack((JsonObject)output, (JsonContext)context);
                    if (outputItem.func_190926_b()) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide a valid output item. Ignoring file...: " + element.toString());
                        continue;
                    }
                    FluidCrafter build = this.buildFluidCrafter(file.getPath(), outputItem, inputItem, extraInputs, fluid, duration, required, consume, explode, bubbling, harp, instant);
                    recipeRegistry.put(file.getPath(), build);
                    recipes.put((Object)inputItem, (Object)build);
                    continue;
                }
                if (type.equalsIgnoreCase("block")) {
                    Block block;
                    JsonElement name = output.get("item");
                    if (name == null) {
                        name = output.get("block");
                    }
                    if (name == null) {
                        name = output.get("name");
                    }
                    Block block2 = block = name != null ? (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name.getAsString())) : null;
                    if (block == null) {
                        Wizardry.logger.error("  > WARNING! " + file.getPath() + " does NOT provide a valid output block. Ignoring file...: " + element.toString());
                        continue;
                    }
                    int meta = 0;
                    JsonElement data = output.get("data");
                    if (data == null) {
                        data = output.get("meta");
                    }
                    if (data != null && data.isJsonPrimitive() && data.getAsJsonPrimitive().isNumber()) {
                        meta = data.getAsInt();
                    }
                    IBlockState outputBlock = block.func_176203_a(meta);
                    FluidCrafter build = this.buildFluidCrafter(file.getPath(), outputBlock, inputItem, extraInputs, fluid, duration, required, consume, explode, bubbling, harp);
                    recipeRegistry.put(file.getPath(), build);
                    recipes.put((Object)inputItem, (Object)build);
                    continue;
                }
                Wizardry.logger.error("  > WARNING! " + file.getPath() + " specifies an invalid recipe output type. Valid recipe types: \"item\" \"block\". Ignoring file...: " + element.toString());
            }
            catch (Exception jsonException) {
                Wizardry.logger.error("  > WARNING! Skipping " + file.getPath() + " due to error: ", (Throwable)jsonException);
            }
        }
        Wizardry.logger.info("> Finished mana recipe loading.");
        Wizardry.logger.info("<<========================================================================>>");
    }

    private FluidCrafter buildFluidCrafter(String identifier, ItemStack outputItem, Ingredient input, List<Ingredient> extraInputs, Fluid fluid, int duration, int required, boolean consume, boolean explode, boolean bubbling, boolean harp, boolean instant) {
        Ingredient outputIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{outputItem});
        ArrayList inputs = Lists.newArrayList(extraInputs);
        return new FluidCrafter((world, pos, items) -> {
            if (FluidRecipeLoader.allLiquidInPool(world, pos, required, fluid).size() < required) {
                return false;
            }
            List list = items.stream().map(entity -> entity.func_92059_d().func_77946_l()).collect(Collectors.toList());
            ArrayList<Ingredient> inputList = new ArrayList<Ingredient>(inputs);
            inputList.add(input);
            for (Ingredient itemIn : inputList) {
                boolean foundMatch = false;
                LinkedList toRemove = new LinkedList();
                for (ItemStack item : list) {
                    if (!itemIn.apply(item) || outputIngredient.apply(item)) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    return false;
                }
                list.removeAll(toRemove);
                toRemove.clear();
            }
            return true;
        }, (world, pos, items, currentDuration) -> {
            EntityItem entityItem = items.stream().filter(entity -> input.apply(entity.func_92059_d())).findFirst().orElse(null);
            if (entityItem != null) {
                if (world.field_72995_K) {
                    LibParticles.CRAFTING_ALTAR_IDLE(world, entityItem.func_174791_d());
                }
                if (bubbling && currentDuration % 10 == 0) {
                    world.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, (SoundEvent)ModSounds.BUBBLING, SoundCategory.BLOCKS, 0.7f, RandUtil.nextFloat() * 0.4f + 0.8f);
                }
            }
        }, (world, pos, items, currentDuration) -> {
            EntityItem output;
            Block block;
            if (consume && (block = fluid.getBlock()) != null) {
                IBlockState defaultState = block.func_176223_P();
                Iterator properties = defaultState.func_177227_a().iterator();
                IBlockState drainState = defaultState;
                if (properties.hasNext()) {
                    drainState = drainState.func_177231_a((IProperty)properties.next());
                }
                for (BlockPos position : FluidRecipeLoader.allLiquidInPool(world, pos, required, fluid)) {
                    world.func_175656_a(position, drainState);
                }
            }
            ArrayList<Ingredient> inputList = new ArrayList<Ingredient>(inputs);
            inputList.add(input);
            int count = 0;
            boolean itemFound = false;
            block1: do {
                block2: for (Ingredient itemIn : inputList) {
                    for (EntityItem entity : items) {
                        if (!itemIn.apply(entity.func_92059_d()) || outputIngredient.apply(entity.func_92059_d())) continue;
                        entity.func_92059_d().func_190918_g(1);
                        if (!entity.func_92059_d().func_190926_b()) continue block2;
                        entity.func_70106_y();
                        continue block2;
                    }
                }
                count += outputItem.func_190916_E();
                for (Ingredient itemIn : inputList) {
                    itemFound = false;
                    for (EntityItem entity : items) {
                        if (!itemIn.apply(entity.func_92059_d()) || outputIngredient.apply(entity.func_92059_d())) continue;
                        itemFound = true;
                        break;
                    }
                    if (itemFound) continue;
                    break block1;
                }
            } while (duration == 0 && !consume && instant && itemFound);
            do {
                output = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, outputItem.func_77946_l());
                output.func_92059_d().func_190920_e(Math.min(count, outputItem.func_77976_d()));
                output.field_70159_w = 0.0;
                output.field_70181_x = 0.0;
                output.field_70179_y = 0.0;
                output.field_98038_p = true;
                world.func_72838_d((Entity)output);
            } while ((count -= outputItem.func_77976_d()) > 0);
            if (explode) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(output.func_174791_d(), Color.CYAN, Color.BLUE, 0.9, 2.0, 500, 100, 50, true), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), output.field_70165_t, output.field_70163_u, output.field_70161_v, 256.0));
                PosUtils.boom(world, output.func_174791_d(), (Entity)output, 3.0, false);
            }
            if (harp) {
                world.func_184148_a(null, output.field_70165_t, output.field_70163_u, output.field_70161_v, (SoundEvent)ModSounds.HARP1, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
        }, identifier, duration).setInputs(input, inputs).setOutput(outputItem).setDoesConsume(consume).setRequired(required).setFluid(fluid);
    }

    private FluidCrafter buildFluidCrafter(String identifier, IBlockState outputBlock, Ingredient input, List<Ingredient> extraInputs, Fluid fluid, int duration, int required, boolean consume, boolean explode, boolean bubbling, boolean harp) {
        ArrayList inputs = Lists.newArrayList(extraInputs);
        FluidCrafter builder = new FluidCrafter((world, pos, items) -> {
            if (FluidRecipeLoader.allLiquidInPool(world, pos, required, fluid).size() < required) {
                return false;
            }
            List list = items.stream().map(entity -> entity.func_92059_d().func_77946_l()).collect(Collectors.toList());
            ArrayList<Ingredient> inputList = new ArrayList<Ingredient>(inputs);
            inputList.add(input);
            for (Ingredient itemIn : inputList) {
                boolean foundMatch = false;
                LinkedList toRemove = new LinkedList();
                for (ItemStack item : list) {
                    if (!itemIn.apply(item)) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    return false;
                }
                list.removeAll(toRemove);
                toRemove.clear();
            }
            return true;
        }, (world, pos, items, currentDuration) -> {
            EntityItem entityItem = items.stream().filter(entity -> input.apply(entity.func_92059_d())).findFirst().orElse(null);
            if (entityItem != null) {
                if (world.field_72995_K) {
                    LibParticles.CRAFTING_ALTAR_IDLE(world, entityItem.func_174791_d());
                }
                if (bubbling && currentDuration % 10 == 0) {
                    world.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, (SoundEvent)ModSounds.BUBBLING, SoundCategory.BLOCKS, 0.7f, RandUtil.nextFloat() * 0.4f + 0.8f);
                }
            }
        }, (world, pos, items, currentDuration) -> {
            Block block;
            if (consume && (block = fluid.getBlock()) != null) {
                IBlockState defaultState = block.func_176223_P();
                Iterator properties = defaultState.func_177227_a().iterator();
                IBlockState drainState = defaultState;
                if (properties.hasNext()) {
                    drainState = drainState.func_177231_a((IProperty)properties.next());
                }
                for (BlockPos position : FluidRecipeLoader.allLiquidInPool(world, pos, required, fluid)) {
                    world.func_175656_a(position, drainState);
                }
            }
            ArrayList<Ingredient> inputList = new ArrayList<Ingredient>(inputs);
            inputList.add(input);
            for (Ingredient itemIn : inputList) {
                for (EntityItem entity : items) {
                    if (!itemIn.apply(entity.func_92059_d())) continue;
                    entity.func_92059_d().func_190918_g(1);
                    if (!entity.func_92059_d().func_190926_b()) continue;
                    entity.func_70106_y();
                }
            }
            world.func_175656_a(pos, outputBlock);
            Vec3d output = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (explode) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(output, Color.CYAN, Color.BLUE, 0.9, 2.0, 500, 100, 50, true), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), output.field_72450_a, output.field_72448_b, output.field_72449_c, 256.0));
                PosUtils.boom(world, output, null, 3.0, false);
            }
            if (harp) {
                world.func_184148_a(null, output.field_72450_a, output.field_72448_b, output.field_72449_c, (SoundEvent)ModSounds.HARP1, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
        }, identifier, duration).setInputs(input, inputs).setIsBlock(true).setDoesConsume(true).setRequired(required).setFluid(fluid);
        Fluid fluidOutput = FluidRegistry.lookupFluidForBlock((Block)outputBlock.func_177230_c());
        if (fluidOutput != null) {
            builder.setOutput(new FluidStack(fluidOutput, 1000));
        } else {
            builder.setOutput(new ItemStack(outputBlock.func_177230_c(), 1, outputBlock.func_177230_c().func_180651_a(outputBlock)));
        }
        return builder;
    }

    public static class FluidCrafter {
        private ManaCrafterPredicate isValid;
        private ManaCrafterConsumer tick;
        private ManaCrafterConsumer finish;
        private String identifier;
        private int duration;
        private Fluid fluid = ModFluids.MANA.getActual();
        private Ingredient primaryInput = Ingredient.field_193370_a;
        private List<Ingredient> extraInputs = Collections.emptyList();
        private ItemStack output = ItemStack.field_190927_a;
        private FluidStack fluidOutput = null;
        private boolean block = false;
        private boolean doesConsume = false;
        private int required = 1;

        private FluidCrafter(ManaCrafterPredicate isValid, ManaCrafterConsumer tick, ManaCrafterConsumer finish, String identifier, int duration) {
            this.isValid = isValid;
            this.tick = tick;
            this.finish = finish;
            this.identifier = identifier;
            this.duration = duration;
        }

        private FluidCrafter setInputs(Ingredient primary, List<Ingredient> inputs) {
            this.primaryInput = primary;
            this.extraInputs = inputs;
            return this;
        }

        private FluidCrafter setOutput(ItemStack output) {
            this.output = output;
            return this;
        }

        private FluidCrafter setFluid(Fluid fluid) {
            this.fluid = fluid;
            return this;
        }

        private FluidCrafter setIsBlock(boolean state) {
            this.block = state;
            return this;
        }

        private FluidCrafter setDoesConsume(boolean state) {
            this.doesConsume = state;
            return this;
        }

        public Ingredient getMainInput() {
            return this.primaryInput;
        }

        public List<Ingredient> getInputs() {
            return this.extraInputs;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        private FluidCrafter setOutput(FluidStack output) {
            this.fluidOutput = output;
            return this;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public FluidStack getFluidOutput() {
            return this.fluidOutput;
        }

        public boolean isBlock() {
            return this.block;
        }

        public boolean doesConsume() {
            return this.doesConsume;
        }

        public int getRequired() {
            return this.required;
        }

        private FluidCrafter setRequired(int required) {
            this.required = required;
            return this;
        }

        public FluidCraftInstance build() {
            return new FluidCraftInstance(this.identifier, this.duration, this.fluid){

                @Override
                public boolean isValid(World world, BlockPos pos, List<EntityItem> items) {
                    Block at = world.func_180495_p(pos).func_177230_c();
                    return at == this.fluid.getBlock() && isValid.check(world, pos, items);
                }

                @Override
                public void tick(World world, BlockPos pos, List<EntityItem> items) {
                    super.tick(world, pos, items);
                    tick.consume(world, pos, items, this.currentDuration);
                }

                @Override
                public void finish(World world, BlockPos pos, List<EntityItem> items) {
                    finish.consume(world, pos, items, this.currentDuration);
                }
            };
        }
    }

    @FunctionalInterface
    private static interface ManaCrafterConsumer {
        public void consume(World var1, BlockPos var2, List<EntityItem> var3, int var4);
    }

    @FunctionalInterface
    private static interface ManaCrafterPredicate {
        public boolean check(World var1, BlockPos var2, List<EntityItem> var3);
    }
}

