/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.world.underworld;

import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.common.block.BlockCloud;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Pair;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ChunkGeneratorUnderWorld
implements IChunkGenerator {
    private static final int UPPER_LEVEL = 102;
    private static final int LOWER_LEVEL = 105;
    private static final double UPPER_X_SCALE = 12.0;
    private static final double UPPER_Y_SCALE = 0.5;
    private static final double UPPER_Z_SCALE = 12.0;
    private static final double LOWER_X_SCALE = 16.0;
    private static final double LOWER_Y_SCALE = 1.75;
    private static final double LOWER_Z_SCALE = 16.0;
    private NoiseGeneratorPerlin upper;
    private NoiseGeneratorPerlin lower;
    private World world;

    public ChunkGeneratorUnderWorld(World worldIn) {
        this.world = worldIn;
        this.upper = new NoiseGeneratorPerlin(RandUtil.random, 4);
        this.lower = new NoiseGeneratorPerlin(RandUtil.random, 4);
    }

    public ChunkGeneratorUnderWorld(World world, long seed) {
        this.world = world;
        RandUtilSeed rand = new RandUtilSeed(seed);
        this.upper = new NoiseGeneratorPerlin(rand.random, 4);
        this.lower = new NoiseGeneratorPerlin(rand.random, 4);
    }

    private List<Pair<BlockPos, BlockPos>> generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        double[][] upperValues = new double[16][16];
        double[][] lowerValues = new double[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                upperValues[x][z] = this.upper.func_151601_a((double)(chunkX * 16 + x) / 12.0, (double)(chunkZ * 16 + z) / 12.0);
                lowerValues[x][z] = this.lower.func_151601_a((double)(chunkX * 16 + x) / 16.0, (double)(chunkZ * 16 + z) / 16.0);
            }
        }
        LinkedList<Pair<BlockPos, BlockPos>> litBlocks = new LinkedList<Pair<BlockPos, BlockPos>>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int minY = (int)(lowerValues[x][z] * 1.75 + 105.0);
                int maxY = (int)(upperValues[x][z] * 0.5 + 102.0);
                litBlocks.add((Pair<BlockPos, BlockPos>)new Pair((Object)new BlockPos(chunkX * 16 + x, minY, chunkZ * 16 + z), (Object)new BlockPos(chunkX * 16 + x, maxY, chunkZ * 16 + z)));
                for (int y = minY; y <= maxY; ++y) {
                    if (y == minY) {
                        primer.func_177855_a(x, y, z, ModBlocks.CLOUD.func_176223_P().func_177226_a((IProperty)BlockCloud.HAS_LIGHT_VALUE, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    primer.func_177855_a(x, y, z, ModBlocks.CLOUD.func_176223_P());
                }
            }
        }
        return litBlocks;
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        List<Pair<BlockPos, BlockPos>> litBlocks = this.generate(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        litBlocks.forEach(pair -> {
            BlockPos lower = (BlockPos)pair.getFirst();
            BlockPos upper = (BlockPos)pair.getSecond();
            for (int i = 0; i < 15; ++i) {
                if (lower.func_177956_o() + i > upper.func_177956_o()) {
                    return;
                }
                chunk.func_177431_a(EnumSkyBlock.BLOCK, lower.func_177981_b(i), 15 - i);
            }
        });
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        if (x / 16 == 0 && z / 16 == 0) {
            for (int i = -3; i < 3; ++i) {
                for (int j = -3; j < 3; ++j) {
                    this.world.func_175656_a(new BlockPos(i, 100, j), Blocks.field_150343_Z.func_176223_P());
                }
            }
            this.world.func_175656_a(new BlockPos(-1, 101, -1), Blocks.field_150478_aa.func_176223_P());
            this.world.func_175656_a(new BlockPos(0, 101, -1), Blocks.field_150478_aa.func_176223_P());
            this.world.func_175656_a(new BlockPos(-1, 101, 0), Blocks.field_150478_aa.func_176223_P());
            this.world.func_175656_a(new BlockPos(0, 101, 0), Blocks.field_150478_aa.func_176223_P());
        }
    }

    public boolean func_185933_a(@Nonnull Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> list = new ArrayList<Biome.SpawnListEntry>();
        list.add(new Biome.SpawnListEntry(EntityFairy.class, 1, 1, 3));
        return list;
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        return false;
    }
}

