/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.tile;

import com.teamwizardry.librarianlib.features.autoregister.TileRegister;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.librarianlib.features.tesr.TileRenderer;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.block.TileManaInteractor;
import com.teamwizardry.wizardry.api.capability.mana.CapManager;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.client.render.block.TileManaBatteryRenderer;
import com.teamwizardry.wizardry.common.block.BlockManaBattery;
import com.teamwizardry.wizardry.common.tile.TilePearlHolder;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@TileRegister(value="wizardry:mana_battery")
@TileRenderer(value=TileManaBatteryRenderer.class)
public class TileManaBattery
extends TileManaInteractor {
    public static final HashSet<BlockPos> poses = new HashSet();
    @Save
    public boolean revealStructure = false;

    public TileManaBattery() {
        super(1000.0, 1000.0);
        this.setAllowOutsideSucking(false);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public void onSuckFrom(final TileManaInteractor from) {
        super.onSuckFrom(from);
        if (from instanceof TilePearlHolder && CapManager.isManaEmpty(from.getWizardryCap())) {
            ((TilePearlHolder)from).setItemStack(ItemStack.field_190927_a);
            from.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (SoundEvent)ModSounds.GLASS_BREAK, SoundCategory.AMBIENT, 0.5f, RandUtil.nextFloat() * 0.4f + 0.8f);
                ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                    @SideOnly(value=Side.CLIENT)
                    public void runIfClient() {
                        LibParticles.EXPLODE(TileManaBattery.this.field_145850_b, new Vec3d((Vec3i)from.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), Color.CYAN, Color.BLUE, 0.5, 0.5, 50, 50, 10, true);
                    }
                });
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145838_q() == ModBlocks.MANA_BATTERY && !((BlockManaBattery)this.func_145838_q()).testStructure(this.func_145831_w(), this.func_174877_v()).isEmpty()) {
            return;
        }
        if (this.func_145838_q() != ModBlocks.CREATIVE_MANA_BATTERY) {
            for (BlockPos relative : poses) {
                BlockPos target = this.func_174877_v().func_177971_a((Vec3i)relative);
                TileEntity tile = this.field_145850_b.func_175625_s(target);
                if (!(tile instanceof TilePearlHolder) || ((TilePearlHolder)tile).isPartOfStructure) continue;
                ((TilePearlHolder)tile).isPartOfStructure = true;
                ((TilePearlHolder)tile).structurePos = this.func_174877_v();
                ((TilePearlHolder)tile).setAllowOutsideSucking(false);
                tile.func_70296_d();
            }
        } else {
            CapManager.forObject(this.getWizardryCap()).setMana(CapManager.getMaxMana(this.getWizardryCap())).setBurnout(0.0).close();
        }
    }

    static {
        poses.add(new BlockPos(2, 1, 2));
        poses.add(new BlockPos(-2, 1, 2));
        poses.add(new BlockPos(2, 1, -2));
        poses.add(new BlockPos(-2, 1, -2));
        poses.add(new BlockPos(4, 2, 4));
        poses.add(new BlockPos(-4, 2, 4));
        poses.add(new BlockPos(4, 2, -4));
        poses.add(new BlockPos(-4, 2, -4));
    }
}

