/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.google.common.base.Predicate;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.common.entity.projectile.EntitySpellProjectile;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_projectile")
public class ModuleShapeProjectile
implements IModuleShape {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range", "modifier_increase_speed"};
    }

    @Override
    public boolean ignoreResultsForRendering() {
        return true;
    }

    @Override
    public boolean shouldRunChildren() {
        return false;
    }

    @Override
    public boolean run(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        if (world.field_72995_K) {
            return true;
        }
        Vec3d origin = spell.getOriginWithFallback();
        if (origin == null) {
            return false;
        }
        double dist = spellRing.getAttributeValue(AttributeRegistry.RANGE, spell);
        double speed = spellRing.getAttributeValue(AttributeRegistry.SPEED, spell);
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        EntitySpellProjectile proj = new EntitySpellProjectile(world, spellRing, spell, (float)dist, (float)speed, 0.1f, !overrides.onRunProjectile(spell, spellRing));
        proj.func_70107_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        proj.field_70133_I = true;
        boolean success = world.func_72838_d((Entity)proj);
        if (success) {
            world.func_184133_a(null, new BlockPos(origin), (SoundEvent)ModSounds.PROJECTILE_LAUNCH, SoundCategory.PLAYERS, 1.0f, (float)RandUtil.nextDouble(1.0, 1.5));
        }
        return success;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        overrides.onRenderProjectile(spell, spellRing);
    }

    @Override
    @NotNull
    public SpellData renderVisualization(ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, @Nonnull SpellData previousData) {
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = data.getCaster();
        Vec3d origin = data.getOrigin();
        if (look == null) {
            return previousData;
        }
        if (caster == null) {
            return previousData;
        }
        if (origin == null) {
            return previousData;
        }
        double dist = ring.getAttributeValue(AttributeRegistry.RANGE, data);
        RayTraceResult result = new RayTrace(data.world, look, caster.func_174791_d().func_72441_c(0.0, (double)caster.func_70047_e(), 0.0), dist).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        data.processTrace(result);
        BlockPos pos = data.getTargetPos();
        if (pos == null) {
            return previousData;
        }
        previousData.processTrace(result);
        return previousData;
    }

    @ModuleOverride(value="shape_projectile_run")
    public boolean onRunProjectile(SpellData data, SpellRing shape) {
        return false;
    }

    @ModuleOverride(value="shape_projectile_render")
    public boolean onRenderProjectile(SpellData data, SpellRing shape) {
        return false;
    }
}

