/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpHelix;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.IBlockSelectable;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_substitution")
public class ModuleEffectSubstitution
implements IModuleEffect,
IBlockSelectable {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim();
        Entity caster = spell.getCaster();
        BlockPos targetBlock = spell.getTargetPos();
        EnumFacing facing = spell.getFaceHit();
        World world = spell.world;
        if (caster == null) {
            return false;
        }
        if (targetEntity instanceof EntityLivingBase) {
            if (!spellRing.taxCaster(spell, true)) {
                return false;
            }
            Vec3d posTarget = new Vec3d(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v);
            Vec3d posCaster = new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
            float yawTarget = targetEntity.field_70177_z;
            float pitchTarget = targetEntity.field_70125_A;
            float yawCaster = caster.field_70177_z;
            float pitchCaster = caster.field_70125_A;
            targetEntity.field_70177_z = yawCaster;
            targetEntity.field_70125_A = pitchCaster;
            targetEntity.func_70634_a(posCaster.field_72450_a, posCaster.field_72448_b, posCaster.field_72449_c);
            caster.field_70177_z = yawTarget;
            caster.field_70125_A = pitchTarget;
            caster.func_70634_a(posTarget.field_72450_a, posTarget.field_72448_b, posTarget.field_72449_c);
            world.func_184133_a(null, caster.func_180425_c(), (SoundEvent)ModSounds.TELEPORT, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat());
            world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.TELEPORT, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat());
            return true;
        }
        if (targetBlock != null && caster instanceof EntityPlayer) {
            if (facing == null) {
                return false;
            }
            ItemStack hand = ((EntityPlayer)caster).func_184614_ca();
            if (hand.func_190926_b()) {
                return false;
            }
            world.func_184133_a(null, targetBlock, (SoundEvent)ModSounds.TELEPORT, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat());
            if (ItemNBTHelper.verifyExistence((ItemStack)hand, (String)"selected")) {
                NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)hand, (String)"selected");
                if (compound == null) {
                    return false;
                }
                IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)compound);
                IBlockState touchedBlock = world.func_180495_p(targetBlock);
                if (touchedBlock.func_177230_c() == state.func_177230_c()) {
                    return false;
                }
                double area = spellRing.getAttributeValue(AttributeRegistry.AREA, spell);
                ItemStack stackBlock = null;
                for (ItemStack stack : ((EntityPlayer)caster).field_71071_by.field_70462_a) {
                    Block block;
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) != state.func_177230_c()) continue;
                    stackBlock = stack;
                    break;
                }
                if (stackBlock == null) {
                    return false;
                }
                Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetBlock, facing, Math.min(stackBlock.func_190916_E(), (int)area), (int)((Math.sqrt(area) + 1.0) / 2.0), pos -> {
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
                    IBlockState adjacentState = world.func_180495_p(mutable.func_177972_a(facing));
                    if (adjacentState.func_177230_c() != Blocks.field_150350_a) {
                        return true;
                    }
                    IBlockState block = world.func_180495_p(pos);
                    return block.func_177230_c() != touchedBlock.func_177230_c();
                });
                if (blocks.isEmpty()) {
                    return true;
                }
                for (BlockPos pos2 : blocks) {
                    if (stackBlock.func_190926_b()) {
                        return true;
                    }
                    if (!spellRing.taxCaster(spell, 1.0 / area, false)) {
                        return false;
                    }
                    if (world.func_175623_d(pos2) || world.func_180495_p(pos2).func_177230_c() == state.func_177230_c()) continue;
                    stackBlock.func_190918_g(1);
                    IBlockState oldState = world.func_180495_p(pos2);
                    BlockUtils.placeBlock(world, pos2, state, (EntityPlayerMP)caster);
                    ((EntityPlayer)caster).field_71071_by.func_70441_a(new ItemStack(oldState.func_177230_c().func_180660_a(oldState, world.field_73012_v, 0)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Entity caster = spell.getCaster();
        BlockPos targetBlock = spell.getTargetPos();
        Entity targetEntity = spell.getVictim();
        if (targetEntity != null && caster != null) {
            ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(20, 30));
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v)), (int)50, (int)RandUtil.nextInt(20, 30), (aFloat, particleBuilder) -> {
                glitter.setScale((float)RandUtil.nextDouble(0.3, 1.0));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
                glitter.setLifetime(RandUtil.nextInt(10, 20));
                glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 2.0, 0.0), 0.5f, 0.0f, 1.0f, RandUtil.nextFloat()));
            });
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getSecondaryColor(), instance.getPrimaryColor()));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v)), (int)50, (int)RandUtil.nextInt(20, 30), (aFloat, particleBuilder) -> {
                glitter.setScale((float)RandUtil.nextDouble(0.3, 1.0));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
                glitter.setLifetime(RandUtil.nextInt(10, 20));
                glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 4.0, 0.0), 1.0f, 0.0f, 1.0f, RandUtil.nextFloat()));
            });
        } else if (targetBlock != null) {
            ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(20, 30));
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)targetBlock).func_72441_c(0.5, 0.5, 0.5)), (int)20, (int)0, (aFloat, particleBuilder) -> {
                glitter.setScale((float)RandUtil.nextDouble(0.3, 1.0));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
                glitter.setLifetime(RandUtil.nextInt(10, 20));
                glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
                glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1), RandUtil.nextDouble(-0.1, 0.1)));
            });
        }
    }

    @Override
    @NotNull
    public SpellData renderVisualization(ModuleInstanceEffect instance, @Nonnull SpellData data, @Nonnull SpellRing ring, @Nonnull SpellData previousData) {
        if (ring.getParentRing() != null && ring.getParentRing().getModule() != null && ring.getParentRing().getModule() == ModuleRegistry.INSTANCE.getModule("event_collide_entity")) {
            return previousData;
        }
        Entity caster = data.getCaster();
        BlockPos targetBlock = data.getTargetPos();
        EnumFacing facing = data.getFaceHit();
        World world = data.world;
        if (!(caster instanceof EntityLivingBase)) {
            return previousData;
        }
        ItemStack hand = ((EntityLivingBase)caster).func_184614_ca();
        if (hand.func_190926_b()) {
            return previousData;
        }
        if (targetBlock != null && caster instanceof EntityPlayer) {
            if (facing == null) {
                return previousData;
            }
            if (ItemNBTHelper.verifyExistence((ItemStack)hand, (String)"selected")) {
                NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)hand, (String)"selected");
                if (compound == null) {
                    return previousData;
                }
                IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)compound);
                IBlockState targetState = instance.getCachableBlockstate(data.world, targetBlock, previousData);
                if (targetState.func_177230_c() == state.func_177230_c()) {
                    return previousData;
                }
                double area = ring.getAttributeValue(AttributeRegistry.AREA, data);
                ItemStack stackBlock = null;
                for (ItemStack stack : ((EntityPlayer)caster).field_71071_by.field_70462_a) {
                    Object block;
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) != state.func_177230_c()) continue;
                    stackBlock = stack;
                    break;
                }
                if (stackBlock == null) {
                    return previousData;
                }
                Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetBlock, facing, Math.min((stackBlock = stackBlock.func_77946_l()).func_190916_E(), (int)area), (int)((Math.sqrt(area) + 1.0) / 2.0), pos -> {
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
                    IBlockState adjacentState = world.func_180495_p(mutable.func_177972_a(facing));
                    if (adjacentState.func_177230_c() != Blocks.field_150350_a) {
                        return true;
                    }
                    IBlockState block = world.func_180495_p(pos);
                    return block.func_177230_c() != targetState.func_177230_c();
                });
                if (blocks.isEmpty()) {
                    return previousData;
                }
                HashMap<BlockPos, IBlockState> blockStateCache = new HashMap<BlockPos, IBlockState>();
                for (BlockPos pos2 : blocks) {
                    blockStateCache.put(pos2, data.world.func_180495_p(pos2));
                }
                HashMap tmpCache = new HashMap(blockStateCache);
                for (Map.Entry entry : tmpCache.entrySet()) {
                    if (BlockUtils.isAnyAir((IBlockState)entry.getValue())) continue;
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos((BlockPos)entry.getKey());
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        IBlockState adjState;
                        mutable.func_189536_c(face);
                        if (!blockStateCache.containsKey(mutable)) {
                            adjState = data.world.func_180495_p((BlockPos)mutable);
                            blockStateCache.put(mutable.func_185334_h(), adjState);
                        } else {
                            adjState = (IBlockState)blockStateCache.get(mutable);
                        }
                        if (adjState.func_177230_c() != targetState.func_177230_c() || !blocks.contains(mutable)) {
                            instance.drawFaceOutline((BlockPos)mutable, face.func_176734_d());
                        }
                        mutable.func_189536_c(face.func_176734_d());
                    }
                }
            }
        }
        return previousData;
    }
}

