/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.wizardry.api.spell.IOverrideCooldown;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_leap")
public class ModuleEffectLeap
implements IModuleEffect,
IOverrideCooldown {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency"};
    }

    @Override
    public int getNewCooldown(@Nonnull SpellData spell, SpellRing ring) {
        Entity target = spell.getData(SpellData.DefaultKeys.ENTITY_HIT);
        if (!(target instanceof EntityLivingBase)) {
            return 50;
        }
        ItemStack stack = ((EntityLivingBase)target).func_184614_ca();
        if (stack.func_190926_b() || !ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"jump_count") || !ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"max_jumps") || !ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"jump_timer")) {
            return 50;
        }
        int jumpCount = ItemNBTHelper.getInt((ItemStack)stack, (String)"jump_count", (int)0);
        int maxJumps = ItemNBTHelper.getInt((ItemStack)stack, (String)"max_jumps", (int)0);
        if (jumpCount <= 1) {
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)"jump_timer");
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)"jump_count");
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)"max_jumps");
            return 50;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"jump_count", (int)(jumpCount - 1));
        return maxJumps + 5 - jumpCount;
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d lookVec = spell.getData(SpellData.DefaultKeys.LOOK);
        Entity target = spell.getVictim();
        if (target == null) {
            return true;
        }
        if (!(target instanceof EntityLivingBase)) {
            return true;
        }
        ItemStack stack = ((EntityLivingBase)target).func_184614_ca();
        if (stack.func_190926_b()) {
            return true;
        }
        if (lookVec == null) {
            return true;
        }
        if (!target.func_189652_ae()) {
            double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell);
            if (!spellRing.taxCaster(spell, true)) {
                return false;
            }
            if (!(ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"jump_count") && ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"max_jumps") && ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"jump_timer"))) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"jump_count", (int)((int)potency));
                ItemNBTHelper.setInt((ItemStack)stack, (String)"max_jumps", (int)((int)potency));
                ItemNBTHelper.setInt((ItemStack)stack, (String)"jump_timer", (int)200);
            }
            target.field_70159_w += lookVec.field_72450_a;
            target.field_70181_x += 0.65;
            target.field_70179_y += lookVec.field_72449_c;
            target.field_70133_I = true;
            target.field_70143_R /= (float)(1 + MathHelper.func_76143_f((double)(spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 8.0)));
            if (target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
            }
            spell.world.func_184133_a(null, target.func_180425_c(), (SoundEvent)ModSounds.FLY, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget();
        Entity entityHit = spell.getVictim();
        if (position == null) {
            return;
        }
        if (entityHit == null) {
            return;
        }
        if (!entityHit.func_189652_ae()) {
            Vec3d normal = new Vec3d(entityHit.field_70159_w, entityHit.field_70181_x, entityHit.field_70179_y).func_72432_b().func_186678_a(0.5);
            LibParticles.AIR_THROTTLE(spell.world, position, normal, instance.getPrimaryColor(), instance.getSecondaryColor(), 0.5);
        }
    }

    @SubscribeEvent
    public void tickEntity(LivingEvent.LivingUpdateEvent event) {
        ItemStack stack = event.getEntityLiving().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"jump_timer")) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)"jump_timer", (int)0);
            if (x <= 0 || event.getEntityLiving().field_70124_G) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)"jump_timer");
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)"jump_count");
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)"max_jumps");
            } else {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"jump_timer", (int)(x - 1));
            }
        }
    }
}

