/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_frost")
public class ModuleEffectFrost
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Entity targetEntity = spell.getVictim();
        BlockPos targetPos = spell.getTargetPos();
        Entity caster = spell.getCaster();
        double range = spellRing.getAttributeValue(AttributeRegistry.AREA, spell) / 2.0;
        double time = spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 10.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetEntity != null) {
            spell.world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.FROST_FORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            targetEntity.func_70066_B();
            if (targetEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect((Potion)ModPotions.SLIPPERY, (int)time, 0, true, false));
            }
        }
        if (targetPos != null) {
            spell.world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.FROST_FORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            int x = (int)range;
            while ((double)x >= -range) {
                int y = (int)range;
                while ((double)y >= -range) {
                    int z = (int)range;
                    while ((double)z >= -range) {
                        BlockPos pos = targetPos.func_177982_a(x, y, z);
                        double dist = pos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                        if (!(dist > range)) {
                            for (EnumFacing facing : EnumFacing.field_82609_l) {
                                IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
                                if (state.func_177230_c() != Blocks.field_150480_ab) continue;
                                BlockUtils.breakBlock(world, pos.func_177972_a(facing), state, caster instanceof EntityPlayer ? (EntityPlayerMP)caster : null, false);
                            }
                            if (world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
                                int layerSize = (int)Math.max(1.0, Math.min(8.0, Math.max(1.0, dist / range * 6.0)));
                                layerSize = Math.max(1, Math.min(layerSize + RandUtil.nextInt(-1, 1), 8));
                                BlockUtils.placeBlock(world, pos.func_177972_a(EnumFacing.UP), Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layerSize)), caster instanceof EntityPlayer ? (EntityPlayerMP)caster : null);
                            }
                            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j) {
                                BlockUtils.placeBlock(world, pos, Blocks.field_150432_aD.func_176223_P(), caster instanceof EntityPlayer ? (EntityPlayerMP)caster : null);
                            }
                        }
                        --z;
                    }
                    --y;
                }
                --x;
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.enableMotionCalculation();
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setAcceleration(new Vec3d(0.0, -0.02, 0.0));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)RandUtil.nextInt(5, 15), (int)0, (aFloat, particleBuilder) -> {
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-2.0, 2.0), z));
            glitter.setLifetime(RandUtil.nextInt(50, 100));
            Vec3d direction = position.func_178787_e(glitter.getPositionOffset()).func_178788_d(position).func_72432_b().func_186678_a(0.0);
            glitter.addMotion(direction.func_186678_a(RandUtil.nextDouble(0.5, 1.0)));
        });
    }
}

