/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.librarianlib.features.utilities.client.TooltipHelper;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.item.ICooldown;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.spell.IBlockSelectable;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.common.module.defaults.IModuleOverrides;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemStaff
extends ItemMod
implements INacreProduct.INacreDecayProduct,
ICooldown {
    public ItemStaff() {
        super("staff", new String[]{"staff", "staff_pearl"});
        this.func_77625_d(1);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (this.isCoolingDown(playerIn.field_70170_p, stack)) {
            return false;
        }
        if (BaublesSupport.getItem((EntityLivingBase)playerIn, ModItems.CREATIVE_HALO, ModItems.FAKE_HALO, ModItems.REAL_HALO).func_190926_b()) {
            return false;
        }
        if (this.requiresBowAction(stack)) {
            return false;
        }
        SpellData spell = new SpellData(playerIn.field_70170_p);
        spell.processEntity((Entity)playerIn, true);
        spell.processEntity((Entity)target, false);
        SpellUtils.runSpell(stack, spell);
        this.setCooldown(playerIn.field_70170_p, playerIn, hand, stack, spell);
        return true;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            for (SpellRing spellRing : SpellUtils.getAllSpellRings(stack)) {
                if (!(spellRing.getModule() instanceof IBlockSelectable)) continue;
                ItemNBTHelper.setCompound((ItemStack)stack, (String)"selected", (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)world.func_180495_p(pos)));
                player.func_184597_cx();
                player.func_184609_a(hand);
                return EnumActionResult.PASS;
            }
        }
        if (this.isCoolingDown(world, stack)) {
            return EnumActionResult.PASS;
        }
        if (this.requiresBowAction(stack)) {
            return EnumActionResult.PASS;
        }
        if (BaublesSupport.getItem((EntityLivingBase)player, ModItems.CREATIVE_HALO, ModItems.FAKE_HALO, ModItems.REAL_HALO).func_190926_b()) {
            return EnumActionResult.PASS;
        }
        SpellData spell = new SpellData(world);
        spell.processEntity((Entity)player, true);
        spell.processBlock(pos, side, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
        SpellUtils.runSpell(stack, spell);
        this.setCooldown(world, player, hand, stack, spell);
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            for (SpellRing spellRing : SpellUtils.getAllSpellRings(stack)) {
                if (!(spellRing.getModule() instanceof IBlockSelectable)) continue;
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
        }
        boolean hasHalo = BaublesSupport.getItem((EntityLivingBase)player, ModItems.CREATIVE_HALO, ModItems.FAKE_HALO, ModItems.REAL_HALO).func_190926_b();
        if (this.isCoolingDown(world, stack) || hasHalo || world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.requiresBowAction(stack)) {
            player.func_184598_c(hand);
        } else {
            SpellData spell = new SpellData(player.field_70170_p);
            spell.processEntity((Entity)player, true);
            SpellUtils.runSpell(stack, spell);
            this.setCooldown(world, player, hand, stack, spell);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (this.isCoolingDown(player.field_70170_p, stack)) {
            return;
        }
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (this.isContinuousSpell(stack)) {
            SpellData spell = new SpellData(player.field_70170_p);
            spell.processEntity((Entity)player, true);
            SpellUtils.runSpell(stack, spell);
        } else {
            int chargeup = this.getChargeupTime(stack);
            if (72000 - count >= chargeup) {
                SpellData spell = new SpellData(player.field_70170_p);
                spell.processEntity((Entity)player, true);
                SpellUtils.runSpell(stack, spell);
                this.setCooldown(player.field_70170_p, (EntityPlayer)player, player.func_184600_cs(), stack, spell);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.colorableOnUpdate(stack, worldIn);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.colorableOnEntityItemUpdate(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        StringBuilder finalName = null;
        List<SpellRing> spellChains = SpellUtils.getSpellChains(stack);
        for (SpellRing spellRing : spellChains) {
            if (finalName == null) {
                finalName = new StringBuilder();
            } else {
                finalName.append(" / ");
            }
            finalName.append(spellRing.toString());
        }
        if (finalName == null) {
            return super.func_77653_i(stack);
        }
        return finalName.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        block15: {
            List<SpellRing> spellRings;
            block14: {
                String used;
                int i;
                if (!stack.func_77942_o()) {
                    return;
                }
                spellRings = SpellUtils.getSpellChains(stack);
                SpellRing lastRing = null;
                for (SpellRing ring : spellRings) {
                    if (lastRing == null) {
                        lastRing = ring;
                    }
                    if (ring == null) continue;
                    if (ring != lastRing) {
                        tooltip.add("");
                    }
                    SpellRing tmpRing = ring;
                    i = 0;
                    while (tmpRing != null) {
                        tooltip.add(StringUtils.repeat((String)"-", (int)i) + "> " + TextFormatting.GRAY + tmpRing.getModuleReadableName() + " - " + TextFormatting.BLUE + Math.round(tmpRing.getManaDrain(null) * tmpRing.getManaMultiplier()) + TextFormatting.GRAY + "/" + TextFormatting.RED + Math.round(tmpRing.getBurnoutFill(null) * tmpRing.getBurnoutMultiplier()));
                        if (GuiScreen.func_146272_n()) {
                            for (String key : tmpRing.getInformationTag().func_150296_c()) {
                                double value = tmpRing.getInformationTag().func_74769_h(key);
                                String valueString = value < 10.0 ? String.format("%.2f", value) : (value < 100.0 ? String.format("%.1f", value) : Double.toString(value));
                                tooltip.add(StringUtils.repeat((String)" ", (int)(i + 1)) + " | " + TextFormatting.DARK_GRAY + key + " x" + valueString);
                            }
                        }
                        tmpRing = tmpRing.getChildRing();
                        ++i;
                    }
                }
                if (!GuiScreen.func_146272_n() && !spellRings.isEmpty()) {
                    TooltipHelper.addToTooltip(tooltip, (String)"wizardry.misc.sneak_expanded", (Object[])new Object[0]);
                }
                if (!spellRings.isEmpty() || !(ItemNBTHelper.getFloat((ItemStack)stack, (String)"purity_override", (float)-1.0f) < 0.0f)) break block14;
                float purity = this.getQuality(stack);
                String desc = super.func_77667_c(stack) + ".";
                if (purity >= 1.0f) {
                    desc = desc + "perfect";
                } else {
                    boolean over;
                    boolean bl = over = ItemNBTHelper.getInt((ItemStack)stack, (String)"purity", (int)0) > 600;
                    desc = (double)purity >= 0.8333333333333334 ? (over ? desc + "over_near" : desc + "under_near") : (over ? desc + "overdone" : desc + "underdone");
                }
                desc = desc + ".desc";
                String string = used = LibrarianLib.PROXY.canTranslate(desc) ? desc : desc + "0";
                if (!LibrarianLib.PROXY.canTranslate(used)) break block15;
                TooltipHelper.addToTooltip(tooltip, (String)used, (Object[])new Object[0]);
                i = 0;
                while (LibrarianLib.PROXY.canTranslate(desc + ++i)) {
                    TooltipHelper.addToTooltip(tooltip, (String)(desc + i), (Object[])new Object[0]);
                }
                break block15;
            }
            if (spellRings.isEmpty() && this.getQuality(stack) > 1.0f) {
                String used;
                String desc = super.func_77667_c(stack) + ".ancient.desc";
                String string = used = LibrarianLib.PROXY.canTranslate(desc) ? desc : desc + "0";
                if (LibrarianLib.PROXY.canTranslate(used)) {
                    TooltipHelper.addToTooltip(tooltip, (String)used, (Object[])new Object[0]);
                    int i = 0;
                    while (LibrarianLib.PROXY.canTranslate(desc + ++i)) {
                        TooltipHelper.addToTooltip(tooltip, (String)(desc + i), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
        }
    }

    private boolean requiresBowAction(ItemStack stack) {
        for (SpellRing spellRing : SpellUtils.getAllSpellRings(stack)) {
            if (!spellRing.isContinuous() && spellRing.getChargeUpTime() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isContinuousSpell(ItemStack stack) {
        for (SpellRing spellRing : SpellUtils.getAllSpellRings(stack)) {
            if (!spellRing.isContinuous()) continue;
            return true;
        }
        return false;
    }

    private int getChargeupTime(ItemStack stack) {
        int maxChargeUp = 0;
        for (SpellRing spellRing : SpellUtils.getAllSpellRings(stack)) {
            if (spellRing.isContinuous()) {
                return 72000;
            }
            if (spellRing.getChargeUpTime() > maxChargeUp) {
                maxChargeUp = spellRing.getChargeUpTime();
            }
            IModuleOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IModuleOverrides.class);
            maxChargeUp = overrides.modifyChargeupTime(maxChargeUp);
        }
        return maxChargeUp;
    }
}

