/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import baubles.api.BaubleType;
import com.teamwizardry.librarianlib.features.base.item.ItemModBauble;
import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.item.ICape;
import com.teamwizardry.wizardry.api.spell.SpellModifierRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.attribute.Operation;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemCapeBauble
extends ItemModBauble
implements ICape {
    public static final ResourceLocation CAPE_MODIFIER_LOC = new ResourceLocation("wizardry", "cape");

    public ItemCapeBauble() {
        super("cape", new String[0]);
        this.func_77625_d(1);
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.tickCape(itemstack);
    }

    @Nonnull
    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.BODY;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(this.getCapeTooltip(stack));
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        SpellModifierRegistry.addModifier((Entity)player, CAPE_MODIFIER_LOC, (spell, data) -> {
            LinkedList<AttributeModifier> modifiers = new LinkedList<AttributeModifier>();
            float capeReduction = this.getCapeReduction(player);
            modifiers.add(new AttributeModifier(AttributeRegistry.MANA, capeReduction, Operation.MULTIPLY));
            modifiers.add(new AttributeModifier(AttributeRegistry.BURNOUT, capeReduction, Operation.MULTIPLY));
            return modifiers;
        });
    }

    private final float getCapeReduction(EntityLivingBase caster) {
        ItemStack stack = BaublesSupport.getItem(caster, ModItems.CAPE);
        if (stack != ItemStack.field_190927_a) {
            float time = ItemNBTHelper.getInt((ItemStack)stack, (String)"maxTick", (int)0);
            return (float)MathHelper.func_151237_a((double)(1.0 - (double)time / 1000000.0), (double)0.25, (double)1.0);
        }
        return 1.0f;
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        SpellModifierRegistry.removeModifier((Entity)player, CAPE_MODIFIER_LOC);
    }
}

