/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.ai;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowPlayer
extends EntityAIBase {
    private final EntityLiving entity;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private World world;
    private float maxDist;
    private float minDist;
    @Nullable
    private EntityLivingBase owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public EntityAIFollowPlayer(EntityLiving entity, double followSpeedIn, float minDistIn, float maxDistIn) {
        EntityPlayer owner;
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = entity.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
        UUID exclude = entity.getEntityData().func_186857_a("owner");
        if (exclude != null && (owner = this.world.func_152378_a(exclude)) != null) {
            this.owner = owner;
        }
        if (!(entity.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.owner;
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.entity.func_70032_d((Entity)entitylivingbase) < this.minDist) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.owner != null && this.entity.func_70032_d((Entity)this.owner) > this.maxDist;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.world.func_180495_p(pos);
        return iblockstate.func_185904_a() == Material.field_151579_a || !iblockstate.func_185917_h();
    }

    public void func_75246_d() {
        if (this.owner == null) {
            return;
        }
        this.entity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.entity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.entity.func_110167_bD() && (double)this.entity.func_70032_d((Entity)this.owner) >= 12.0) {
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.world.func_180495_p(new BlockPos(i + l, k - 1, j + i1)).func_185896_q() || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                        this.entity.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.entity.field_70177_z, this.entity.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }
}

