/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.nemez;

import com.teamwizardry.wizardry.common.core.nemez.Moment;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NemezManager
implements INBTSerializable<NBTTagList> {
    public static final int TIME_COMPRESSION_CONSTANT = 15;
    private final Stack<Moment> moments = new Stack();
    private transient Moment currentMoment = new Moment();

    public void pushEntityData(Entity entity) {
        this.currentMoment.addEntitySnapshot(entity);
    }

    public void pushBlockData(BlockPos pos, IBlockState state) {
        this.currentMoment.addBlockSnapshot(pos, state);
    }

    public void pushMoment() {
        this.moments.push(this.currentMoment);
        this.currentMoment = new Moment();
    }

    public Moment peekAtMoment() {
        return this.moments.empty() ? null : this.moments.peek();
    }

    public Moment popMoment() {
        return this.moments.pop();
    }

    public void collapse() {
        this.compress(15);
    }

    public boolean needsCompression(int maximumMoments) {
        return (double)this.moments.size() <= (double)maximumMoments * 1.5;
    }

    public void compressDownTo(int maximumMoments) {
        if (this.moments.size() <= maximumMoments) {
            return;
        }
        this.compress((int)Math.ceil((float)maximumMoments / (float)this.moments.size()));
    }

    public void compress(int factor) {
        ArrayList<Moment> collapsedMoments = new ArrayList<Moment>();
        int momentaryIndex = 0;
        Moment lastMoment = null;
        while (this.moments.size() != 0) {
            Moment currentMoment = this.moments.pop();
            if (lastMoment == null) {
                lastMoment = currentMoment;
            } else {
                lastMoment.collapse(currentMoment);
            }
            if (++momentaryIndex != factor) continue;
            collapsedMoments.add(lastMoment);
            momentaryIndex = 0;
            lastMoment = null;
        }
        if (lastMoment != null) {
            collapsedMoments.add(lastMoment);
        }
        for (Moment moment : collapsedMoments) {
            this.moments.push(moment);
        }
    }

    public void erase() {
        this.moments.clear();
        this.currentMoment = new Moment();
    }

    public NemezManager snapshot() {
        NemezManager manager = new NemezManager();
        for (Moment moment : this.moments) {
            manager.moments.push(moment.snapshot());
        }
        manager.currentMoment = manager.currentMoment.snapshot();
        return manager;
    }

    public NBTTagList serializeFirstN(int n) {
        NBTTagList momentsSerialized = new NBTTagList();
        int i = 0;
        for (Moment moment : this.moments) {
            momentsSerialized.func_74742_a((NBTBase)moment.serializeNBT());
            if (i++ != n) continue;
            break;
        }
        return momentsSerialized;
    }

    public void absorb(NBTTagList nbt) {
        Stack<Moment> shifted = new Stack<Moment>();
        for (NBTBase momentUncast : nbt) {
            NBTTagCompound moment = (NBTTagCompound)momentUncast;
            shifted.push(Moment.fromNBT(moment));
        }
        for (Moment moment : this.moments) {
            shifted.push(moment);
        }
        this.moments.clear();
        for (Moment moment : shifted) {
            this.moments.push(moment);
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList momentsSerialized = new NBTTagList();
        for (Moment moment : this.moments) {
            momentsSerialized.func_74742_a((NBTBase)moment.serializeNBT());
        }
        return momentsSerialized;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.moments.clear();
        for (NBTBase momentUncast : nbt) {
            NBTTagCompound moment = (NBTTagCompound)momentUncast;
            this.moments.push(Moment.fromNBT(moment));
        }
    }
}

