/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.worktable;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.animator.animations.Keyframe;
import com.teamwizardry.librarianlib.features.animator.animations.KeyframeAnimation;
import com.teamwizardry.librarianlib.features.animator.animations.ScheduledEventAnimation;
import com.teamwizardry.librarianlib.features.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.components.ComponentRect;
import com.teamwizardry.librarianlib.features.gui.components.ComponentText;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.gui.worktable.TableModule;
import com.teamwizardry.wizardry.client.gui.worktable.WorktableGui;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class ComponentModifiers
extends GuiComponent {
    public static final int PIXELS_PER_BAR = 16;
    public static final float SLIDE_IN_DURATION = 18.0f;
    public static final float SPACER_DURATION = 5.0f;
    public static final float SLIDE_OUT_DURATION = 3.0f;
    private final WorktableGui worktable;
    private boolean animationPlaying = false;
    private boolean refreshRequested = false;

    public ComponentModifiers(WorktableGui worktable) {
        super(384, 127, 80, 81);
        this.worktable = worktable;
        this.clipping.setClipToBounds(true);
        this.refresh();
        this.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (this.refreshRequested && !this.animationPlaying) {
                this.refreshRequested = false;
                this.animationPlaying = true;
                this.set();
            }
        });
    }

    public void refresh() {
        this.refreshRequested = true;
    }

    public void set() {
        ArrayList children = new ArrayList(this.getChildren());
        int childrenSize = children.size();
        float slideInDist = childrenSize * 16;
        for (int i = 0; i < childrenSize; ++i) {
            int lengthToTravel = (i + 1) * 16;
            float slideDuration = 18.0f * (float)lengthToTravel / slideInDist;
            float waitDuration = 18.0f - slideDuration;
            GuiComponent bar = (GuiComponent)children.get(i);
            BasicAnimation animPlate = new BasicAnimation((Object)bar, "pos.y");
            animPlate.setEasing((Easing)Easing.easeInBack);
            animPlate.setFrom((Object)(lengthToTravel - 16));
            animPlate.setTo((Object)-16);
            animPlate.setDuration(slideDuration);
            animPlate.setCompletion(() -> ((GuiComponent)bar).invalidate());
            this.add(new Animation[]{new ScheduledEventAnimation(waitDuration, () -> this.add(new Animation[]{animPlate}))});
        }
        Runnable begin = () -> {
            TableModule selectedModule = this.worktable.selectedModule;
            if (selectedModule == null) {
                this.animationPlaying = false;
                return;
            }
            ModuleInstance module = selectedModule.getModule();
            ModuleInstanceModifier[] applicableModifiers = module.applicableModifiers();
            if (applicableModifiers == null || applicableModifiers.length <= 0) {
                this.animationPlaying = false;
                return;
            }
            ModuleInstanceModifier[] modifiers = module.applicableModifiers();
            if (modifiers == null) {
                this.animationPlaying = false;
                return;
            }
            int modifiersSize = modifiers.length;
            float slideOutDist = modifiersSize * 16;
            float outDuration = 3.0f * (float)modifiersSize;
            this.add(new Animation[]{new ScheduledEventAnimation(18.0f, () -> {
                this.animationPlaying = false;
            })});
            for (int i = 0; i < modifiers.length; ++i) {
                int lengthToTravel = (i + 1) * 16;
                float slideDuration = outDuration * (float)lengthToTravel / slideOutDist;
                ModuleInstanceModifier modifier = modifiers[i];
                ComponentRect bar = new ComponentRect(0, 0, this.getSize().getXi(), 16);
                bar.getColor().setValue((Object)new Color(Integer.MIN_VALUE, true));
                TableModule tableModifier = new TableModule(this.worktable, modifier, false, true);
                tableModifier.setEnableTooltip(true);
                tableModifier.getTransform().setTranslateZ(80.0);
                bar.add(new GuiComponent[]{tableModifier});
                ComponentText text = new ComponentText(20, 4, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
                text.getText().setValue((Object)(TextFormatting.GREEN + modifier.getShortHandName()));
                bar.add(new GuiComponent[]{text});
                bar.setVisible(true);
                BasicAnimation animPlate = new BasicAnimation((Object)bar, "pos.y");
                animPlate.setEasing((Easing)Easing.easeOutBack);
                animPlate.setFrom((Object)-16);
                animPlate.setTo((Object)(lengthToTravel - 16));
                animPlate.setDuration(slideDuration);
                animPlate.setCompletion(() -> Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.WHOOSH, 1.0f, 1.0f));
                this.add(new Animation[]{animPlate});
                bar.render.getTooltip().func(t -> {
                    ArrayList<String> txt = new ArrayList<String>();
                    if (this.worktable.animationPlaying || tableModifier.getMouseOver()) {
                        return txt;
                    }
                    txt.add(TextFormatting.GOLD + modifier.getReadableName());
                    if (GuiScreen.func_146272_n()) {
                        txt.add(TextFormatting.GRAY + modifier.getDescription());
                    } else {
                        txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.misc.sneak", new Object[0]));
                    }
                    return txt;
                });
                bar.BUS.hook(GuiComponentEvents.MouseInEvent.class, event -> bar.getColor().setValue((Object)new Color(0x66000000, true)));
                bar.BUS.hook(GuiComponentEvents.MouseOutEvent.class, event -> bar.getColor().setValue((Object)new Color(Integer.MIN_VALUE, true)));
                bar.BUS.hook(GuiComponentEvents.MouseDownEvent.class, event -> {
                    if (event.component.getMouseOver()) {
                        bar.getColor().setValue((Object)new Color(0x4D000000, true));
                    }
                });
                bar.BUS.hook(GuiComponentEvents.MouseUpEvent.class, event -> {
                    if (event.component.getMouseOver()) {
                        bar.getColor().setValue((Object)new Color(Integer.MIN_VALUE, true));
                    }
                });
                bar.BUS.hook(GuiComponentEvents.MouseClickEvent.class, event -> {
                    if (!event.component.getMouseOver()) {
                        return;
                    }
                    if (this.worktable.selectedModule == null) {
                        return;
                    }
                    int j = this.worktable.selectedModule.hasData(Integer.class, modifier.getSubModuleID()) ? (Integer)this.worktable.selectedModule.getData(Integer.class, modifier.getSubModuleID()) : 0;
                    int status = -1;
                    if (event.getButton() == EnumMouseButton.LEFT) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f);
                        this.worktable.selectedModule.setData(Integer.class, modifier.getSubModuleID(), ++j);
                        status = 0;
                        this.worktable.setToastMessage("", Color.GREEN);
                        this.worktable.syncToServer();
                    } else if (event.getButton() == EnumMouseButton.RIGHT && this.worktable.selectedModule.hasData(Integer.class, modifier.getSubModuleID())) {
                        if (j > 0) {
                            Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.ZOOM, 1.0f, 1.0f);
                            this.worktable.selectedModule.setData(Integer.class, modifier.getSubModuleID(), --j);
                            if (j <= 0) {
                                this.worktable.selectedModule.removeData(Integer.class, modifier.getSubModuleID());
                            }
                            status = 1;
                            this.worktable.syncToServer();
                        }
                        this.worktable.setToastMessage("", Color.GREEN);
                    }
                    if (status == -1) {
                        return;
                    }
                    TableModule fakePlate = new TableModule(this.worktable, modifier, false, true);
                    fakePlate.getTransform().setTranslateZ(80.0);
                    this.worktable.getMainComponents().add(new GuiComponent[]{fakePlate});
                    Vec2d from = tableModifier.thisPosToOtherContext((GuiComponent)this.worktable.getMainComponents());
                    Vec2d to = this.worktable.selectedModule.thisPosToOtherContext((GuiComponent)this.worktable.getMainComponents()).add(this.worktable.selectedModule.getSize().sub(tableModifier.getSize()).mul(0.5));
                    KeyframeAnimation anim = new KeyframeAnimation((Object)fakePlate, "pos");
                    anim.setDuration(20.0f);
                    if (status == 0) {
                        Vec2d rand = from.add(RandUtil.nextDouble(-10.0, 10.0), RandUtil.nextDouble(-10.0, 10.0));
                        anim.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)from, (Easing)Easing.easeOutQuint), new Keyframe(0.3f, (Object)rand, (Easing)Easing.easeOutQuint), new Keyframe(0.35f, (Object)rand, (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)to, (Easing)Easing.easeInOutQuint)});
                    } else {
                        Vec2d rand = to.add(RandUtil.nextDouble(-10.0, 10.0), RandUtil.nextDouble(-10.0, 10.0));
                        anim.setKeyframes(new Keyframe[]{new Keyframe(0.0f, (Object)to, (Easing)Easing.easeOutQuint), new Keyframe(0.3f, (Object)rand, (Easing)Easing.easeOutQuint), new Keyframe(0.35f, (Object)rand, (Easing)Easing.easeOutQuint), new Keyframe(1.0f, (Object)from, (Easing)Easing.easeInOutQuint)});
                    }
                    anim.setCompletion(() -> ((TableModule)fakePlate).invalidate());
                    this.worktable.getMainComponents().add(new Animation[]{anim});
                });
                this.add(new GuiComponent[]{bar});
            }
        };
        if (childrenSize > 0) {
            this.add(new Animation[]{new ScheduledEventAnimation(23.0f, begin)});
        } else {
            begin.run();
        }
    }

    public void drawComponent(@Nonnull Vec2d mousePos, float partialTicks) {
    }
}

