/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.TreeNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class LightningRenderer {
    private static Sprite streakBase = new Sprite(new ResourceLocation("wizardry", "textures/particles/streak_base.png"));
    private static Sprite streakCorner = new Sprite(new ResourceLocation("wizardry", "textures/particles/streak_corner.png"));
    private static ArrayList<LightningBolt> bolts = new ArrayList();
    private static ArrayList<LightningBolt> clear = new ArrayList();

    private static BufferBuilder pos(BufferBuilder vb, Vec3d pos) {
        return vb.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static void addBolt(TreeNode<Vec3d> points, int maxTick) {
        bolts.add(new LightningBolt(points, maxTick));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        ArrayList<LightningBolt> temp = new ArrayList<LightningBolt>(bolts);
        for (LightningBolt bolt : temp) {
            if (--bolt.tick > 0) continue;
            clear.add(bolt);
        }
        for (LightningBolt bolt : clear) {
            bolts.remove(bolt);
        }
        clear.clear();
        for (LightningBolt bolt : bolts) {
            ArrayList<ArrayList<Pair<Vec3d, Vec3d>>> points = bolt.points;
            if (points.isEmpty()) {
                return;
            }
            GlStateManager.func_179094_E();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vb = tessellator.func_178180_c();
            for (int i = 0; i < points.size(); ++i) {
                float progress = (float)bolt.tick / ((float)bolt.maxTick * 1.0f);
                float beamProgress = 1.0f - (float)i / ((float)points.size() - 1.0f);
                if (beamProgress < progress / 2.0f) continue;
                ArrayList<Pair<Vec3d, Vec3d>> beams = points.get(i);
                for (Pair<Vec3d, Vec3d> pair : beams) {
                    Vec3d from = (Vec3d)pair.getFirst();
                    Vec3d to = (Vec3d)pair.getSecond();
                    Vec3d playerEyes = Minecraft.func_71410_x().field_71439_g.func_174824_e(event.getPartialTicks());
                    Vec3d normal = from.func_178788_d(to).func_72431_c(playerEyes.func_178788_d(to)).func_72432_b();
                    if (normal.field_72448_b < 0.0) {
                        normal = normal.func_186678_a(-1.0);
                    }
                    Color color = new Color(14320639);
                    int a = (int)((float)color.getAlpha() * progress);
                    Vec3d x = normal.func_186678_a(0.08 * RandUtil.nextDouble(1.0, 1.5));
                    streakBase.bind();
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, from.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, from.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                    streakCorner.bind();
                    Vec3d moreFrom = from.func_178787_e(from.func_178788_d(to).func_72432_b().func_186678_a(0.1));
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, from.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, from.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreFrom.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreFrom.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                    Vec3d moreTo = to.func_178787_e(to.func_178788_d(from).func_72432_b().func_186678_a(0.1));
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, to.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreTo.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreTo.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                    streakBase.bind();
                    color = Color.WHITE;
                    x = normal.func_186678_a(0.05 * RandUtil.nextDouble(0.3, 0.5));
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, from.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, from.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                    Vec3d moreFromCore = from.func_178787_e(from.func_178788_d(to).func_72432_b().func_186678_a(0.01));
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, from.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, from.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreFromCore.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreFromCore.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                    Vec3d moreToCore = to.func_178787_e(to.func_178788_d(from).func_72432_b().func_186678_a(0.01));
                    vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    LightningRenderer.pos(vb, to.func_178787_e(x)).func_187315_a(1.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, to.func_178788_d(x)).func_187315_a(1.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreToCore.func_178788_d(x)).func_187315_a(0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    LightningRenderer.pos(vb, moreToCore.func_178787_e(x)).func_187315_a(0.0, 1.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    public static class LightningBolt {
        public final ArrayList<ArrayList<Pair<Vec3d, Vec3d>>> points = new ArrayList();
        public final int maxTick;
        public int tick;

        public LightningBolt(TreeNode<Vec3d> points, int maxTick) {
            this.maxTick = maxTick;
            this.tick = maxTick;
            LinkedList<TreeNode<Vec3d>> queue = new LinkedList<TreeNode<Vec3d>>();
            LinkedList temp = new LinkedList();
            ArrayList<Pair> frameList = new ArrayList<Pair>();
            queue.add(points);
            while (!queue.isEmpty()) {
                TreeNode node = (TreeNode)queue.remove();
                temp.addAll(node.getChildren());
                for (TreeNode child : node.getChildren()) {
                    frameList.add(new Pair(node.getData(), child.getData()));
                }
                if (!queue.isEmpty()) continue;
                this.points.add(frameList);
                frameList = new ArrayList();
                queue = temp;
                temp = new LinkedList();
            }
        }
    }
}

