/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.utilities.AnnotationHelper;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.spell.DataInitException;
import com.teamwizardry.wizardry.api.spell.DataSerializationException;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterDataType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.World;

public class ProcessData {
    public static final ProcessData INSTANCE = new ProcessData();
    private HashMap<String, DatatypeEntry<?, ?>> datatypeRegistry = new HashMap();

    private ProcessData() {
    }

    public <T extends NBTBase, E> void registerDataType(@Nonnull Class<E> type, @Nonnull Class<T> storageType, @Nonnull Process<T, E> process) throws DataInitException {
        String dataTypeName = type.getName();
        if (this.datatypeRegistry.containsKey(dataTypeName)) {
            throw new DataInitException("Datatype '" + dataTypeName + "' is already registered.");
        }
        DatatypeEntry<T, E> entry = new DatatypeEntry<T, E>(dataTypeName, type, storageType, process);
        this.datatypeRegistry.put(dataTypeName, entry);
    }

    public <E> DataType getDataType(@Nonnull Class<E> type) {
        String dataTypeName = type.getName();
        DatatypeEntry<?, ?> entry = this.datatypeRegistry.get(dataTypeName);
        if (entry == null) {
            throw new DataSerializationException("Datatype '" + dataTypeName + "' is not existing.");
        }
        if (!ProcessData.isClassEqual(entry.getDataTypeClazz(), type)) {
            throw new IllegalStateException("Datatype '" + entry.getDataTypeName() + "' is not compatible with class '" + type + "'.");
        }
        return entry;
    }

    public void registerAnnotatedDataTypes() {
        AnnotationHelper.INSTANCE.findAnnotatedClasses(LibrarianLib.PROXY.getAsmDataTable(), Process.class, RegisterDataType.class, (clazz, info) -> {
            Class<?> dataTypeClass;
            Class<?> storageTypeClass;
            String storageTypeClassName = info.getString("storageType");
            String dataTypeClassName = info.getString("dataType");
            try {
                Class<?> storageTypeClass2 = Class.forName(storageTypeClassName);
                if (!NBTBase.class.isAssignableFrom(storageTypeClass2)) {
                    Wizardry.logger.error("Storage Class '" + storageTypeClassName + "' is not derived from NBTBase.");
                    return null;
                }
                storageTypeClass = storageTypeClass2;
            }
            catch (ClassNotFoundException e) {
                Wizardry.logger.error("Storage Class '" + storageTypeClassName + "' not existing.", (Throwable)e);
                return null;
            }
            try {
                dataTypeClass = Class.forName(dataTypeClassName);
            }
            catch (ClassNotFoundException e) {
                Wizardry.logger.error("Storage Class '" + dataTypeClassName + "' not existing.", (Throwable)e);
                return null;
            }
            try {
                Constructor ctor = clazz.getConstructor(new Class[0]);
                Object object = ctor.newInstance(new Object[0]);
                if (!(object instanceof Process)) {
                    Wizardry.logger.error("Data type class is not derived from ProcessData.Process");
                    return null;
                }
                this.registerDataType(dataTypeClass, storageTypeClass, (Process)object);
            }
            catch (DataInitException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Wizardry.logger.error("Something went wrong when creating instance of '" + clazz + "'.", (Throwable)e);
                return null;
            }
            return null;
        });
    }

    public static boolean isClassEqual(Class<?> clsA, Class<?> clsB) {
        return clsA.isAssignableFrom(clsB) && clsB.isAssignableFrom(clsA);
    }

    public static interface Process<T extends NBTBase, E> {
        @Nonnull
        public T serialize(@Nullable E var1);

        @Nullable
        public E deserialize(@Nullable World var1, @Nonnull T var2);
    }

    public static interface DataType {
        @Nonnull
        public NBTBase serialize(@Nullable Object var1);

        @Nonnull
        public Object deserialize(@Nullable World var1, @Nonnull NBTBase var2);
    }

    public static class DatatypeEntry<T extends NBTBase, E>
    implements DataType {
        private final String dataTypeName;
        private final Class<E> dataTypeClazz;
        private final Class<T> storageTypeClazz;
        private final Process<T, E> ioProcess;

        public DatatypeEntry(String dataTypeName, Class<E> dataTypeClazz, Class<T> storageTypeClazz, Process<T, E> ioProcess) {
            this.dataTypeName = dataTypeName;
            this.dataTypeClazz = dataTypeClazz;
            this.storageTypeClazz = storageTypeClazz;
            this.ioProcess = ioProcess;
        }

        public String getDataTypeName() {
            return this.dataTypeName;
        }

        public Class<E> getDataTypeClazz() {
            return this.dataTypeClazz;
        }

        public Class<T> getStorageTypeClazz() {
            return this.storageTypeClazz;
        }

        @Override
        @Nonnull
        public NBTBase serialize(@Nullable Object object) {
            if (object != null && !this.dataTypeClazz.isAssignableFrom(object.getClass())) {
                throw new DataSerializationException("Object to serialize must be at least of class '" + this.dataTypeClazz + "'");
            }
            return this.ioProcess.serialize(object);
        }

        @Override
        @Nonnull
        public Object deserialize(@Nullable World world, @Nonnull NBTBase object) {
            if (!ProcessData.isClassEqual(this.storageTypeClazz, object.getClass())) {
                throw new DataSerializationException("Storage object to deserialize must be of class '" + this.storageTypeClazz + "'");
            }
            E obj = this.ioProcess.deserialize(world, object);
            if (obj == null) {
                throw new DataSerializationException("Deserialized object is null.");
            }
            if (!this.dataTypeClazz.isInstance(obj)) {
                throw new DataSerializationException("Deserialized object must be of class '" + this.dataTypeClazz + "', but is actually of '" + obj.getClass() + "'");
            }
            return obj;
        }
    }
}

