/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.mana;

import com.teamwizardry.wizardry.api.capability.mana.BaubleWizardryCapability;
import com.teamwizardry.wizardry.api.capability.mana.DefaultWizardryCapability;
import com.teamwizardry.wizardry.api.capability.mana.IWizardryCapability;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class WizardryCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=IWizardryCapability.class)
    public static final Capability<IWizardryCapability> wizardryCapability = null;
    private final IWizardryCapability capability;

    public WizardryCapabilityProvider() {
        this.capability = new DefaultWizardryCapability();
    }

    public WizardryCapabilityProvider(IWizardryCapability capability) {
        this.capability = capability;
    }

    @Nullable
    public static IWizardryCapability getCap(Entity entity) {
        return (IWizardryCapability)entity.getCapability(wizardryCapability, null);
    }

    @Nullable
    public static IWizardryCapability getCap(World world, BlockPos pos, EnumFacing facing) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        return (IWizardryCapability)tile.getCapability(wizardryCapability, facing);
    }

    @Nullable
    public static IWizardryCapability getCap(ItemStack stack) {
        if (BaublesSupport.isBauble(stack)) {
            return new BaubleWizardryCapability(stack);
        }
        return (IWizardryCapability)stack.getCapability(wizardryCapability, null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == wizardryCapability;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (wizardryCapability != null && capability == wizardryCapability) {
            return (T)this.capability;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.capability.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.capability.deserializeNBT((NBTBase)nbt);
    }
}

