/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.block;

import com.teamwizardry.librarianlib.features.base.block.tile.TileMod;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.capability.chunk.WizardryChunk;
import com.teamwizardry.wizardry.api.capability.chunk.WizardryChunkCapability;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileCachable
extends TileMod {
    @Nonnull
    public WeakHashMap<TileEntity, Double> distanceCache = new WeakHashMap();
    private static int LINK_DIST_SQ = ConfigValues.networkLinkDistance * ConfigValues.networkLinkDistance;
    private static int CHUNK_RANGE = (ConfigValues.networkLinkDistance >> 4) + 1;
    private static int CHUNK_DIST_SQ = CHUNK_RANGE * CHUNK_RANGE;

    public void onLoad() {
        super.onLoad();
        int chunkX = this.field_174879_c.func_177958_n() >> 4;
        int chunkZ = this.field_174879_c.func_177952_p() >> 4;
        LinkedList<TileCachable> toCheck = new LinkedList<TileCachable>();
        for (int x = -CHUNK_RANGE; x <= CHUNK_RANGE; ++x) {
            for (int z = -CHUNK_RANGE; z <= CHUNK_RANGE; ++z) {
                if (x * x + z * z > CHUNK_DIST_SQ) continue;
                WizardryChunk chunk = WizardryChunkCapability.get(this.field_145850_b.func_72964_e(chunkX + x, chunkZ + z));
                toCheck.addAll(chunk.getCachableTiles());
            }
        }
        while (!toCheck.isEmpty()) {
            TileCachable tile = (TileCachable)((Object)toCheck.remove());
            double dist = tile.func_174877_v().func_177951_i((Vec3i)this.field_174879_c);
            if (!(dist <= (double)LINK_DIST_SQ)) continue;
            tile.distanceCache.put((TileEntity)this, dist);
            this.distanceCache.put((TileEntity)tile, dist);
        }
        WizardryChunk chunk = WizardryChunkCapability.get(this.field_145850_b.func_72964_e(chunkX, chunkZ));
        chunk.addCachableTile(this);
    }

    public double getCachedDistanceSq(TileEntity tile) {
        return this.distanceCache.getOrDefault(tile, (Double)Double.MAX_VALUE);
    }

    @Nonnull
    public <T extends TileEntity> Set<T> getNearestTiles(Class<T> clazz) {
        HashSet<TileEntity> poses = new HashSet<TileEntity>();
        for (TileEntity tile : this.distanceCache.keySet()) {
            if (tile == this || !this.field_145850_b.func_175667_e(tile.func_174877_v()) || !tile.getClass().isAssignableFrom(clazz)) continue;
            poses.add(tile);
        }
        return poses;
    }

    @Nullable
    public <T extends TileEntity> BlockPos getNearestTilePos(Class<T> clazz) {
        BlockPos closestTile = null;
        double lastDist = Double.MAX_VALUE;
        for (TileEntity tile : this.distanceCache.keySet()) {
            double distSQ;
            if (tile == this || !this.field_145850_b.func_175667_e(tile.func_174877_v()) || !tile.getClass().isAssignableFrom(clazz) || !(lastDist > (distSQ = this.distanceCache.get(tile).doubleValue()))) continue;
            lastDist = distSQ;
            closestTile = tile.func_174877_v();
        }
        return closestTile;
    }
}

