/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.pickletweaks.config.ModConfig;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairBlacklist;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.feature.item.ItemRepairKit;
import com.blakebr0.pickletweaks.feature.item.ItemRepairKitCustom;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GridRepairRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public GridRepairRecipe() {
        this.setRegistryName("pickletweaks", "grid_repair");
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return !this.getRepairOutput(inv).func_190926_b();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getRepairOutput(inv);
    }

    public ItemStack getRepairOutput(InventoryCrafting inv) {
        if (ModConfig.confRequires3x3 && (inv.func_174922_i() < 3 || inv.func_174923_h() < 3)) {
            return ItemStack.field_190927_a;
        }
        ItemStack tool = ItemStack.field_190927_a;
        boolean foundTool = false;
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            ItemStack newSlotStack = slotStack.func_77946_l();
            newSlotStack.func_190920_e(1);
            if (!foundTool && newSlotStack.func_77984_f()) {
                tool = newSlotStack;
                foundTool = true;
                continue;
            }
            inputs.add((Object)newSlotStack);
        }
        if (tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!ModConfig.confAllowArmor && tool.func_77973_b() instanceof ItemArmor) {
            return ItemStack.field_190927_a;
        }
        if (!tool.func_77951_h()) {
            return ItemStack.field_190927_a;
        }
        if (inputs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (tool.func_77973_b().hasContainerItem(tool)) {
            return ItemStack.field_190927_a;
        }
        if (GridRepairBlacklist.isBlacklisted(tool.func_77973_b())) {
            return ItemStack.field_190927_a;
        }
        int repairCost = ModConfig.confRepairCost;
        if (ModConfig.confCheaperShovel && tool.func_77973_b() instanceof ItemSpade) {
            repairCost = Math.max(1, repairCost / 2);
        }
        int damage = tool.func_77958_k() / repairCost;
        double matCount = 0.0;
        boolean repairKit = false;
        boolean maxed = false;
        for (ItemStack mat : inputs) {
            ItemMeta kit;
            if (maxed) {
                return ItemStack.field_190927_a;
            }
            if (!repairKit && mat.func_77973_b() instanceof ItemRepairKit) {
                if (matCount > 0.0) {
                    return ItemStack.field_190927_a;
                }
                kit = (ItemRepairKit)mat.func_77973_b();
                if (!ItemRepairKit.isKitValid(tool, kit.getKit(mat))) continue;
                repairKit = true;
                continue;
            }
            if (!repairKit && mat.func_77973_b() instanceof ItemRepairKitCustom) {
                if (matCount > 0.0) {
                    return ItemStack.field_190927_a;
                }
                kit = (ItemRepairKitCustom)mat.func_77973_b();
                if (!ItemRepairKitCustom.isKitValid(tool, kit.getKit(mat))) continue;
                repairKit = true;
                continue;
            }
            if (!repairKit && !mat.func_77973_b().hasContainerItem(mat)) {
                matCount += GridRepairHelper.getMaterialValue(tool, mat);
                if (!((double)tool.func_77952_i() - (double)damage * matCount <= 0.0)) continue;
                maxed = true;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (!repairKit && matCount == 0.0) {
            return ItemStack.field_190927_a;
        }
        if (repairKit) {
            tool.func_77964_b(0);
        } else {
            tool.func_77964_b(tool.func_77952_i() - (int)((double)damage * matCount));
        }
        return tool;
    }

    public boolean func_194133_a(int width, int height) {
        return ModConfig.confRequires3x3 ? width >= 3 && height >= 3 : true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

