/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.graphics.TextureUploader;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;

public class MapTileChunk {
    public static final int SIDE_LENGTH = 4;
    private static final int PBO_UNPACK_LENGTH = 16384;
    public static final int PBO_PACK_LENGTH = 16384;
    private MapRegion inRegion;
    private byte loadState = 0;
    private int X;
    private int Z;
    private MapTile[][] tiles = new MapTile[4][4];
    private byte[][] tileGridsCache = new byte[this.tiles.length][this.tiles.length];
    private int[] glTextures = new int[4];
    private ByteBuffer[] buffers = new ByteBuffer[4];
    private boolean[] toUpload = new boolean[4];
    private boolean[] toCache = new boolean[4];
    private int[] bufferFormat = new int[4];
    private boolean[] bufferIsCompressed = new boolean[4];
    private boolean uploaded;
    private boolean cachePrepared;
    private boolean updatingBuffers;
    private boolean success = true;
    private boolean changed;
    private Object updateBuffersSync;
    private int packPbo;
    private int[] unpackPbo;
    private byte currentUnpackPboIndex;
    private int uploadingStartLevel = -1;
    private boolean shouldDownloadFromPBO;
    private int timer;
    private boolean includeInSave;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTileChunk(MapRegion r, int x, int z) {
        this.X = x;
        this.Z = z;
        this.inRegion = r;
        this.updateBuffersSync = new Object();
        this.unpackPbo = new int[2];
        for (int i = 0; i < this.glTextures.length; ++i) {
            this.glTextures[i] = -1;
            this.bufferFormat[i] = -1;
        }
        MapRegion mapRegion = r;
        synchronized (mapRegion) {
            r.setAllCachePrepared(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toUpload(int start, boolean onlyCurrent) {
        MapTileChunk mapTileChunk = this;
        synchronized (mapTileChunk) {
            int preStart;
            if (this.uploaded) {
                return -1;
            }
            if (this.uploadingStartLevel == -1) {
                this.uploadingStartLevel = start;
            }
            if ((preStart = this.uploadingStartLevel - 1) < 0) {
                preStart = this.toUpload.length - 1;
            }
            int i = this.uploadingStartLevel;
            if (onlyCurrent) {
                return this.toUpload[i] ? i : -1;
            }
            while (true) {
                if (this.toUpload[i]) {
                    return i;
                }
                if (i == preStart) break;
                i = (i + 1) % this.toUpload.length;
            }
            this.uploadingStartLevel = -1;
            this.uploaded = true;
            return -1;
        }
    }

    public ByteBuffer createBuffer() {
        return BufferUtils.createByteBuffer((int)16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuffers(World world) {
        Object object = this.updateBuffersSync;
        synchronized (object) {
            Object object2 = this;
            synchronized (object2) {
                this.updatingBuffers = true;
            }
            if (WorldMap.settings.detailed_debug) {
                System.out.println("Updating buffers: " + this.X + " " + this.Z + " " + this.loadState);
            }
            object2 = this.inRegion;
            synchronized (object2) {
                this.cachePrepared = false;
                this.shouldDownloadFromPBO = false;
                this.inRegion.setAllCachePrepared(false);
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] != null) {
                    this.buffers[i].clear();
                    BufferUtils.zeroBuffer((ByteBuffer)this.buffers[i]);
                    continue;
                }
                this.buffers[i] = this.createBuffer();
            }
            int[] red = this.inRegion.getRedBuffer();
            int[] green = this.inRegion.getGreenBuffer();
            int[] blue = this.inRegion.getBlueBuffer();
            float[] brightnessBuffer = this.inRegion.getBrightnessBuffer();
            float[] postBrightnessBuffer = this.inRegion.getPostBrightnessBuffer();
            BlockPos.MutableBlockPos mutableGlobalPos = this.inRegion.getMutableGlobalPos();
            this.success = true;
            for (int o = 0; o < this.tiles.length; ++o) {
                int offX = o * 16;
                for (int p = 0; p < this.tiles.length; ++p) {
                    MapTile tile = this.tiles[o][p];
                    if (tile == null || !tile.isLoaded()) continue;
                    int offZ = p * 16;
                    if (tile.getPrevTile() == null || p == 0 && (this.Z & 7) == 0) {
                        this.findPrevTile(null, tile, o, p);
                    }
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            tile.getBlock(x, z).getPixelColour(red, green, blue, MapProcessor.instance.getMapWriter(), world, this, tile.getPrevTile(), tile, x, z, brightnessBuffer, postBrightnessBuffer, mutableGlobalPos);
                            for (int i = 0; i < red.length; ++i) {
                                this.putColour(offX + x, offZ + z, red[i], green[i], blue[i], this.buffers[i], 64);
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                this.bufferFormat[i] = -1;
                this.bufferIsCompressed[i] = false;
                this.toUpload[i] = true;
                this.toCache[i] = false;
            }
            MapTileChunk mapTileChunk = this;
            synchronized (mapTileChunk) {
                this.uploaded = false;
                this.updatingBuffers = false;
            }
        }
    }

    public boolean bindGlTexture(boolean create, int daynight) {
        boolean result = false;
        if (this.glTextures[daynight] == -1) {
            if (create) {
                this.glTextures[daynight] = GL11.glGenTextures();
                result = true;
            } else {
                return false;
            }
        }
        GlStateManager.func_179144_i((int)this.glTextures[daynight]);
        if (result) {
            GL11.glTexParameteri((int)3553, (int)33084, (int)0);
            GL11.glTexParameteri((int)3553, (int)33085, (int)1);
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)33083, (float)1.0f);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
        return true;
    }

    public long uploadBuffer(TextureUploader textureUploader, int lightLevel) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        ByteBuffer buffer = this.buffers[lightLevel];
        if (WorldMap.settings.detailed_debug) {
            System.out.println("Uploading buffer: " + this.X + " " + this.Z + " " + this.bufferFormat[lightLevel] + " " + this.bufferIsCompressed[lightLevel]);
        }
        if (this.bufferFormat[lightLevel] != -1) {
            int length = buffer.remaining();
            this.currentUnpackPboIndex = (byte)(this.currentUnpackPboIndex + 1 & 1);
            this.bindUnpackPBO();
            ByteBuffer mappedPBO = GL15.glMapBuffer((int)35052, (int)35001, (long)16384L, null);
            mappedPBO.put(buffer);
            GL15.glUnmapBuffer((int)35052);
            this.unbindUnpackPBO();
            boolean isCompressed = this.bufferIsCompressed[lightLevel];
            int internalFormat = this.bufferFormat[lightLevel];
            this.bufferIsCompressed[lightLevel] = false;
            this.bufferFormat[lightLevel] = -1;
            this.bindGlTexture(true, lightLevel);
            Util.checkGLError();
            if (isCompressed) {
                return textureUploader.requestCompressed(this.glTextures[lightLevel], this.unpackPbo[this.currentUnpackPboIndex], 3553, 0, internalFormat, 64, 64, 0, 0L, length);
            }
            return textureUploader.requestNormal(this.glTextures[lightLevel], this.unpackPbo[this.currentUnpackPboIndex], 3553, 0, internalFormat, 64, 64, 0, 0L, 32993, 32821);
        }
        if (!this.shouldDownloadFromPBO) {
            this.currentUnpackPboIndex = (byte)(this.currentUnpackPboIndex + 1 & 1);
            this.bindUnpackPBO();
            ByteBuffer mappedPBO = GL15.glMapBuffer((int)35052, (int)35001, (long)16384L, null);
            mappedPBO.put(buffer);
            GL15.glUnmapBuffer((int)35052);
            this.unbindUnpackPBO();
            this.timer = 5;
            this.shouldDownloadFromPBO = true;
            this.bindPackPBO();
            this.unbindPackPBO();
            this.bindGlTexture(true, lightLevel);
            Util.checkGLError();
            return textureUploader.requestNormalWithDownload(this.glTextures[lightLevel], this.unpackPbo[this.currentUnpackPboIndex], 3553, 0, 34029, 64, 64, 0, 0L, 32993, 33639, this.packPbo);
        }
        int glTexture = this.glTextures[lightLevel];
        GlStateManager.func_179144_i((int)glTexture);
        int isCompressed = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34465);
        int length = isCompressed == 1 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34464) : 16384;
        Util.checkGLError();
        this.bindPackPBO();
        ByteBuffer mappedPBO = GL15.glMapBuffer((int)35051, (int)35000, (long)length, null);
        Util.checkGLError();
        buffer.clear();
        buffer.put(mappedPBO);
        buffer.flip();
        GL15.glUnmapBuffer((int)35051);
        Util.checkGLError();
        this.unbindPackPBO();
        Util.checkGLError();
        int format = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        Util.checkGLError();
        this.bufferFormat[lightLevel] = format;
        if (format == -1) {
            throw new RuntimeException("Invalid texture internal format returned by the driver.");
        }
        this.bufferIsCompressed[lightLevel] = isCompressed == 1;
        this.shouldDownloadFromPBO = false;
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer) throws IOException {
        for (int l = 0; l < 4; ++l) {
            output.write(this.bufferIsCompressed[l] ? 1 : 0);
            output.writeInt(this.bufferFormat[l]);
            int length = this.buffers[l].remaining();
            output.writeInt(length);
            this.buffers[l].get(usableBuffer, 0, length);
            output.write(usableBuffer, 0, length);
            this.deleteBuffer(l);
            MapRegion mapRegion = this.inRegion;
            synchronized (mapRegion) {
                this.cachePrepared = false;
                this.inRegion.setAllCachePrepared(false);
                continue;
            }
        }
    }

    public void readCacheData(int cacheSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, int levelsToBuffer) throws IOException {
        for (int l = 0; l < 4; ++l) {
            this.bufferIsCompressed[l] = true;
            if (cacheSaveVersion > 1) {
                this.bufferIsCompressed[l] = input.read() == 1;
            }
            this.bufferFormat[l] = input.readInt();
            int length = input.readInt();
            for (int currentTotal = 0; currentTotal < length; currentTotal += input.read(usableBuffer, currentTotal, length - currentTotal)) {
            }
            if (l >= levelsToBuffer) continue;
            if (this.buffers[l] == null) {
                this.buffers[l] = this.createBuffer();
            }
            this.buffers[l].put(usableBuffer, 0, length);
            this.buffers[l].flip();
            this.toUpload[l] = true;
        }
        this.loadState = (byte)2;
    }

    public void putColour(int x, int y, int red, int green, int blue, ByteBuffer buffer, int size) {
        int pos = (y * size + x) * 4;
        buffer.put(pos, (byte)blue);
        buffer.put(++pos, (byte)green);
        buffer.put(++pos, (byte)red);
        buffer.put(++pos, (byte)-1);
    }

    public void findPrevTile(MapRegion prevRegion, MapTile tile, int o, int p) {
        if (p > 0) {
            tile.setPrevTile(this.tiles[o][p - 1]);
        } else {
            int chunkXInsideRegion = this.X & 7;
            int chunkZInsideRegion = this.Z & 7;
            MapTileChunk prevTileChunk = null;
            if (chunkZInsideRegion > 0) {
                prevTileChunk = this.inRegion.getChunk(chunkXInsideRegion, chunkZInsideRegion - 1);
            } else {
                if (prevRegion == null) {
                    prevRegion = MapProcessor.instance.getMapRegion(this.inRegion.getRegionX(), this.inRegion.getRegionZ() - 1, false);
                }
                if (prevRegion != null) {
                    prevTileChunk = prevRegion.getChunk(chunkXInsideRegion, 7);
                }
            }
            if (prevTileChunk != null) {
                tile.setPrevTile(prevTileChunk.tiles[o][prevTileChunk.tiles.length - 1]);
            }
        }
    }

    private void bindPackPBO() {
        boolean created = false;
        if (this.packPbo == 0) {
            this.packPbo = GL15.glGenBuffers();
            created = true;
        }
        GL15.glBindBuffer((int)35051, (int)this.packPbo);
        if (created) {
            GL15.glBufferData((int)35051, (long)16384L, (int)35041);
        }
    }

    private void bindUnpackPBO() {
        boolean created = false;
        if (this.unpackPbo[this.currentUnpackPboIndex] == 0) {
            this.unpackPbo[this.currentUnpackPboIndex] = GL15.glGenBuffers();
            created = true;
        }
        GL15.glBindBuffer((int)35052, (int)this.unpackPbo[this.currentUnpackPboIndex]);
        if (created) {
            GL15.glBufferData((int)35052, (long)16384L, (int)35040);
        }
    }

    private void unbindPackPBO() {
        GL15.glBindBuffer((int)35051, (int)0);
    }

    private void unbindUnpackPBO() {
        GL15.glBindBuffer((int)35052, (int)0);
    }

    public void deletePBOs() {
        if (this.packPbo > 0) {
            MapProcessor.instance.getBuffersToDelete().add(this.packPbo);
        }
        this.packPbo = 0;
        for (int i = 0; i < this.unpackPbo.length; ++i) {
            if (this.unpackPbo[i] <= 0) continue;
            MapProcessor.instance.getBuffersToDelete().add(this.unpackPbo[i]);
            this.unpackPbo[i] = 0;
        }
    }

    public void clean() {
        for (int o = 0; o < 4; ++o) {
            for (int p = 0; p < 4; ++p) {
                MapTile tile = this.tiles[o][p];
                if (tile == null) continue;
                if (tile.getPrevTile() != null) {
                    tile.setPrevTile(null);
                }
                MapProcessor.instance.getTilePool().addToPool(tile);
                this.tiles[o][p] = null;
            }
        }
        this.includeInSave = false;
    }

    public int getX() {
        return this.X;
    }

    public int getZ() {
        return this.Z;
    }

    public byte[][] getTileGridsCache() {
        return this.tileGridsCache;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(byte loadState) {
        this.loadState = loadState;
    }

    public boolean shouldUpload(int lightLevel) {
        return this.toUpload[lightLevel];
    }

    public void setToUpload(int lightLevel, boolean value) {
        this.toUpload[lightLevel] = value;
    }

    public ByteBuffer getBuffer(int lightLevel) {
        return this.buffers[lightLevel];
    }

    public void deleteBuffer(int lightLevel) {
        MapProcessor.instance.getBufferDeallocator().deallocate(this.buffers[lightLevel], WorldMap.settings.debug);
        this.buffers[lightLevel] = null;
    }

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public void setCachePrepared(boolean cachePrepared) {
        this.cachePrepared = cachePrepared;
    }

    public boolean isUpdatingBuffers() {
        return this.updatingBuffers;
    }

    public MapTile getTile(int x, int z) {
        return this.tiles[x][z];
    }

    public void setTile(int x, int z, MapTile tile) {
        this.tiles[x][z] = tile;
        this.includeInSave = true;
    }

    public MapRegion getInRegion() {
        return this.inRegion;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean wasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getGlTexture(int lightLevel) {
        return this.glTextures[lightLevel];
    }

    public int[] getGlTextures() {
        return this.glTextures;
    }

    public boolean[] getToUpload() {
        return this.toUpload;
    }

    public boolean getBufferIsCompressed(int lightLevel) {
        return this.bufferIsCompressed[lightLevel];
    }

    public int getBufferFormat(int lightLevel) {
        return this.bufferFormat[lightLevel];
    }

    public int getTimer() {
        return this.timer;
    }

    public void decTimer() {
        --this.timer;
    }

    public boolean shouldDownloadFromPBO() {
        return this.shouldDownloadFromPBO;
    }

    public boolean includeInSave() {
        return this.includeInSave;
    }
}

