/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.util.Hashtable;
import xaero.map.MapProcessor;
import xaero.map.pool.PoolUnit;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;

public class MapTile
implements PoolUnit {
    private boolean loaded;
    private int chunkX;
    private int chunkZ;
    private MapBlock[][] blocks = new MapBlock[16][16];
    private MapTile prevTile;
    private String dim;
    private boolean writtenOnce;

    public MapTile(Object ... args) {
        this.create(args);
    }

    @Override
    public void create(Object ... args) {
        this.chunkX = (Integer)args[1];
        this.chunkZ = (Integer)args[2];
        this.dim = (String)args[0];
        this.loaded = false;
        this.writtenOnce = false;
        this.prevTile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion getRegion() {
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = MapProcessor.instance.getFullMap();
        synchronized (hashtable) {
            return MapProcessor.instance.getCurrentMap(this.dim).get(this.chunkX >> 5).get(this.chunkZ >> 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTileChunk getChunk() {
        int tileChunkX = this.chunkX >> 2;
        int tileChunkZ = this.chunkZ >> 2;
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = MapProcessor.instance.getFullMap();
        synchronized (hashtable) {
            return MapProcessor.instance.getCurrentMap(this.dim).get(tileChunkX >> 3).get(tileChunkZ >> 3).getChunk(tileChunkX & 7, tileChunkZ & 7);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public MapTile getPrevTile() {
        return this.prevTile;
    }

    public void setPrevTile(MapTile prevTile) {
        this.prevTile = prevTile;
    }

    public MapBlock getBlock(int x, int z) {
        return this.blocks[x][z];
    }

    public MapBlock[] getBlockColumn(int x) {
        return this.blocks[x];
    }

    public void setBlock(int x, int z, MapBlock block) {
        this.blocks[x][z] = block;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public boolean wasWrittenOnce() {
        return this.writtenOnce;
    }

    public void setWrittenOnce(boolean writtenOnce) {
        this.writtenOnce = writtenOnce;
    }
}

