/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;

public class SupportXaeroMinimap {
    private static final int WAYPOINT_HALF_WIDTH = 14;
    private static final int WAYPOINT_HEIGHT = 41;
    IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private ArrayList<Waypoint> waypoints;

    public SupportXaeroMinimap() {
        try {
            this.modMain = SupportBetterPVP.getMain();
            System.out.println("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (NoClassDefFoundError e) {
            try {
                this.modMain = SupportMinimap.getMain();
                System.out.println("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            this.waypointsManager = this.modMain.getWaypointsManager();
        }
    }

    public boolean waypointIsGood(Waypoint w) {
        return w != null && !w.isDisabled() && (w.getType() != 1 || this.deathpoints);
    }

    public ArrayList<Waypoint> convertWaypoints() {
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (this.waypointsManager.getWaypoints() == null) {
            return null;
        }
        ArrayList list = this.waypointsManager.getWaypoints().getList();
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            result.add(this.convertWaypoint(w, true));
        }
        if (ServerWaypointStorage.working() && this.waypointsManager.getServerWaypoints() != null) {
            for (xaero.common.minimap.waypoints.Waypoint w : this.waypointsManager.getServerWaypoints()) {
                result.add(this.convertWaypoint(w, false));
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable) {
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], w.getType(), editable);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        return converted;
    }

    public void openWaypoint(GuiScreen parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()));
    }

    public void teleportToWaypoint(GuiScreen screen, Waypoint w) {
        if (!w.isRotation()) {
            screen.func_175281_b("/" + this.modMain.getSettings().waypointTp + " " + w.getX() + " " + w.getY() + " " + w.getZ(), false);
        } else {
            screen.func_175281_b("/" + this.modMain.getSettings().waypointTp + " " + w.getX() + " " + w.getY() + " " + w.getZ() + " " + w.getYaw() + " ~", false);
        }
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        waypoint.setDisabled(!waypoint.isDisabled());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        this.waypointsManager.getWaypoints().getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        try {
            this.modMain.getSettings().saveWaypoints();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waypoints.remove(waypoint);
    }

    public boolean isOnScreen(Waypoint w, double cameraX, double cameraZ, int width, int height, double scale) {
        double xOnScreen = ((double)w.getX() - cameraX) * scale + (double)(width / 2);
        double zOnScreen = ((double)w.getZ() - cameraZ) * scale + (double)(height / 2);
        return xOnScreen < (double)width && xOnScreen > 0.0 && zOnScreen < (double)height && zOnScreen > 0.0;
    }

    public ArrayList<Waypoint> renderWaypoints(GuiScreen gui, double cameraX, double cameraZ, int width, int height, double fboScale, double fullScale, double mouseX, double mouseZ, Pattern regex, Pattern regexStartsWith) {
        if (this.refreshWaypoints) {
            this.waypoints = this.convertWaypoints();
            this.refreshWaypoints = false;
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
            }
        }
        float half = (float)(1.0 / fboScale * (double)((int)fboScale / 2));
        if (this.waypoints == null) {
            return null;
        }
        Waypoint viewed = null;
        for (int i = this.waypoints.size() - 1; i >= 0; --i) {
            Waypoint w = this.waypoints.get(i);
            if (!this.waypointIsGood(w) || !(Math.abs((double)w.getX() - mouseX) <= 14.0 / fboScale) || !((double)w.getZ() > mouseZ) || !((double)w.getZ() - 41.0 / fboScale < mouseZ)) continue;
            viewed = w;
            break;
        }
        ArrayList<Waypoint> outsideWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w)) continue;
            if (this.isOnScreen(w, cameraX, cameraZ, width, height, fullScale)) {
                w.renderShadow(gui, fboScale, (float)(w.getX() - ((w.getX() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half, (float)(w.getZ() - ((w.getZ() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half);
                continue;
            }
            if (regex == null) {
                outsideWaypoints.add(w);
                continue;
            }
            if (regexStartsWith.matcher(w.getName().toLowerCase()).find()) {
                outsideWaypoints.add(0, w);
                continue;
            }
            if (!regex.matcher(w.getName().toLowerCase()).find()) continue;
            outsideWaypoints.add(w);
        }
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w) || w == viewed || !this.isOnScreen(w, cameraX, cameraZ, width, height, fullScale)) continue;
            w.renderWaypoint(gui, fboScale, (float)(w.getX() - ((w.getX() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half, (float)(w.getZ() - ((w.getZ() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half, false);
        }
        if (viewed != null) {
            viewed.renderWaypoint(gui, fboScale, (float)(viewed.getX() - ((viewed.getX() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half, (float)(viewed.getZ() - ((viewed.getZ() & 1) != 0 && fboScale < 1.0 ? 1 : 0)) + half, true);
        }
        outsideWaypoints.add(0, viewed);
        return outsideWaypoints;
    }

    public void renderSideWaypoints(GuiScreen gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int selected) {
        int yPos = height - 2;
        if (offset > 0) {
            yPos = this.drawThreeDots(yPos, width);
        }
        for (int i = offset; i < sideWaypoints.size(); ++i) {
            float wpScale = i == selected ? 1.5f : 1.0f;
            yPos = (int)((float)yPos - 5.0f * wpScale);
            sideWaypoints.get(i).renderSideWaypoint(gui, (float)(width - 2) - 5.0f * wpScale, yPos, wpScale);
            yPos = (int)((float)yPos - (1.0f + 4.0f * wpScale));
            if (i + 1 >= sideWaypoints.size() || i - offset != 6) continue;
            yPos = this.drawThreeDots(yPos, width);
            break;
        }
    }

    private int drawThreeDots(int yPos, int width) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a("...", (float)(width - 7 - Minecraft.func_71410_x().field_71466_p.func_78256_a("...") / 2), (float)((yPos -= 9) - 4), Waypoint.white, true);
        return yPos -= 5;
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }
}

