/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.file.RegionDetection;
import xaero.map.region.MapRegion;

public class MapLimiter {
    private static final int MIN_LIMIT = 50;
    private int availableVRAM = -1;
    private int mostRegionsAtATime;
    private IntBuffer vramBuffer = BufferUtils.createByteBuffer((int)64).asIntBuffer();

    public int getAvailableVRAM() {
        return this.availableVRAM;
    }

    public void updateAvailableVRAM() {
        this.vramBuffer.clear();
        this.vramBuffer.put(0, -1);
        GL11.glGetInteger((int)36937, (IntBuffer)this.vramBuffer);
        int availableVRAM = this.vramBuffer.get(0);
        int error = GL11.glGetError();
        if (availableVRAM == -1 || error != 0) {
            this.vramBuffer.position(0);
            GL11.glGetInteger((int)34812, (IntBuffer)this.vramBuffer);
            availableVRAM = this.vramBuffer.get(0);
            error = GL11.glGetError();
            if (error != 0) {
                availableVRAM = -1;
            }
        }
        this.availableVRAM = availableVRAM;
    }

    public int getMostRegionsAtATime() {
        return this.mostRegionsAtATime;
    }

    public void setMostRegionsAtATime(int mostRegionsAtATime) {
        this.mostRegionsAtATime = mostRegionsAtATime;
    }

    public void applyLimit(List<MapRegion> regionsSorted) {
        int limit = Math.max(this.mostRegionsAtATime, 50);
        int vramDetermined = 0;
        if (this.availableVRAM != -1) {
            vramDetermined = regionsSorted.size();
            if (this.availableVRAM < 102400) {
                vramDetermined = vramDetermined * 3 / 4;
            }
        } else {
            vramDetermined = 400;
        }
        if (vramDetermined > limit) {
            limit = vramDetermined;
        }
        MapProcessor.instance.pushRenderPause(false, true);
        MapRegion nextToLoad = MapProcessor.instance.getMapSaveLoad().getNextToLoadByViewing();
        for (int i = 0; i < regionsSorted.size() && regionsSorted.size() > limit; ++i) {
            MapRegion region = regionsSorted.get(i);
            if (region.getLoadState() != 4 && region.getLoadState() != 0) continue;
            region.deleteTexturesAndBuffers();
            region.pushWriterPause();
            RegionDetection restoredDetection = new RegionDetection(region.getWorld(), region.getRegionX(), region.getRegionZ());
            restoredDetection.transferInfoFrom(region);
            MapProcessor.instance.addRegionDetection(restoredDetection);
            MapProcessor.instance.removeMapRegion(region);
            MapProcessor.instance.removeToProcess(region);
            MapProcessor.instance.getMapSaveLoad().removeToLoad(region);
            MapProcessor.instance.getMapSaveLoad().cancelAllLoadRequests(region);
            MapProcessor.instance.getMapSaveLoad().removeToCache(region);
            region.popWriterPause();
            if (region == nextToLoad) {
                MapProcessor.instance.getMapSaveLoad().setNextToLoadByViewing(null);
            }
            --i;
        }
        MapProcessor.instance.popRenderPause(false, true);
    }
}

