/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.hotornot;

import com.buuz135.hotornot.proxy.CommonProxy;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod(modid="hotornot", name="HotOrNot", version="1.1.2", acceptedMinecraftVersions="[1.12.2]")
public class HotOrNot {
    public static final String MOD_ID = "hotornot";
    public static final String MOD_NAME = "HotOrNot";
    public static final String VERSION = "1.1.2";
    @SidedProxy(clientSide="com.buuz135.hotornot.proxy.ClientProxy", serverSide="com.buuz135.hotornot.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class HotTooltip {
        @SubscribeEvent
        public static void onTooltip(ItemTooltipEvent event) {
            IFluidHandlerItem fluidHandlerItem;
            FluidStack fluidStack;
            ItemStack stack = event.getItemStack();
            if (HotConfig.TOOLTIP && !stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidStack = (fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(1000, false)) != null) {
                for (FluidEffect effect : FluidEffect.values()) {
                    if (!effect.isValid.test(fluidStack)) continue;
                    event.getToolTip().add(effect.color + new TextComponentTranslation(effect.tooltip, new Object[0]).func_150260_c());
                }
            }
        }
    }

    @Config(modid="hotornot")
    public static class HotConfig {
        @Config.Comment(value={"How hot a fluid should be to start burning the player (in kelvin)"})
        public static int HOT = 1300;
        @Config.Comment(value={"How cold a fluid should be to start adding effects the player (in kelvin)"})
        public static int COLD = 273;
        @Config.Comment(value={"If true gaseous effects for the fluids will be enabled"})
        public static boolean GASEOUS = true;
        @Config.Comment(value={"If true, the items that contain hot fluid will have a tooltip that will show that they are too hot"})
        public static boolean TOOLTIP = true;
        @Config.Comment(value={"Max durability of the mitts"})
        public static int MITTS_DURABILITY = 12000;

        @Mod.EventBusSubscriber(modid="hotornot")
        private static class EventHandler {
            private EventHandler() {
            }

            @SubscribeEvent
            public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
                if (event.getModID().equals(HotOrNot.MOD_ID)) {
                    ConfigManager.sync((String)HotOrNot.MOD_ID, (Config.Type)Config.Type.INSTANCE);
                }
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ServerTick {
        @SubscribeEvent
        public static void onTick(TickEvent.WorldTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                for (EntityPlayerMP entityPlayerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    if (entityPlayerMP.func_70027_ad() || entityPlayerMP.func_184812_l_() || !entityPlayerMP.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
                    IItemHandler handler = (IItemHandler)entityPlayerMP.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        IFluidHandlerItem fluidHandlerItem;
                        FluidStack fluidStack;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (fluidStack = (fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(1000, false)) == null) continue;
                        for (FluidEffect effect : FluidEffect.values()) {
                            if (!effect.isValid.test(fluidStack)) continue;
                            ItemStack offHand = entityPlayerMP.func_184592_cb();
                            if (offHand.func_77973_b().equals((Object)CommonProxy.MITTS)) {
                                offHand.func_77972_a(1, (EntityLivingBase)entityPlayerMP);
                                continue;
                            }
                            if (event.world.func_82737_E() % 20L != 0L) continue;
                            effect.interactPlayer.accept(entityPlayerMP);
                        }
                    }
                }
            }
        }
    }

    public static enum FluidEffect {
        HOT(fluidStack -> fluidStack.getFluid().getTemperature(fluidStack) >= HotConfig.HOT, entityPlayerMP -> entityPlayerMP.func_70015_d(1), TextFormatting.RED, "tooltip.hotornot.toohot"),
        COLD(fluidStack -> fluidStack.getFluid().getTemperature(fluidStack) <= HotConfig.COLD, entityPlayerMP -> {
            entityPlayerMP.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 21, 1));
            entityPlayerMP.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 21, 1));
        }, TextFormatting.AQUA, "tooltip.hotornot.toocold"),
        GAS(fluidStack -> fluidStack.getFluid().isGaseous(fluidStack) && HotConfig.GASEOUS, entityPlayerMP -> entityPlayerMP.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 21, 1)), TextFormatting.YELLOW, "tooltip.hotornot.toolight");

        private final Predicate<FluidStack> isValid;
        private final Consumer<EntityPlayerMP> interactPlayer;
        private final TextFormatting color;
        private final String tooltip;

        private FluidEffect(Predicate<FluidStack> isValid, Consumer<EntityPlayerMP> interactPlayer, TextFormatting color, String tooltip) {
            this.isValid = isValid;
            this.interactPlayer = interactPlayer;
            this.color = color;
            this.tooltip = tooltip;
        }
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        public static void addItems(RegistryEvent.Register<Item> event) {
            proxy.registerItems(event);
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void modelRegistryEvent(ModelRegistryEvent event) {
            proxy.modelRegistryEvent(event);
        }
    }
}

