/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.mojang.authlib.GameProfile;
import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.RandomTweaks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class PlayerHeadDropHandler {
    @SubscribeEvent
    public static void onPlayerDrops(PlayerDropsEvent event) {
        EntityCreeper creeper;
        if (!RTConfig.playerHeadDrops.enabled || RandomTweaks.PLAYERS_DROP_HEADS_LOADED || RandomTweaks.HEADCRUMBS_LOADED) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity source = event.getSource().func_76346_g();
        if (source instanceof EntityCreeper && (creeper = (EntityCreeper)source).func_70830_n() && creeper.func_70650_aV() && PlayerHeadDropHandler.dropSkull(player, RTConfig.playerHeadDrops.chanceWhenKilledByChargedCreeper)) {
            creeper.func_175493_co();
            return;
        }
        if (source != player && source instanceof EntityPlayer) {
            PlayerHeadDropHandler.dropSkull(player, RTConfig.playerHeadDrops.chanceWhenKilledByPlayer);
            return;
        }
        PlayerHeadDropHandler.dropSkull(player, RTConfig.playerHeadDrops.normalChance);
    }

    public static boolean dropSkull(EntityPlayer player, double chance) {
        if (chance != 1.0 && player.func_130014_f_().field_73012_v.nextDouble() >= chance) {
            return false;
        }
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound skullOwner = new NBTTagCompound();
        NBTUtil.func_180708_a((NBTTagCompound)skullOwner, (GameProfile)player.func_146103_bH());
        stack.func_77978_p().func_74782_a("SkullOwner", (NBTBase)skullOwner);
        player.func_146097_a(stack, true, false);
        return true;
    }
}

