/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.common.ColoredSheepHandler;
import com.therandomlabs.randomtweaks.common.RTFoodStats;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class MiscEventHandler {
    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent.Arrow event) {
        if (!RTConfig.misc.pickUpSkeletonArrows) {
            return;
        }
        EntityArrow arrow = event.getArrow();
        if (!arrow.func_130014_f_().field_72995_K && arrow.field_70250_c instanceof EntitySkeleton && arrow.field_70251_a == EntityArrow.PickupStatus.DISALLOWED) {
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        IAttributeInstance attackSpeed = player.func_110148_a(SharedMonsterAttributes.field_188790_f);
        attackSpeed.func_111128_a(RTConfig.misc.attackSpeed);
        if (RTConfig.hunger.enabled && !RandomTweaks.APPLECORE_LOADED) {
            player.field_71100_bB = new RTFoodStats(player.field_71100_bB);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityAgeable)) {
            return;
        }
        if (RTConfig.sheepColorWeights.enabled && !RandomTweaks.COLORFUL_SHEEP_LOADED && entity.getClass() == EntitySheep.class) {
            ColoredSheepHandler.onSheepSpawn((EntitySheep)entity);
        }
        if (RTConfig.randomizedAges.chance != 0.0) {
            EntityAgeable ageable = (EntityAgeable)entity;
            if (ageable.func_70631_g_()) {
                return;
            }
            Random rng = ageable.func_70681_au();
            if (rng.nextDouble() < RTConfig.randomizedAges.chance) {
                int min = RTConfig.randomizedAges.minimumAge;
                int max = RTConfig.randomizedAges.maximumAge;
                if (min == max) {
                    ageable.func_70873_a(min);
                } else {
                    ageable.func_70873_a(rng.nextInt(max + 1 - min) + min);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        IEntityOwnable otherPet;
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (source == DamageSource.field_76379_h) {
            String fallDamage = RTConfig.misc.fallDamageMultiplierGameRuleName;
            if (fallDamage.isEmpty()) {
                return;
            }
            float multiplier = 0.0f;
            try {
                multiplier = Float.parseFloat(entity.func_130014_f_().func_82736_K().func_82767_a(fallDamage));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (multiplier == 0.0f) {
                event.setCanceled(true);
            } else if (multiplier <= 0.0f) {
                event.setCanceled(true);
                entity.func_70606_j(Math.max(entity.func_110143_aJ() + event.getAmount() * multiplier, entity.func_110138_aP()));
            } else {
                event.setAmount(event.getAmount() * multiplier);
            }
            return;
        }
        Entity attacker = source.func_76346_g();
        if (attacker == null || !(entity instanceof IEntityOwnable)) {
            return;
        }
        IEntityOwnable pet = (IEntityOwnable)entity;
        UUID owner = pet.func_184753_b();
        if (owner == null) {
            return;
        }
        boolean protectFromSneaking = RTConfig.animals.protectPetsFromSneakingOwners;
        if (RTConfig.animals.protectPetsFromOwners && owner.equals(attacker.func_110124_au()) && (!protectFromSneaking || protectFromSneaking && !attacker.func_70093_af())) {
            event.setCanceled(true);
            return;
        }
        if (RTConfig.animals.protectPetsFromOtherPets && attacker instanceof IEntityOwnable && owner.equals((otherPet = (IEntityOwnable)attacker).func_184753_b())) {
            entity.func_70604_c(null);
            ((EntityLivingBase)attacker).func_70604_c(null);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (RandomTweaks.VANILLATWEAKS_LOADED) {
            return;
        }
        Entity entity = event.getEntity();
        if (!entity.func_130014_f_().func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        if (RTConfig.animals.batLeatherDropChance != 0.0 && entity instanceof EntityBat && Math.random() < RTConfig.animals.batLeatherDropChance) {
            entity.func_145779_a(Items.field_151116_aA, 1);
        }
        if (!RTConfig.misc.entitiesDropNameTags) {
            return;
        }
        String customName = entity.func_95999_t();
        if (customName.isEmpty()) {
            return;
        }
        ItemStack nameTag = new ItemStack(Items.field_151057_cb);
        nameTag.func_151001_c(customName);
        entity.func_70099_a(nameTag, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        if (RandomTweaks.RANDOMCONFIGS_LOADED || !RTConfig.misc.disableAttacksDuringAttackCooldown) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_130014_f_().field_72995_K && player.func_184825_o(0.5f) != 1.0f) {
            player.func_184821_cY();
            event.setCanceled(true);
        }
    }
}

