/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.google.common.collect.ImmutableSet;
import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.RandomTweaks;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class EntityInteractHandler {
    public static final ImmutableSet<Item> OCELOT_HEAL_ITEMS = ImmutableSet.of((Object)Items.field_151115_aP);
    public static final ImmutableSet<Item> PARROT_HEAL_ITEMS = ImmutableSet.of((Object)Items.field_151014_N, (Object)Items.field_151081_bc, (Object)Items.field_151080_bb, (Object)Items.field_185163_cU);

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ImmutableSet<Item> healItems;
        if (event.getWorld().field_72995_K) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (target instanceof EntityVillager) {
            EntityInteractHandler.onVillagerInteract(player, (EntityVillager)target, stack, event);
            return;
        }
        if (target instanceof EntityOcelot) {
            if (!RTConfig.animals.ocelotsCanBeHealed) {
                return;
            }
            healItems = OCELOT_HEAL_ITEMS;
        } else if (target instanceof EntityParrot) {
            if (!RTConfig.animals.parrotsCanBeHealed) {
                return;
            }
            healItems = PARROT_HEAL_ITEMS;
        } else {
            return;
        }
        EntityTameable tameable = (EntityTameable)target;
        int healAmount = EntityInteractHandler.getHealAmount(tameable, stack, healItems);
        if (healAmount != 0) {
            event.setCanceled(true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            tameable.func_70691_i((float)healAmount);
        }
    }

    private static int getHealAmount(EntityTameable entity, ItemStack stack, Set<Item> healItems) {
        if (!RandomTweaks.IS_DEOBFUSCATED && !entity.func_70909_n()) {
            return 0;
        }
        if (entity.func_110143_aJ() >= entity.func_110138_aP()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!healItems.contains(item)) {
            return 0;
        }
        return ((ItemFood)item).func_150905_g(stack);
    }

    private static void onVillagerInteract(EntityPlayer player, EntityVillager villager, ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        if (!RTConfig.animals.leashableVillagers) {
            return;
        }
        if (villager.func_110167_bD() && villager.func_110166_bE() == player) {
            villager.func_110160_i(true, !player.field_71075_bZ.field_75098_d);
            event.setCanceled(true);
            return;
        }
        if (stack.func_77973_b() != Items.field_151058_ca) {
            return;
        }
        villager.func_110162_b((Entity)player, true);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        event.setCanceled(true);
    }
}

