/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RTConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class ColoredSheepHandler {
    private static final Map<Integer, EnumDyeColor> queue = new HashMap<Integer, EnumDyeColor>();

    public static void onSheepSpawn(EntitySheep sheep) {
        double result = sheep.func_70681_au().nextDouble() * RTConfig.sheepColorWeights.totalWeight;
        double totalWeight = 0.0;
        for (Map.Entry<EnumDyeColor, Double> weight : RTConfig.sheepColorWeights.weights.entrySet()) {
            if (!((totalWeight += weight.getValue().doubleValue()) >= result)) continue;
            queue.put(sheep.func_145782_y(), weight.getKey());
            break;
        }
    }

    @SubscribeEvent
    public static void onSheepTick(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_130014_f_().field_72995_K || entity.getClass() != EntitySheep.class) {
            return;
        }
        EntitySheep sheep = (EntitySheep)entity;
        int id = sheep.func_145782_y();
        EnumDyeColor color = queue.get(id);
        if (color != null) {
            sheep.func_175512_b(color);
            queue.remove(id);
        }
    }
}

