/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.util.RTUtils;
import java.io.File;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomtweaks")
public final class TimeOfDayOverlay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean shouldHide;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        shouldHide = TimeOfDayOverlay.mc.field_71474_y.field_74330_P || TimeOfDayOverlay.mc.field_71474_y.field_74319_N;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        String minuteString;
        String ampm;
        if (TimeOfDayOverlay.shouldHide() || !TimeOfDayOverlay.isEnabledForCurrentWorld()) {
            return;
        }
        World world = TimeOfDayOverlay.mc.field_71439_g.func_130014_f_();
        long time = world.func_72820_D();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        long day = (time + 6000L) / 24000L + 1L;
        if (RTConfig.timeOfDay.twentyFourHourTime) {
            ampm = "";
        } else if (hour >= 12L) {
            if (hour != 12L) {
                hour -= 12L;
            }
            ampm = " " + RTUtils.localize("timeOfDayOverlay.pm", new Object[0]);
        } else {
            if (hour == 0L) {
                hour = 12L;
            }
            ampm = " " + RTUtils.localize("timeOfDayOverlay.am", new Object[0]);
        }
        String hourString = hour < 10L ? "0" + hour : Long.toString(hour);
        String string = minuteString = minute < 10L ? "0" + minute : Long.toString(minute);
        String dayOrNight = world.func_72967_a(1.0f) < 4 ? RTUtils.localize("timeOfDayOverlay." + (RTConfig.timeOfDay.lightOrDark ? "light" : "dayTime"), new Object[0]) : RTUtils.localize("timeOfDayOverlay." + (RTConfig.timeOfDay.lightOrDark ? "dark" : "nightTime"), new Object[0]);
        String timeString = RTUtils.localize("timeOfDayOverlay.text", day, hourString, minuteString, ampm, dayOrNight);
        int textWidth = TimeOfDayOverlay.mc.field_71466_p.func_78256_a(timeString);
        int textHeight = TimeOfDayOverlay.mc.field_71466_p.field_78288_b;
        int x = RTConfig.timeOfDay.x;
        int y = RTConfig.timeOfDay.y;
        ScaledResolution scaled = new ScaledResolution(mc);
        int displayWidth = scaled.func_78326_a();
        int displayHeight = scaled.func_78328_b();
        int actualX = RTConfig.timeOfDay.alignment.getX(x, displayWidth, textWidth);
        int actualY = RTConfig.timeOfDay.alignment.getY(y, displayHeight, textHeight);
        TimeOfDayOverlay.mc.field_71466_p.func_175063_a(timeString, (float)actualX, (float)actualY, 0xFFFFFF);
    }

    public static boolean shouldHide() {
        if (!RTConfig.timeOfDay.enabled || shouldHide || TimeOfDayOverlay.mc.field_71441_e == null || !Minecraft.func_71382_s()) {
            return true;
        }
        if (TimeOfDayOverlay.mc.field_71462_r != null && RTConfig.timeOfDay.disableInGUIs) {
            return true;
        }
        if (RTConfig.timeOfDay.disableIfNoDaylightCycle && !TimeOfDayOverlay.mc.field_71441_e.func_82736_K().func_82766_b("doDaylightCycle")) {
            return true;
        }
        return RTConfig.timeOfDay.disableInAdventureMode && TimeOfDayOverlay.mc.field_71441_e.func_72912_H().func_76077_q() == GameType.ADVENTURE;
    }

    public static boolean isEnabledForCurrentWorld() {
        Map<String, Boolean> worlds = RTConfig.Data.get().timeOfDayOverlay;
        File saveDirectory = DimensionManager.getCurrentSaveRootDirectory();
        if (saveDirectory != null) {
            String name = saveDirectory.getName();
            if (!worlds.containsKey(name)) {
                worlds.put(name, RTConfig.timeOfDay.enabledByDefault);
                RTConfig.Data.save();
            }
            return worlds.get(name);
        }
        ServerData serverData = mc.func_147104_D();
        if (serverData == null) {
            return false;
        }
        String ip = serverData.field_78845_b;
        if (ip == null) {
            return false;
        }
        if (!RTConfig.Data.get().timeOfDayOverlay.containsKey(ip)) {
            worlds.put(ip, RTConfig.timeOfDay.enabledByDefault);
            RTConfig.Data.save();
        }
        return worlds.get(ip);
    }

    public static void toggle() {
        String name;
        if (TimeOfDayOverlay.shouldHide()) {
            return;
        }
        File saveDirectory = DimensionManager.getCurrentSaveRootDirectory();
        Map<String, Boolean> worlds = RTConfig.Data.get().timeOfDayOverlay;
        String string = name = saveDirectory != null ? saveDirectory.getName() : TimeOfDayOverlay.mc.func_147104_D().field_78845_b;
        if (!worlds.containsKey(name)) {
            worlds.put(name, !RTConfig.timeOfDay.enabledByDefault);
        } else {
            worlds.put(name, worlds.get(name) == false);
        }
        RTConfig.Data.save();
    }
}

