/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.common.RespawnHandler;
import com.therandomlabs.randomtweaks.common.TrampleHandler;
import com.therandomlabs.randomtweaks.util.Alignment;
import com.therandomlabs.randomtweaks.util.RTUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="randomtweaks")
@Config(modid="randomtweaks", name="randomtweaks/randomtweaks", category="")
public final class RTConfig {
    @Config.Ignore
    public static final String NAME = "randomtweaks/randomtweaks";
    @Config.LangKey(value="randomtweaks.config.animals")
    @Config.Comment(value={"Options related to animals (including villagers)."})
    public static final Animals animals = new Animals();
    @Config.LangKey(value="randomtweaks.config.boneMeal")
    @Config.Comment(value={"Options related to bone meal."})
    public static final BoneMeal boneMeal = new BoneMeal();
    @Config.LangKey(value="randomtweaks.config.client")
    @Config.Comment(value={"Options related to features that only work client-side."})
    public static final Client client = new Client();
    @Config.LangKey(value="randomtweaks.config.commands")
    @Config.Comment(value={"Options related to commands."})
    public static final Commands commands = new Commands();
    @Config.LangKey(value="randomtweaks.config.hunger")
    @Config.Comment(value={"Options related to hunger behavior."})
    public static final Hunger hunger = new Hunger();
    @Config.LangKey(value="randomtweaks.config.misc")
    @Config.Comment(value={"Options that don't fit into any other categories."})
    public static final Misc misc = new Misc();
    @Config.LangKey(value="randomtweaks.config.playerHeadDrops")
    @Config.Comment(value={"Options related to player head drops."})
    public static final PlayerHeadDrops playerHeadDrops = new PlayerHeadDrops();
    @Config.LangKey(value="randomtweaks.config.world")
    @Config.Comment(value={"Options related to world generation."})
    public static final World world = new World();
    @Config.Ignore
    public static final AutoThirdPerson autoThirdPerson = RTConfig.client.autoThirdPerson;
    @Config.Ignore
    public static final CreativeTabs creativeTabs = RTConfig.client.creativeTabs;
    @Config.Ignore
    public static final Ding ding = RTConfig.client.ding;
    @Config.Ignore
    public static final Keybinds keybinds = RTConfig.client.keybinds;
    @Config.Ignore
    public static final RandomizedAges randomizedAges = RTConfig.animals.randomizedAges;
    @Config.Ignore
    public static final SheepColorWeights sheepColorWeights = RTConfig.animals.sheepColorWeights;
    @Config.Ignore
    public static final Squids squids = RTConfig.animals.squids;
    @Config.Ignore
    public static final TimeOfDay timeOfDay = RTConfig.client.timeOfDay;
    @Config.Ignore
    public static final OceanFloor oceanFloor = RTConfig.world.oceanFloor;
    @Config.Ignore
    public static final VoidWorld voidWorld = RTConfig.world.voidWorld;
    @Config.Ignore
    public static final VoidIslandsWorld voidIslandsWorld = RTConfig.world.voidIslandsWorld;
    private static final IForgeRegistry<Biome> BIOME_REGISTRY = GameRegistry.findRegistry(Biome.class);
    private static final IForgeRegistry<Block> BLOCK_REGISTRY = GameRegistry.findRegistry(Block.class);
    private static final IForgeRegistry<SoundEvent> SOUND_EVENT_REGISTRY = GameRegistry.findRegistry(SoundEvent.class);
    private static final Method GET_CONFIGURATION = RTUtils.findMethod(ConfigManager.class, "getConfiguration", "getConfiguration", String.class, String.class);
    private static final Method SYNC = RTUtils.findMethod(ConfigManager.class, "sync", "sync", Configuration.class, Class.class, String.class, String.class, Boolean.TYPE, Object.class);
    private static final Map<Property, String> comments = new HashMap<Property, String>();
    private static boolean firstReload = true;

    public static Path getConfig(String name) {
        Path path = Paths.get("config", "randomtweaks", name);
        Path parent = path.getParent();
        try {
            if (parent != null) {
                if (Files.isRegularFile(parent, new LinkOption[0])) {
                    Files.delete(parent);
                }
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            RandomTweaks.LOGGER.error("Failed to create parent: " + path, (Throwable)ex);
        }
        return path;
    }

    public static Path getJson(String name) {
        return RTConfig.getConfig(name + ".json");
    }

    public static String readFile(Path path) {
        try {
            return StringUtils.join(Files.readAllLines(path), (String)System.lineSeparator());
        }
        catch (IOException ex) {
            RandomTweaks.LOGGER.error("Failed to read file: " + path, (Throwable)ex);
            return "{}";
        }
    }

    public static JsonObject readJson(Path path) {
        return new JsonParser().parse(RTConfig.readFile(path)).getAsJsonObject();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("randomtweaks")) {
            RTConfig.reload();
        }
    }

    public static void reload() {
        try {
            ConfigCategory category;
            Configuration config = (Configuration)GET_CONFIGURATION.invoke(null, "randomtweaks", NAME);
            if (!firstReload) {
                SYNC.invoke(null, config, RTConfig.class, "randomtweaks", "", false, null);
            }
            RTConfig.onReload();
            firstReload = false;
            for (String name : config.getCategoryNames()) {
                category = config.getCategory(name);
                category.getValues().forEach((key, property) -> {
                    String comment = property.getComment();
                    if (comment == null || comment.isEmpty()) {
                        category.remove(key);
                        return;
                    }
                    String newComment = comments.get(property);
                    if (newComment == null) {
                        newComment = comment + "\nDefault: " + property.getDefault();
                        comments.put((Property)property, newComment);
                    }
                    property.setComment(newComment);
                });
                if (!category.getValues().isEmpty() && category.getComment() != null) continue;
                config.removeCategory(category);
            }
            config.save();
            SYNC.invoke(null, config, RTConfig.class, "randomtweaks", "", false, null);
            for (String name : config.getCategoryNames()) {
                category = config.getCategory(name);
                category.getValues().forEach((key, property) -> {
                    String[] comment = property.getComment().split("\n");
                    StringBuilder prunedComment = new StringBuilder();
                    for (String line : comment) {
                        if (line.startsWith("Default:") || line.startsWith("Min:")) break;
                        prunedComment.append(line).append("\n");
                    }
                    String commentString = prunedComment.toString();
                    property.setComment(commentString.substring(0, commentString.length() - 1));
                });
            }
        }
        catch (Exception ex) {
            RandomTweaks.LOGGER.error("Error while modifying config", (Throwable)ex);
        }
        Data.data = null;
    }

    public static void reloadFromDisk() {
        try {
            Configuration config = (Configuration)GET_CONFIGURATION.invoke(null, "randomtweaks", NAME);
            Configuration tempConfig = new Configuration(config.getConfigFile());
            tempConfig.load();
            for (String name : tempConfig.getCategoryNames()) {
                Map properties = tempConfig.getCategory(name).getValues();
                for (Map.Entry entry : properties.entrySet()) {
                    config.getCategory(name).get((String)entry.getKey()).set(((Property)entry.getValue()).getString());
                }
            }
            RTConfig.reload();
            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent("randomtweaks", null, true, false));
        }
        catch (Exception ex) {
            RandomTweaks.LOGGER.error("Error while modifying config", (Throwable)ex);
        }
    }

    private static void onReload() {
        if (!firstReload) {
            RTConfig.ding.reload();
        }
        if (RTConfig.misc.betterButtonNames) {
            Blocks.field_150430_aB.func_149663_c("buttonStone");
            Blocks.field_150471_bO.func_149663_c("buttonWood");
        } else {
            Blocks.field_150430_aB.func_149663_c("button");
            Blocks.field_150471_bO.func_149663_c("button");
        }
        if (RTConfig.misc.localizePortalNames && !RandomTweaks.RANDOMPORTALS_LOADED) {
            Blocks.field_150427_aO.func_149663_c("netherPortal");
            Blocks.field_150384_bq.func_149663_c("endPortal");
            Blocks.field_185775_db.func_149663_c("endGateway");
        } else {
            Blocks.field_150427_aO.func_149663_c(null);
            Blocks.field_150384_bq.func_149663_c(null);
            Blocks.field_185775_db.func_149663_c(null);
        }
        RTConfig.randomizedAges.reload();
        if (RTConfig.sheepColorWeights.enabled) {
            RTConfig.sheepColorWeights.reload();
        }
        if (!firstReload) {
            RTConfig.world.reload();
        }
    }

    public static final class World {
        @Config.LangKey(value="randomtweaks.config.oceanFloor")
        @Config.Comment(value={"Options related to ocean floor generation."})
        public final OceanFloor oceanFloor = new OceanFloor();
        @Config.LangKey(value="randomtweaks.config.voidWorld")
        @Config.Comment(value={"Options regarding Void worlds."})
        public final VoidWorld voidWorld = new VoidWorld();
        @Config.LangKey(value="randomtweaks.config.voidIslandsWorld")
        @Config.Comment(value={"Options regarding Void Islands worlds."})
        public final VoidIslandsWorld voidIslandsWorld = new VoidIslandsWorld();
        @Config.LangKey(value="randomtweaks.config.world.realisticWorldType")
        @Config.Comment(value={"Enables the Realistic world type", "Name: REALISTIC"})
        public boolean realisticWorldType = true;

        private Biome getBiome(String name) {
            Biome biome = (Biome)BIOME_REGISTRY.getValue(new ResourceLocation(name));
            return biome == null ? Biomes.field_76772_c : biome;
        }

        private Map<String, Biome> getBiomes(String[] names) {
            HashMap<String, Biome> biomes = new HashMap<String, Biome>(names.length);
            for (String name : names) {
                Biome biome = (Biome)BIOME_REGISTRY.getValue(new ResourceLocation(name));
                if (biome == null) continue;
                biomes.put(biome.getRegistryName().toString(), biome);
            }
            return biomes;
        }

        private void reload() {
            this.voidWorld.reload();
            this.voidIslandsWorld.reload();
        }
    }

    public static final class VoidIslandsWorld {
        @Config.RangeInt(min=1)
        @Config.LangKey(value="randomtweaks.config.voidIslandsWorld.chunkRarity")
        @Config.Comment(value={"The rarity of non-empty chunks in a Void Islands world.", "If this is set to n, there is a 1 in n chance of a chunk being non-empty.", "If this is set to 1, only the spawn chunk is generated."})
        public int chunkRarity = 10;
        @Config.LangKey(value="randomtweaks.config.voidIslandsWorld.enabled")
        @Config.Comment(value={"Enables the Void Islands world type", "Name: VOIDISLANDS"})
        public boolean enabled = true;
        @Config.LangKey(value="randomtweaks.config.voidIslandsWorld.voidChunkBiome")
        @Config.Comment(value={"The void chunk biome.", "Leave this empty for randomized biomes."})
        public String voidChunkBiome = "";
        @Config.LangKey(value="randomtweaks.config.voidIslandsWorld.voidChunkRandomBiomeBlacklist")
        @Config.Comment(value={"The biomes that cannot be randomly generated in void chunks in Void Islands worlds."})
        public String[] voidChunkRandomBiomeBlacklist = new String[0];
        @Config.Ignore
        public Biome biome;
        @Config.Ignore
        public Biome[] biomeBlacklist;

        private void reload() {
            if (this.voidChunkBiome.isEmpty()) {
                this.biome = null;
            } else {
                this.biome = world.getBiome(this.voidChunkBiome);
                this.voidChunkBiome = this.biome.getRegistryName().toString();
            }
            Map blacklist = world.getBiomes(this.voidChunkRandomBiomeBlacklist);
            this.voidChunkRandomBiomeBlacklist = blacklist.keySet().toArray(new String[0]);
            this.biomeBlacklist = blacklist.values().toArray(new Biome[0]);
        }
    }

    public static final class VoidWorld {
        @Config.LangKey(value="randomtweaks.config.voidWorld.biome")
        @Config.Comment(value={"The Void world biome.", "Leave this empty for randomized biomes."})
        public String biome = "minecraft:plains";
        @Config.LangKey(value="randomtweaks.config.voidWorld.enabled")
        @Config.Comment(value={"Enables the Void world type", "Name: VOID"})
        public boolean enabled = true;
        @Config.LangKey(value="randomtweaks.config.voidWorld.mobSpawning")
        @Config.Comment(value={"Whether mobs spawn in Void worlds."})
        public boolean mobSpawning = true;
        @Config.LangKey(value="randomtweaks.config.voidWorld.randomBiomeBlacklist")
        @Config.Comment(value={"The biomes that cannot be randomly generated in Void worlds."})
        public String[] randomBiomeBlacklist = new String[0];
        @Config.LangKey(value="randomtweaks.config.voidWorld.spawnBlock")
        @Config.Comment(value={"The block placed at the spawn point of a Void world."})
        public String spawnBlock = "minecraft:glass";
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.voidWorld.spawnBlockMeta")
        @Config.Comment(value={"The meta value of the block placed at the spawn point of a Void world."})
        public int spawnBlockMeta = 0;
        @Config.RangeInt(min=1, max=255)
        @Config.LangKey(value="randomtweaks.config.voidWorld.ySpawn")
        @Config.Comment(value={"The Y coordinate of the default spawn point in a Void world."})
        public int ySpawn = 17;
        @Config.Ignore
        public Biome actualBiome;
        @Config.Ignore
        public Biome[] biomeBlacklist;
        @Config.Ignore
        public Block block;
        @Config.Ignore
        public IBlockState blockState;

        private void reload() {
            if (this.biome.isEmpty()) {
                this.actualBiome = null;
            } else {
                this.actualBiome = world.getBiome(this.biome);
                this.biome = this.actualBiome.getRegistryName().toString();
            }
            Map blacklist = world.getBiomes(this.randomBiomeBlacklist);
            this.randomBiomeBlacklist = blacklist.keySet().toArray(new String[0]);
            this.biomeBlacklist = blacklist.values().toArray(new Biome[0]);
            this.block = (Block)BLOCK_REGISTRY.getValue(new ResourceLocation(this.spawnBlock));
            if (this.block == null) {
                this.block = Blocks.field_150359_w;
                this.spawnBlock = "minecraft:glass";
                this.blockState = this.block.func_176223_P();
            } else {
                this.spawnBlock = this.block.getRegistryName().toString();
                this.blockState = this.block.func_176203_a(this.spawnBlockMeta);
            }
        }
    }

    public static final class TimeOfDay {
        @Config.LangKey(value="randomtweaks.config.timeOfDay.alignment")
        @Config.Comment(value={"The alignment."})
        public Alignment alignment = Alignment.TOPLEFT;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.disableIfNoDaylightCycle")
        @Config.Comment(value={"Disables the overlay if doDaylightCycle is false."})
        public boolean disableIfNoDaylightCycle = !RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.disableInAdventureMode")
        @Config.Comment(value={"Disables the overlay in Adventure Mode."})
        public boolean disableInAdventureMode = true;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.disableInGUIs")
        @Config.Comment(value={"Disables the overlay in GUIs."})
        public boolean disableInGUIs = true;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.enabled")
        @Config.Comment(value={"Enables the overlay."})
        public boolean enabled = true;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.enabledByDefault")
        @Config.Comment(value={"Enables the overlay by default."})
        public boolean enabledByDefault = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.lightOrDark")
        @Config.Comment(value={"Whether the overlay should say \"Light\" or \"Dark\" instead of \"Day\" or \"Night\"."})
        public boolean lightOrDark;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.twentyFourHourTime")
        @Config.Comment(value={"Enables 24-hour time."})
        public boolean twentyFourHourTime = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.x")
        @Config.Comment(value={"The X offset."})
        public int x = 0;
        @Config.LangKey(value="randomtweaks.config.timeOfDay.y")
        @Config.Comment(value={"The Y offset."})
        public int y = 0;
    }

    public static final class Squids {
        @Config.RangeInt(min=-1)
        @Config.LangKey(value="randomtweaks.config.squids.chunkLimit")
        @Config.Comment(value={"The number of squids allowed in one chunk.", "Set this to 0 to disable squid spawning.", "Set this to -1 to disable this limit."})
        public int chunkLimit = 12;
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.squids.maxPackSize")
        @Config.Comment(value={"The maximum number of squids that can be spawned in a pack.", "Set this to 0 to use vanilla behavior."})
        public int maxPackSize = 2;
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.squids.spawnRadiusLimit")
        @Config.Comment(value={"Disables squid spawning when a player is not within this radius.", "Set this to 0 to disable this limit."})
        public int spawnRadiusLimit = 128;
    }

    public static final class SheepColorWeights {
        @Config.Ignore
        public final Map<EnumDyeColor, Double> weights = new EnumMap<EnumDyeColor, Double>(EnumDyeColor.class);
        @Config.Ignore
        public double totalWeight;
        @Config.LangKey(value="randomtweaks.config.sheepColorWeights.enabled")
        @Config.Comment(value={"Enables colored sheep spawning."})
        public boolean enabled = true;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.white")
        @Config.Comment(value={"The weight for the color white."})
        public double white = 70.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.orange")
        @Config.Comment(value={"The weight for the color orange."})
        public double orange = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.magenta")
        @Config.Comment(value={"The weight for the color magenta."})
        public double magenta = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.lightBlue")
        @Config.Comment(value={"The weight for the color light blue."})
        public double lightBlue = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.yellow")
        @Config.Comment(value={"The weight for the color yellow."})
        public double yellow = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.lime")
        @Config.Comment(value={"The weight for the color lime."})
        public double lime = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.pink")
        @Config.Comment(value={"The weight for the color pink."})
        public double pink = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.gray")
        @Config.Comment(value={"The weight for the color gray."})
        public double gray = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.silver")
        @Config.Comment(value={"The weight for the color silver."})
        public double silver = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.cyan")
        @Config.Comment(value={"The weight for the color cyan."})
        public double cyan = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.purple")
        @Config.Comment(value={"The weight for the color purple."})
        public double purple = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.blue")
        @Config.Comment(value={"The weight for the color blue."})
        public double blue = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.brown")
        @Config.Comment(value={"The weight for the color brown."})
        public double brown = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.green")
        @Config.Comment(value={"The weight for the color green."})
        public double green = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.red")
        @Config.Comment(value={"The weight for the color red."})
        public double red = 2.0;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="item.fireworksCharge.black")
        @Config.Comment(value={"The weight for the color black."})
        public double black = 2.0;

        private void reload() {
            this.totalWeight = 0.0;
            this.putWeight(EnumDyeColor.WHITE, this.white);
            this.putWeight(EnumDyeColor.ORANGE, this.orange);
            this.putWeight(EnumDyeColor.MAGENTA, this.magenta);
            this.putWeight(EnumDyeColor.LIGHT_BLUE, this.lightBlue);
            this.putWeight(EnumDyeColor.YELLOW, this.yellow);
            this.putWeight(EnumDyeColor.LIME, this.lime);
            this.putWeight(EnumDyeColor.PINK, this.pink);
            this.putWeight(EnumDyeColor.GRAY, this.gray);
            this.putWeight(EnumDyeColor.SILVER, this.silver);
            this.putWeight(EnumDyeColor.CYAN, this.cyan);
            this.putWeight(EnumDyeColor.PURPLE, this.purple);
            this.putWeight(EnumDyeColor.BLUE, this.blue);
            this.putWeight(EnumDyeColor.BROWN, this.brown);
            this.putWeight(EnumDyeColor.GREEN, this.green);
            this.putWeight(EnumDyeColor.RED, this.red);
            this.putWeight(EnumDyeColor.BLACK, this.black);
        }

        private void putWeight(EnumDyeColor color, double weight) {
            this.totalWeight += weight;
            this.weights.put(color, weight);
        }
    }

    public static final class RandomizedAges {
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.randomizedAges.chance")
        @Config.Comment(value={"The chance that an animal's age is randomized."})
        public double chance = 0.1;
        @Config.LangKey(value="randomtweaks.config.randomizedAges.maximumAge")
        @Config.Comment(value={"The maximum age in ticks."})
        public int maximumAge = -6000;
        @Config.LangKey(value="randomtweaks.config.randomizedAges.minimumAge")
        @Config.Comment(value={"The minimum age in ticks."})
        public int minimumAge = -24000;

        private void reload() {
            if (this.maximumAge < this.minimumAge) {
                this.maximumAge = this.minimumAge;
            }
        }
    }

    public static final class PlayerHeadDrops {
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.playerHeadDrops.chanceWhenKilledByChargedCreeper")
        @Config.Comment(value={"The player head drop chance when a player is killed by a charged creeper."})
        public double chanceWhenKilledByChargedCreeper = 1.0;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.playerHeadDrops.chanceWhenKilledByPlayer")
        @Config.Comment(value={"The player head drop chance when a player is killed by another player."})
        public double chanceWhenKilledByPlayer = 1.0;
        @Config.LangKey(value="randomtweaks.config.playerHeadDrops.enabled")
        @Config.Comment(value={"Whether players should drop their heads when they die."})
        public boolean enabled = true;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.playerHeadDrops.normalChance")
        @Config.Comment(value={"The normal player head drop chance."})
        public double normalChance = 1.0;
    }

    public static final class OceanFloor {
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.clayChance")
        @Config.Comment(value={"The clay spawn chance."})
        public int clayChance = 65;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.clayVeinSize")
        @Config.Comment(value={"The amount of clay in a vein."})
        public int clayVeinSize = 32;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.dirtChance")
        @Config.Comment(value={"The dirt spawn chance."})
        public int dirtChance = 30;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.dirtVeinSize")
        @Config.Comment(value={"The amount of dirt in a vein."})
        public int dirtVeinSize = 18;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randomtweaks.config.oceanFloor.enabled")
        @Config.Comment(value={"Enables the ocean floor worldgen."})
        public boolean enabled = true;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.maxY")
        @Config.Comment(value={"The maximum Y coordinate."})
        public int maxY = 128;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.minY")
        @Config.Comment(value={"The minimum Y coordinate."})
        public int minY = 20;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.sandChance")
        @Config.Comment(value={"The sand spawn chance."})
        public int sandChance = 45;
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.oceanFloor.sandVeinSize")
        @Config.Comment(value={"The amount of sand in a vein."})
        public int sandVeinSize = 22;
    }

    public static final class Misc {
        @Config.LangKey(value="randomtweaks.config.misc.allowSleepNearMobsWithCustomNames")
        @Config.Comment(value={"Allows players to sleep near mobs with custom names."})
        public boolean allowSleepNearMobsWithCustomNames = true;
        @Config.LangKey(value="randomtweaks.config.misc.disableAttacksDuringAttackCooldown")
        @Config.Comment(value={"Whether attacks should be disabled during the attack cooldown."})
        public boolean disableAttacksDuringAttackCooldown = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.misc.disableBedProximityRequirement")
        @Config.Comment(value={"Disables the bed proximity requirement."})
        public boolean disableBedProximityRequirement = true;
        @Config.RangeDouble(min=0.0, max=1024.0)
        @Config.LangKey(value="randomtweaks.config.misc.attackSpeed")
        @Config.Comment(value={"The base attack speed for players.", "Set this to 16.0 or higher to remove the attack cooldown."})
        public double attackSpeed = RandomTweaks.IS_DEOBFUSCATED ? 24.0 : 4.0;
        @Config.LangKey(value="randomtweaks.config.misc.betterButtonNames")
        @Config.Comment(value={"Changes the names of the stone and wooden buttons so that they describe their type."})
        public boolean betterButtonNames = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.misc.deathPunishmentMode")
        @Config.Comment(value={"When death punishments should be enabled.", "When death punishments are enabled, players lose all XP and 3 hunger points upon dying.", "This is always disabled in creative mode.", "This has no effect on hunger if hunger resetting is enabled by hunger.respawnResetBehavior."})
        public RespawnHandler.DeathPunishmentMode deathPunishmentMode = RespawnHandler.DeathPunishmentMode.ENABLED_IF_KEEP_INVENTORY;
        @Config.LangKey(value="randomtweaks.config.misc.disableCumulativeAnvilCosts")
        @Config.Comment(value={"Disables cumulative anvil costs."})
        public boolean disableCumulativeAnvilCosts = true;
        @Config.LangKey(value="randomtweaks.config.misc.disableNetherPortalCreationGameRuleName")
        @Config.Comment(value={"The name of the gamerule that disables nether portal creation.", "Set this to an empty string to disable this gamerule."})
        public String disableNetherPortalCreationGameRuleName = "disableNetherPortalCreation";
        @Config.LangKey(value="randomtweaks.config.misc.entitiesDropNameTags")
        @Config.Comment(value={"Whether living entities should drop name tags if they have a custom name."})
        public boolean entitiesDropNameTags = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.misc.fallDamageMultiplierGameRuleName")
        @Config.Comment(value={"The name of the gamerule that controls the fall damage multiplier.", "Set this to an empty string to disable this gamerule."})
        public String fallDamageMultiplierGameRuleName = "fallDamageMultiplier";
        @Config.LangKey(value="randomtweaks.config.misc.farmlandTrampleBehavior")
        @Config.Comment(value={"The farmland trample behavior."})
        public TrampleHandler.Behavior farmlandTrampleBehavior = TrampleHandler.Behavior.DONT_TRAMPLE_IF_FEATHER_FALLING;
        @Config.LangKey(value="randomtweaks.config.misc.localizePortalNames")
        @Config.Comment(value={"Whether to localize the Nether Portal, End Portal and End Gateway names."})
        public boolean localizePortalNames = true;
        @Config.LangKey(value="randomtweaks.config.misc.moreRomanNumerals")
        @Config.Comment(value={"Generates Roman numerals from -32768 to 32767 as they are needed."})
        public boolean moreRomanNumerals = true;
        @Config.LangKey(value="randomtweaks.config.misc.pickUpSkeletonArrows")
        @Config.Comment(value={"Allows skeleton arrows to be picked up."})
        public boolean pickUpSkeletonArrows = RandomTweaks.IS_DEOBFUSCATED;
    }

    public static final class Keybinds {
        @Config.LangKey(value="randomtweaks.config.keybinds.fovChangesEnabledByDefault")
        @Config.Comment(value={"Whether FoV changes should be enabled by default."})
        public boolean fovChangesEnabledByDefault = true;
        @Config.LangKey(value="randomtweaks.config.keybinds.fovChangesStatusMessage")
        @Config.Comment(value={"Whether a status message should be displayed when FoV changes are toggled."})
        public boolean fovChangesStatusMessage = true;
        @Config.LangKey(value="randomtweaks.config.keybinds.reloadSoundSystem")
        @Config.Comment(value={"Enables the Reload Sound System keybind."})
        public boolean reloadSoundSystem = true;
        @Config.LangKey(value="randomtweaks.config.keybinds.toggleFoVChanges")
        @Config.Comment(value={"Enables the Toggle FoV Changes keybind."})
        public boolean toggleFoVChanges = true;
        @Config.LangKey(value="randomtweaks.config.keybinds.toggleTimeOfDayOverlay")
        @Config.Comment(value={"Enables the Toggle Time of Day Overlay keybind."})
        public boolean toggleTimeOfDayOverlay = true;
    }

    public static final class Hunger {
        @Config.LangKey(value="randomtweaks.config.hunger.carryExcessHungerToSaturation")
        @Config.Comment(value={"Carries any excess hunger level gained by eating over to the saturation."})
        public boolean carryExcessHungerToSaturation = RandomTweaks.IS_DEOBFUSCATED;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randomtweaks.config.hunger.enabled")
        @Config.Comment(value={"Enables hunger tweaks."})
        public boolean enabled = true;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="randomtweaks.config.hunger.exhaustionMultiplier")
        @Config.Comment(value={"The hunger exhaustion multiplier."})
        public double exhaustionMultiplier = RandomTweaks.IS_DEOBFUSCATED ? 0.0 : 1.0;
        @Config.RangeInt(min=1)
        @Config.LangKey(value="randomtweaks.config.hunger.maximumHungerLevel")
        @Config.Comment(value={"The maximum hunger level."})
        public int maximumHungerLevel = RandomTweaks.IS_DEOBFUSCATED ? 22 : 20;
        @Config.RangeInt(min=0)
        @Config.LangKey(value="randomtweaks.config.hunger.minimumRespawnHungerLevel")
        @Config.Comment(value={"The minimum hunger level on respawn."})
        public int minimumRespawnHungerLevel = 3;
        @Config.LangKey(value="randomtweaks.config.hunger.respawnResetBehavior")
        @Config.Comment(value={"What happens to a player's hunger when they respawn.", "This has no effect in creative mode."})
        public RespawnHandler.HungerResetBehavior respawnResetBehavior = RespawnHandler.HungerResetBehavior.RESET_UNLESS_KEEP_INVENTORY;
        @Config.RangeDouble(min=0.0)
        @Config.LangKey(value="randomtweaks.config.hunger.saturationLimit")
        @Config.Comment(value={"The value added to the player's food level to calculate the maximum saturation level."})
        public double saturationLimit = RandomTweaks.IS_DEOBFUSCATED ? 100.0 : 0.0;
    }

    public static final class Ding {
        @Config.LangKey(value="randomtweaks.config.ding.ignoreDsurroundMuteWhenBackground")
        @Config.Comment(value={"Whether to ignore Dynamic Surroundings' \"Mute when Background\" feature."})
        public boolean ignoreDsurroundMuteWhenBackground = true;
        @Config.RangeDouble(min=0.5, max=2.0)
        @Config.LangKey(value="randomtweaks.config.ding.startupSoundPitch")
        @Config.Comment(value={"The pitch of the sound to play when Minecraft starts."})
        public double startupSoundPitch = 1.0;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.ding.startupSoundVolume")
        @Config.Comment(value={"The volume of the sound to play when Minecraft starts."})
        public double startupSoundVolume = 0.25;
        @Config.LangKey(value="randomtweaks.config.ding.startupSounds")
        @Config.Comment(value={"The registry names of the sounds to play when Minecraft starts."})
        public String[] startupSounds = new String[]{"minecraft:entity.experience_orb.pickup"};
        @Config.RangeDouble(min=0.5, max=2.0)
        @Config.LangKey(value="randomtweaks.config.ding.worldLoadSoundPitch")
        @Config.Comment(value={"The pitch of the sound to play when a world loads."})
        public double worldLoadSoundPitch = 1.0;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.ding.worldLoadSoundVolume")
        @Config.Comment(value={"The volume of the sound to play when a world loads."})
        public double worldLoadSoundVolume = 0.25;
        @Config.LangKey(value="randomtweaks.config.ding.worldLoadSounds")
        @Config.Comment(value={"The registry names of the sounds to play when a world loads."})
        public String[] worldLoadSounds = new String[]{"minecraft:entity.experience_orb.pickup"};
        @Config.Ignore
        public SoundEvent[] startupSoundEvents;
        @Config.Ignore
        public SoundEvent[] worldLoadSoundEvents;

        private void reload() {
            Map<String, SoundEvent> sounds = this.getSoundEvents(this.startupSounds);
            this.startupSounds = sounds.keySet().toArray(new String[0]);
            this.startupSoundEvents = sounds.values().toArray(new SoundEvent[0]);
            sounds = this.getSoundEvents(this.worldLoadSounds);
            this.worldLoadSounds = sounds.keySet().toArray(new String[0]);
            this.worldLoadSoundEvents = sounds.values().toArray(new SoundEvent[0]);
        }

        private Map<String, SoundEvent> getSoundEvents(String[] names) {
            HashMap<String, SoundEvent> soundEvents = new HashMap<String, SoundEvent>(names.length);
            for (String name : names) {
                SoundEvent soundEvent = (SoundEvent)SOUND_EVENT_REGISTRY.getValue(new ResourceLocation(name));
                if (soundEvent == null) continue;
                soundEvents.put(soundEvent.getRegistryName().toString(), soundEvent);
            }
            return soundEvents;
        }
    }

    public static final class CreativeTabs {
        @Config.LangKey(value="randomtweaks.config.creativeTabs.moveBucketCreativeTab")
        @Config.Comment(value={"Moves the bucket to the Tools creative tab."})
        public boolean moveBucketCreativeTab = true;
        @Config.LangKey(value="randomtweaks.config.creativeTabs.noAISpawnEggs")
        @Config.Comment(value={"Adds spawn eggs to the Spawn Eggs creative tab that spawn entities without AIs."})
        public boolean noAISpawnEggs = true;
        @Config.LangKey(value="randomtweaks.config.creativeTabs.setCommandBlockCreativeTab")
        @Config.Comment(value={"Adds the command blocks to the Redstone creative tab."})
        public boolean setCommandBlockCreativeTab = true;
        @Config.LangKey(value="randomtweaks.config.creativeTabs.setDragonEggCreativeTab")
        @Config.Comment(value={"Adds the dragon egg to the Decorations creative tab."})
        public boolean setDragonEggCreativeTab = true;
        @Config.LangKey(value="randomtweaks.config.creativeTabs.spawnEggsCreativeTab")
        @Config.Comment(value={"Moves spawn eggs to their own creative tab."})
        public boolean spawnEggsCreativeTab = true;
    }

    public static final class Commands {
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.commands.deletegamerule")
        @Config.Comment(value={"Enables the /deletegamerule command."})
        public boolean deletegamerule = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randomtweaks.config.commands.disconnect")
        @Config.Comment(value={"Enables the client-sided /disconnect command, which leaves the current world."})
        public boolean disconnect = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.commands.giveTweaks")
        @Config.Comment(value={"Allows /give to accept integer IDs, amounts higher than 64 and ore dictionary names prefixed by \"ore:\"."})
        public boolean giveTweaks = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.commands.helpTweaks")
        @Config.Comment(value={"Changes the /help command to make sure that sorting commands doesn't cause an error."})
        public boolean helpTweaks = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.commands.hunger")
        @Config.Comment(value={"Enables the /hunger command, which sets a player's hunger level."})
        public boolean hunger = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.commands.rtreload")
        @Config.Comment(value={"Enables the /rtreload command."})
        public boolean rtreload = true;
        @Config.RequiresMcRestart
        @Config.LangKey(value="randomtweaks.config.commands.rtreloadclient")
        @Config.Comment(value={"Enables the client-sided /rtreloadclient command."})
        public boolean rtreloadclient = true;
    }

    public static final class Client {
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson")
        @Config.Comment(value={"Options related to the auto-third person feature."})
        public final AutoThirdPerson autoThirdPerson = new AutoThirdPerson();
        @Config.LangKey(value="randomtweaks.config.creativeTabs")
        @Config.Comment(value={"Options related to creative tabs."})
        public final CreativeTabs creativeTabs = new CreativeTabs();
        @Config.LangKey(value="randomtweaks.config.ding")
        @Config.Comment(value={"Options related to the 'ding' feature."})
        public final Ding ding = new Ding();
        @Config.LangKey(value="randomtweaks.config.keybinds")
        @Config.Comment(value={"Options related to keybinds."})
        public final Keybinds keybinds = new Keybinds();
        @Config.LangKey(value="randomtweaks.config.timeOfDay")
        @Config.Comment(value={"Options related to the time of day overlay."})
        public final TimeOfDay timeOfDay = new TimeOfDay();
        @Config.LangKey(value="randomtweaks.config.client.clearWater")
        @Config.Comment(value={"Removes underwater fog."})
        public boolean clearWater = true;
        @Config.RequiresWorldRestart
        @Config.LangKey(value="randomtweaks.config.client.contributorCapes")
        @Config.Comment(value={"Whether contributor capes should be enabled."})
        public boolean contributorCapes = true;
        @Config.LangKey(value="randomtweaks.config.client.disableEnderDragonDeathSound")
        @Config.Comment(value={"Disables the ender dragon death sound."})
        public boolean disableEnderDragonDeathSound;
        @Config.LangKey(value="randomtweaks.config.client.disablePotionIcons")
        @Config.Comment(value={"Disables the potion icons at the top right."})
        public boolean disablePotionIcons = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.client.disablePotionShift")
        @Config.Comment(value={"Stops potion effects from moving GUIs to the right."})
        public boolean disablePotionShift = true;
        @Config.LangKey(value="randomtweaks.config.client.disableWitherSpawnSound")
        @Config.Comment(value={"Disables the wither spawn sound."})
        public boolean disableWitherSpawnSound;
        @Config.LangKey(value="randomtweaks.config.client.startOnMultiplayerScreen")
        @Config.Comment(value={"Whether to start the game on the Multiplayer screen."})
        public boolean startOnMultiplayerScreen = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.client.stepup")
        @Config.Comment(value={"Whether to enable stepup."})
        public boolean stepup = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.client.stepupEnabledByDefault")
        @Config.Comment(value={"Whether stepup is enabled by default."})
        public boolean stepupEnabledByDefault = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.client.storeDataInLocal")
        @Config.Comment(value={"Whether the toggle states for the time of day overlay, stepup and FoV changes should be stored in local/client instead of config/randomtweaks."})
        public boolean storeDataInLocal = true;
    }

    public static final class BoneMeal {
        @Config.RangeInt(min=0, max=16)
        @Config.LangKey(value="randomtweaks.config.boneMeal.cacti")
        @Config.Comment(value={"The amount of stages bone meal should cause cacti to grow.", "16 stages is a full block."})
        public int cacti = 8;
        @Config.LangKey(value="randomtweaks.config.boneMeal.netherWart")
        @Config.Comment(value={"Whether bone meal should grow nether wart."})
        public boolean netherWart = true;
        @Config.RangeInt(min=0, max=16)
        @Config.LangKey(value="randomtweaks.config.boneMeal.sugarCanes")
        @Config.Comment(value={"The amount of stages bone meal should cause sugar canes to grow.", "16 stages is a full block."})
        public int sugarCanes = 8;
    }

    public static final class AutoThirdPerson {
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.boat")
        @Config.Comment(value={"Enables auto-third person upon entering a boat."})
        public boolean boat = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.elytra")
        @Config.Comment(value={"Enables auto-third person upon flying with elytra."})
        public boolean elytra = true;
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.enabled")
        @Config.Comment(value={"Enables auto-third person."})
        public boolean enabled = true;
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.horse")
        @Config.Comment(value={"Enables auto-third person upon mounting a horse."})
        public boolean horse = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.minecart")
        @Config.Comment(value={"Enables auto-third person upon entering a minecart."})
        public boolean minecart = RandomTweaks.IS_DEOBFUSCATED;
        @Config.LangKey(value="randomtweaks.config.autoThirdPerson.pig")
        @Config.Comment(value={"Enables auto-third person upon mounting a pig."})
        public boolean pig = RandomTweaks.IS_DEOBFUSCATED;
    }

    public static final class Animals {
        @Config.LangKey(value="randomtweaks.config.randomizedAges")
        @Config.Comment(value={"Options related to randomized animal ages."})
        public final RandomizedAges randomizedAges = new RandomizedAges();
        @Config.LangKey(value="randomtweaks.config.sheepColorWeights")
        @Config.Comment(value={"Sheep color weights."})
        public final SheepColorWeights sheepColorWeights = new SheepColorWeights();
        @Config.LangKey(value="randomtweaks.config.squids")
        @Config.Comment(value={"Options related to squid spawning behavior."})
        public final Squids squids = new Squids();
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="randomtweaks.config.animals.batLeatherDropChance")
        @Config.Comment(value={"The chance that a bat drops a piece of leather when killed."})
        public double batLeatherDropChance = 0.8;
        @Config.LangKey(value="randomtweaks.config.animals.leashableVillagers")
        @Config.Comment(value={"Whether villagers should be leashable."})
        public boolean leashableVillagers = true;
        @Config.LangKey(value="randomtweaks.config.animals.ocelotsCanBeHealed")
        @Config.Comment(value={"Whether tamed ocelots can be healed with fish."})
        public boolean ocelotsCanBeHealed = true;
        @Config.LangKey(value="randomtweaks.config.animals.parrotsCanBeHealed")
        @Config.Comment(value={"Whether tamed parrots can be healed with seeds."})
        public boolean parrotsCanBeHealed = true;
        @Config.LangKey(value="randomtweaks.config.animals.protectPetsFromOtherPets")
        @Config.Comment(value={"Prevents pets from being attacked by their owner's other pets."})
        public boolean protectPetsFromOtherPets = true;
        @Config.LangKey(value="randomtweaks.config.animals.protectPetsFromOwners")
        @Config.Comment(value={"Prevents pets from being attacked by their owners.", "By default, owners can still attack their pets while sneaking."})
        public boolean protectPetsFromOwners = true;
        @Config.LangKey(value="randomtweaks.config.animals.protectPetsFromSneakingOwners")
        @Config.Comment(value={"Prevents pets from being attacked by their owners while sneaking."})
        public boolean protectPetsFromSneakingOwners;
    }

    public static final class Data {
        private static Data data;
        public Map<String, Boolean> timeOfDayOverlay;
        public boolean stepup;
        public boolean fovChanges;

        public static Data get() {
            if (data != null) {
                return data;
            }
            Path path = Data.getPath();
            if (path.toFile().exists()) {
                try {
                    data = (Data)new Gson().fromJson(RTConfig.readFile(path), Data.class);
                }
                catch (JsonSyntaxException ex) {
                    RandomTweaks.LOGGER.error("Error in the RandomTweaks data JSON. The file will be replaced.", (Throwable)ex);
                }
            }
            if (data == null) {
                data = new Data();
                Data.data.timeOfDayOverlay = new HashMap<String, Boolean>();
                Data.data.stepup = RTConfig.client.stepupEnabledByDefault;
                Data.data.fovChanges = RTConfig.keybinds.fovChangesEnabledByDefault;
                Data.save();
            } else if (Data.data.timeOfDayOverlay == null) {
                Data.data.timeOfDayOverlay = new HashMap<String, Boolean>();
                Data.save();
            }
            return data;
        }

        public static void save() {
            Data.get();
            try {
                Files.write(Data.getPath(), Collections.singletonList(new Gson().toJson((Object)data)), new OpenOption[0]);
            }
            catch (IOException ex) {
                RandomTweaks.LOGGER.error("Error while saving RandomTweaks data", (Throwable)ex);
            }
        }

        public static Path getPath() {
            return RTConfig.client.storeDataInLocal ? RTConfig.getJson("../../local/client/rtdata") : RTConfig.getJson("data");
        }
    }
}

