/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import com.tictim.ceu.gui.InfiniteEnergyData;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.util.Numbers;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TraitInfiniteFeEmitter
extends TraitInfiniteEnergy.Emitter
implements IEnergyStorage {
    public TraitInfiniteFeEmitter(MetaTileEntity metaTileEntity) {
        super(metaTileEntity);
    }

    public String getName() {
        return "infinite_fe_emitter";
    }

    public int getNetworkID() {
        return 0;
    }

    @Nullable
    public Capability<?> getImplementingCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
        return new InfiniteEnergyData(this).guiBuilder().buttonInfinite().energyInput("FE").buttonAcceptDecline().createUI(holder, player);
    }

    @Override
    protected boolean send(EnumFacing facing) {
        IEnergyStorage s;
        TileEntity te = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(facing));
        if (te != null && (s = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) != null && s.canReceive()) {
            if (!this.isInfinite()) {
                this.subtract(BigInteger.valueOf(s.receiveEnergy(this.getEnergyStored(), false)));
            } else {
                s.receiveEnergy(this.getEnergyStored(), false);
            }
            return true;
        }
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract <= 0) {
            return 0;
        }
        BigInteger i = BigInteger.valueOf(maxExtract);
        if (i.compareTo(this.energy) > 0) {
            i = this.energy;
        }
        if (!simulate) {
            this.subtract(i);
        }
        return i.intValue();
    }

    public int getEnergyStored() {
        return this.isInfinite() ? Integer.MAX_VALUE : Numbers.toInt(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStored();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

