/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import java.math.BigInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class TraitInfiniteEnergy
extends MTETrait {
    protected BigInteger energy = BigInteger.ZERO;

    public TraitInfiniteEnergy(MetaTileEntity metaTileEntity) {
        super(metaTileEntity);
    }

    public abstract ModularUI createUI(IUIHolder var1, EntityPlayer var2);

    public BigInteger getEnergy() {
        return this.energy;
    }

    public void setEnergy(BigInteger bigInteger) {
        this.energy = bigInteger.signum() == 1 ? bigInteger : BigInteger.ZERO;
    }

    protected void add(BigInteger bInt) {
        switch (bInt.signum()) {
            case 1: {
                this.energy = this.energy.add(bInt);
                break;
            }
            case -1: {
                this.subtract(bInt.negate());
            }
        }
    }

    protected void subtract(BigInteger bInt) {
        this.energy = this.energy.compareTo(bInt) > 0 ? this.energy.subtract(bInt) : BigInteger.ZERO;
    }

    public void setInfinite(boolean infinite) {
    }

    public void setTier(int tier) {
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.energy.signum() > 0) {
            nbt.func_74773_a("energy", this.energy.toByteArray());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        byte[] bArr;
        this.energy = nbt.func_150297_b("energy", 7) ? ((bArr = nbt.func_74770_j("energy")).length > 0 ? new BigInteger(bArr) : BigInteger.ZERO) : BigInteger.ZERO;
    }

    public static abstract class Emitter
    extends TraitInfiniteEnergy {
        private boolean isInfinite;

        public Emitter(MetaTileEntity metaTileEntity) {
            super(metaTileEntity);
        }

        @Override
        public void setInfinite(boolean infinite) {
            this.isInfinite = infinite;
        }

        public boolean isInfinite() {
            return this.isInfinite;
        }

        public void update() {
            block2: {
                EnumFacing facing;
                block3: {
                    if (this.metaTileEntity.getWorld().field_72995_K) break block2;
                    if (!this.isInfinite) break block3;
                    for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                        this.send(facing2);
                    }
                    break block2;
                }
                if (this.energy.signum() != 1) break block2;
                EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                int n = enumFacingArray.length;
                for (int i = 0; !(i >= n || this.send(facing = enumFacingArray[i]) && this.energy.signum() != 1); ++i) {
                }
            }
        }

        protected abstract boolean send(EnumFacing var1);

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            if (this.isInfinite) {
                nbt.func_74757_a("infinite", true);
            }
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            this.isInfinite = nbt.func_74767_n("infinite");
        }
    }
}

