/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.charger;

import com.tictim.ceu.energy.ElectricItemIC2EU;
import com.tictim.ceu.energy.ElectricItemManagerGTEU;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.trait.charger.ChargeHandler;
import gregtech.api.capability.IElectricItem;
import ic2.api.item.ElectricItem;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ChargeHandlerIC2EU
extends ChargeHandler {
    private final ElectricItemManagerGTEU electricItemManagerGTEU;

    public ChargeHandlerIC2EU(MTECeu ceu) {
        super(ceu);
        this.electricItemManagerGTEU = new ElectricItemManagerGTEU(ceu);
    }

    @Override
    public Number getStoredSum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.storedEU(includeWrapped);
        }
        if (e != Energy.IC2EU) {
            throw new IllegalArgumentException();
        }
        return this.storedIC2EU(2.147483647E9, includeWrapped);
    }

    @Override
    public Number getCapacitySum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.capacityEU(includeWrapped);
        }
        if (e != Energy.IC2EU) {
            throw new IllegalArgumentException();
        }
        return this.capacityIC2EU(2.147483647E9, includeWrapped);
    }

    @Override
    public Number extractEnergy(Energy e, Number max, boolean extractWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.dischargeEU(max.longValue(), false, true, extractWrapped, simulate);
        }
        if (e != Energy.IC2EU) {
            throw new IllegalArgumentException();
        }
        return this.dischargeIC2EU(max.doubleValue(), extractWrapped, simulate);
    }

    @Override
    public Number insertEnergy(Energy e, Number max, boolean insertWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.chargeEU(max.longValue(), false, insertWrapped, simulate);
        }
        if (e != Energy.IC2EU) {
            throw new IllegalArgumentException();
        }
        return this.chargeIC2EU(max.doubleValue(), insertWrapped, simulate);
    }

    public double chargeIC2EU(double maxReceive, boolean chargeWrapped, boolean simulate) {
        if (maxReceive <= 0.0) {
            return 0.0;
        }
        double total = 0.0;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || !((total += this.chargeIC2EU(s, maxReceive - total, false, chargeWrapped, simulate)) >= maxReceive)) continue;
            return maxReceive;
        }
        return total;
    }

    public double dischargeIC2EU(double maxExtract, boolean dischargeWrapped, boolean simulate) {
        if (maxExtract <= 0.0) {
            return 0.0;
        }
        double total = 0.0;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || !((total += this.dischargeIC2EU(s, maxExtract - total, false, true, dischargeWrapped, simulate)) >= maxExtract)) continue;
            return maxExtract;
        }
        return total;
    }

    public double capacityIC2EU(double limit, boolean includeWrapped) {
        if (limit <= 0.0) {
            return 0.0;
        }
        double total = 0.0;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || !((total += this.getMaxChargeIC2EU(s, includeWrapped)) >= limit)) continue;
            return limit;
        }
        return total;
    }

    public double storedIC2EU(double limit, boolean includeWrapped) {
        if (limit <= 0.0) {
            return 0.0;
        }
        double total = 0.0;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack s = inventory.getStackInSlot(i);
            if (s == null || !((total += this.getChargeIC2EU(s, includeWrapped)) >= limit)) continue;
            return limit;
        }
        return total;
    }

    @Override
    @Nullable
    protected IElectricItem getWrappedBatteryContainer(ItemStack s) {
        return ElectricItemIC2EU.fromItem(this.ceu, s);
    }

    protected double chargeIC2EU(ItemStack stack, double amount, boolean ignoreTransferLimit, boolean chargeWrapped, boolean simulate) {
        double charge = ElectricItem.manager.charge(stack, amount, ElectricItem.manager.getTier(stack), ignoreTransferLimit, simulate);
        if (chargeWrapped && charge <= 0.0) {
            return this.electricItemManagerGTEU.charge(stack, amount, this.electricItemManagerGTEU.getTier(stack), ignoreTransferLimit, simulate);
        }
        return charge;
    }

    protected double dischargeIC2EU(ItemStack stack, double amount, boolean ignoreTransferLimit, boolean externally, boolean dischargeWrapped, boolean simulate) {
        double discharge = ElectricItem.manager.discharge(stack, amount, ElectricItem.manager.getTier(stack), ignoreTransferLimit, externally, simulate);
        if (dischargeWrapped && discharge <= 0.0) {
            return this.electricItemManagerGTEU.discharge(stack, amount, this.electricItemManagerGTEU.getTier(stack), ignoreTransferLimit, externally, simulate);
        }
        return discharge;
    }

    protected double getChargeIC2EU(ItemStack stack, boolean includeWrapped) {
        double charge = ElectricItem.manager.getCharge(stack);
        if (includeWrapped && charge <= 0.0) {
            return this.electricItemManagerGTEU.getCharge(stack);
        }
        return charge;
    }

    protected double getMaxChargeIC2EU(ItemStack stack, boolean includeWrapped) {
        double maxCharge = ElectricItem.manager.getMaxCharge(stack);
        if (includeWrapped && maxCharge <= 0.0) {
            return this.electricItemManagerGTEU.getMaxCharge(stack);
        }
        return maxCharge;
    }

    protected boolean canUseIC2EU(ItemStack stack, double amount, boolean includeWrapped) {
        return ElectricItem.manager.canUse(stack, amount) || includeWrapped && this.electricItemManagerGTEU.canUse(stack, amount);
    }

    protected boolean useIC2EU(ItemStack stack, double amount, @Nullable EntityLivingBase entity, boolean includeWrapped) {
        return ElectricItem.manager.use(stack, amount, entity) || includeWrapped && this.electricItemManagerGTEU.use(stack, amount, entity);
    }
}

