/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait;

import com.tictim.ceu.energy.Ic2EuFlag;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TraitIc2EuOut
extends MTETrait {
    private final MTECeu ceu;
    private SourceWrapper sinkWrapper;

    public TraitIc2EuOut(MTECeu ceu) {
        super((MetaTileEntity)ceu);
        this.ceu = ceu;
    }

    public String getName() {
        return "TraitIc2EuOut";
    }

    public int getNetworkID() {
        return 0;
    }

    @Nullable
    public Capability<?> getImplementingCapability() {
        return Ic2EuFlag.CAP;
    }

    public void update() {
        if (!this.ceu.getWorld().field_72995_K && this.sinkWrapper == null) {
            this.sinkWrapper = new SourceWrapper();
            if (Loader.isModLoaded((String)"ic2")) {
                this.sinkWrapper.addToENet();
            }
        }
    }

    @Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergySource"), @Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergyEmitter"), @Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergyTile")})
    private class SourceWrapper
    extends TileEntity
    implements IEnergySource {
        private SourceWrapper() {
            this.func_145834_a(TraitIc2EuOut.this.ceu.getWorld());
            this.func_174878_a(TraitIc2EuOut.this.ceu.getPos());
        }

        @Optional.Method(modid="ic2")
        public void addToENet() {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }

        @Optional.Method(modid="ic2")
        public void removeFromENet() {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }

        @Optional.Method(modid="ic2")
        public double getOfferedEnergy() {
            return TraitIc2EuOut.this.ceu.extractEnergy(Energy.IC2EU, TraitIc2EuOut.this.ceu.getEnergyStorage().getOutputVoltage(), true, true).doubleValue();
        }

        @Optional.Method(modid="ic2")
        public void drawEnergy(double amount) {
            TraitIc2EuOut.this.ceu.extractEnergy(Energy.IC2EU, amount, true, false);
        }

        @Optional.Method(modid="ic2")
        public int getSourceTier() {
            return TraitIc2EuOut.this.ceu.getTier();
        }

        @Optional.Method(modid="ic2")
        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
            return TraitIc2EuOut.this.ceu.getFrontFacing() == side;
        }
    }
}

