/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.enums;

import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.Energy;

public enum ConverterType {
    CEU_CEF(0, 9, Energy.FE),
    ICEU_ICEF(1, 5, Energy.IC2EU);

    private final int minTier;
    private final int maxTier;
    private final Energy ceuOutput;

    private ConverterType(int minTier, int maxTier, Energy ceuOutput) {
        if (ceuOutput == Energy.GTEU) {
            throw new IllegalArgumentException();
        }
        this.minTier = minTier;
        this.maxTier = maxTier;
        this.ceuOutput = ceuOutput;
    }

    public CeuType getCeuType() {
        switch (this) {
            case CEU_CEF: {
                return CeuType.CEU;
            }
            case ICEU_ICEF: {
                return CeuType.ICEU;
            }
        }
        throw new IllegalArgumentException();
    }

    public CeuType getCefType() {
        switch (this) {
            case CEU_CEF: {
                return CeuType.CEF;
            }
            case ICEU_ICEF: {
                return CeuType.ICEF;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getMinTier() {
        return this.minTier;
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    public Energy getCeuOutput() {
        return this.ceuOutput;
    }

    public Energy getInput(boolean isCeu) {
        return isCeu ? Energy.GTEU : this.ceuOutput;
    }

    public Energy getOutput(boolean isCeu) {
        return isCeu ? this.ceuOutput : Energy.GTEU;
    }

    public boolean uses(Energy energy) {
        return energy == Energy.GTEU || this.ceuOutput == energy;
    }
}

