/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.energy;

import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Ratio;
import gregtech.api.capability.IElectricItem;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageGteu
implements IEnergyStorage {
    private final IElectricItem battery;
    private final Ratio ratio;

    public EnergyStorageGteu(MTECeu ceu, IElectricItem battery) {
        this.battery = battery;
        this.ratio = ceu.getType().getInput() == Energy.GTEU ? ceu.ratio() : ceu.ratio().reverse();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.ratio.convertToInt(this.battery.charge(this.ratio.reverse().convertToLong(maxReceive), this.battery.getTier(), false, simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.ratio.convertToInt(this.battery.discharge(this.ratio.reverse().convertToLong(maxExtract), this.battery.getTier(), false, true, simulate));
    }

    public int getEnergyStored() {
        return this.ratio.convertToInt(this.battery.getCharge());
    }

    public int getMaxEnergyStored() {
        return this.ratio.convertToInt(this.battery.getMaxCharge());
    }

    public boolean canExtract() {
        return this.battery.discharge(1L, this.battery.getTier(), false, true, true) > 0L;
    }

    public boolean canReceive() {
        return this.battery.canProvideChargeExternally() && this.battery.charge(1L, this.battery.getTier(), false, true) > 0L;
    }
}

