/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.tictim.ceu.CeuResources;
import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.energy.Ic2EuFlag;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.message.MessageConfigSync;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.MTEInfiniteEnergy;
import com.tictim.ceu.util.CeuCraftingHelper;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.SimpleCapabilityManager;
import gregtech.api.metatileentity.MetaTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ceu", name="Ceu", version="1.0.3.0", dependencies="required-after:gregtech;", guiFactory="com.tictim.ceu.config.CeuConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Ceu {
    public static final String MODID = "ceu";
    public static final String NAME = "Ceu";
    public static final String VERSION = "1.0.3.0";
    public static final SimpleNetworkWrapper NET = NetworkRegistry.INSTANCE.newSimpleChannel("ceu");
    private static final ListMultimap<CeuType, MTECeu> MTE_CEUS = ArrayListMultimap.create();

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        CeuResources.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CeuConfig.load(event);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(Ic2EuFlag.class);
        int id = 10650;
        for (ConverterType converterType : ConverterType.values()) {
            for (int i = converterType.getMinTier(); i < converterType.getMaxTier(); ++i) {
                for (int slot = 1; slot <= 4; ++slot) {
                    String vn = GTValues.VN[i].toLowerCase();
                    MTE_CEUS.put((Object)converterType.getCeuType(), (Object)GregTechAPI.registerMetaTileEntity((int)id++, (MetaTileEntity)new MTECeu(new ResourceLocation(MODID, converterType.getCeuType() + "." + vn + "." + slot * slot), i, converterType.getCeuType(), slot)));
                    MTE_CEUS.put((Object)converterType.getCefType(), (Object)GregTechAPI.registerMetaTileEntity((int)id++, (MetaTileEntity)new MTECeu(new ResourceLocation(MODID, converterType.getCefType() + "." + vn + "." + slot * slot), i, converterType.getCefType(), slot)));
                }
            }
        }
        id = 10649;
        for (Enum enum_ : Energy.values()) {
            if (enum_ == Energy.IC2EU) {
                id -= 2;
                return;
            }
            GregTechAPI.registerMetaTileEntity((int)id--, (MetaTileEntity)new MTEInfiniteEnergy(new ResourceLocation(MODID, ((Energy)enum_).getRawName() + "_emitter"), (Energy)enum_, true));
            GregTechAPI.registerMetaTileEntity((int)id--, (MetaTileEntity)new MTEInfiniteEnergy(new ResourceLocation(MODID, ((Energy)enum_).getRawName() + "_receiver"), (Energy)enum_, false));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (CeuType type : CeuType.values()) {
            MTE_CEUS.get((Object)type).forEach(CeuCraftingHelper.HELPER.logic(type));
        }
        NET.registerMessage((IMessageHandler)new MessageConfigSync.Handler(), MessageConfigSync.class, 0, Side.CLIENT);
    }
}

