/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.compatibility.IItemFluidHandlerCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public abstract class XUTile
extends TileEntity {
    XUBlock xuBlock;
    XUBlockState state;
    @Nullable
    private HashMap<String, INBTSerializable> nbtHandlers;

    public static boolean isLoaded(TileEntity tile) {
        World world;
        if (!tile.func_145837_r() && (world = tile.func_145831_w()) != null && tile.func_174877_v() != null) {
            if (DimensionManager.getWorld((int)world.field_73011_w.getDimension()) != world) {
                return false;
            }
            if (world.func_175667_e(tile.func_174877_v())) {
                Chunk chunk = world.func_175726_f(tile.func_174877_v());
                if (chunk == null) {
                    return false;
                }
                if (chunk.func_177424_a(tile.func_174877_v(), Chunk.EnumCreateEntityType.CHECK) == tile) {
                    return true;
                }
            }
        }
        return false;
    }

    public static <T extends TileEntity> List<T> searchAABBForTiles(World world, AxisAlignedBB area, Class<T> tileClazz, boolean firstOnly, List<T> list) {
        int x0 = (int)Math.floor(area.field_72340_a) >> 4;
        int x1 = (int)Math.ceil(area.field_72336_d) >> 4;
        int z0 = (int)Math.floor(area.field_72339_c) >> 4;
        int z1 = (int)Math.ceil(area.field_72334_f) >> 4;
        if (list == null) {
            list = Lists.newArrayList();
        }
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                Chunk chunk = world.func_72964_e(x, z);
                for (Map.Entry entry2 : chunk.func_177434_r().entrySet()) {
                    BlockPos pos = (BlockPos)entry2.getKey();
                    if (tileClazz != ((TileEntity)entry2.getValue()).getClass() || !area.func_72318_a(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5))) continue;
                    list.add((TileEntity)entry2.getValue());
                    if (!firstOnly) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public static EnumFacing getSafeFacing(int i) {
        if (i == 6) {
            return null;
        }
        return EnumFacing.values()[i];
    }

    public static int getSafeOrdinal(@Nullable EnumFacing facing) {
        return facing == null ? 6 : facing.ordinal();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            return true;
        }
        if (oldState == newState) {
            return false;
        }
        Collection newStatePropertyNames = newState.func_177227_a();
        for (IProperty prop : oldState.func_177227_a()) {
            if (prop instanceof IMetaProperty) continue;
            if (!newStatePropertyNames.contains(prop)) {
                return true;
            }
            if (prop.func_177701_a().equals("facing") || prop.func_177701_a().equals("rotation") || oldState.func_177229_b(prop).equals(newState.func_177229_b(prop))) continue;
            return true;
        }
        return false;
    }

    protected <T extends INBTSerializable> T registerNBT(String key, T t) {
        if (this.nbtHandlers == null) {
            this.nbtHandlers = new HashMap();
        }
        this.nbtHandlers.put(key, t);
        return t;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.nbtHandlers != null) {
            HashMap<String, INBTSerializable> nbtHandlers = this.nbtHandlers;
            NBTSerializable.loadData(compound, nbtHandlers);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.nbtHandlers != null) {
            NBTSerializable.saveData(compound, this.nbtHandlers);
        }
        return compound;
    }

    public boolean isLoaded() {
        return XUTile.isLoaded(this);
    }

    @OverridingMethodsMustInvokeSuper
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        if (StackHelper.isNonNull(stack) && stack.func_77942_o()) {
            NBTTagCompound tagCompound = (NBTTagCompound)Validate.notNull((Object)stack.func_77978_p());
            this.loadSaveInfo(tagCompound);
        }
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        Iterable<ItemStack> itemHandler = this.getDropHandler();
        if (itemHandler != null) {
            InventoryHelper.dropAll(worldIn, pos, itemHandler);
        }
    }

    protected Iterable<ItemStack> getDropHandler() {
        IItemHandler itemHandler = this.getItemHandler(null);
        if (itemHandler == null) {
            return null;
        }
        return InventoryHelper.getItemHandlerIterator(itemHandler);
    }

    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
        return false;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.xuBlock = null;
        this.state = null;
    }

    public XUBlockState getBlockState() {
        if (this.state == null) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            XUBlock xuBlock = BlockEntry.tileToBlockMap.get(((Object)((Object)this)).getClass());
            Set xuBlocks = BlockEntry.tileToBlocksMap.get(((Object)((Object)this)).getClass());
            if (blockState instanceof XUBlockState && xuBlocks.contains(blockState.func_177230_c())) {
                this.state = (XUBlockState)blockState;
            } else {
                if (xuBlock != null) {
                    this.state = (XUBlockState)xuBlock.func_176223_P();
                    this.field_145850_b.func_184138_a(this.field_174879_c, (IBlockState)this.state, (IBlockState)this.state, 0);
                }
                this.func_145843_s();
            }
        }
        return this.state;
    }

    public XUBlock getXUBlock() {
        if (this.xuBlock == null) {
            this.xuBlock = (XUBlock)this.getBlockState().func_177230_c();
        }
        return this.xuBlock;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.handleFluids(worldIn, playerIn, hand, heldItem, side)) {
            return true;
        }
        if (this instanceof IDynamicHandler) {
            if (!worldIn.field_72995_K) {
                this.openGUI(playerIn);
            }
            return true;
        }
        return false;
    }

    public boolean handleFluids(World worldIn, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side) {
        IFluidHandler handler = this.getFluidHandler(side);
        if (handler == null) {
            return false;
        }
        if (FluidUtil.getFluidHandler((ItemStack)heldItem) != null) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (this.attemptDrain(playerIn, hand, heldItem, handler) || this.attemptFill(playerIn, hand, heldItem, handler)) {
                return true;
            }
        }
        return false;
    }

    public boolean attemptFill(EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, IFluidHandler handler) {
        ItemStack copy = heldItem.func_77946_l();
        StackHelper.setStackSize(copy, 1);
        IItemFluidHandlerCompat container = IItemFluidHandlerCompat.getFluidHandler(copy);
        if (container == null) {
            return false;
        }
        FluidStack drain = container.drain(1000, false);
        if (drain == null) {
            return false;
        }
        int fill = handler.fill(drain, false);
        if (fill == 0) {
            return false;
        }
        copy = heldItem.func_77979_a(1);
        container = IItemFluidHandlerCompat.getFluidHandler(copy);
        if (container != null) {
            handler.fill(container.drain(fill, true), true);
            copy = container.getModifiedStack();
        }
        if (StackHelper.getStacksize(copy) != 0) {
            if (StackHelper.isEmpty(heldItem)) {
                heldItem = copy;
                playerIn.func_184611_a(hand, heldItem);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)copy, (ItemStack)heldItem)) {
                StackHelper.increase(heldItem);
                playerIn.func_184611_a(hand, heldItem);
            } else {
                playerIn.field_71071_by.func_70441_a(copy);
            }
        }
        return true;
    }

    public boolean attemptDrain(EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, IFluidHandler handler) {
        ItemStack copy = heldItem.func_77946_l();
        StackHelper.setStackSize(copy, 1);
        IItemFluidHandlerCompat container = IItemFluidHandlerCompat.getFluidHandler(copy);
        if (container == null) {
            return false;
        }
        FluidStack toDrain = handler.drain(1000, false);
        if (toDrain == null) {
            return false;
        }
        int fill = container.fill(toDrain, false);
        if (fill == 0) {
            return false;
        }
        copy = heldItem.func_77979_a(1);
        container = IItemFluidHandlerCompat.getFluidHandler(copy);
        if (container != null) {
            container.fill(handler.drain(fill, true), true);
            copy = container.getModifiedStack();
        }
        if (StackHelper.getStacksize(copy) != 0) {
            if (StackHelper.isEmpty(heldItem)) {
                heldItem = copy;
                playerIn.func_184611_a(hand, heldItem);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)copy, (ItemStack)heldItem)) {
                StackHelper.increase(heldItem);
                playerIn.func_184611_a(hand, heldItem);
            } else {
                playerIn.field_71071_by.func_70441_a(copy);
            }
        }
        return true;
    }

    public void openGUI(EntityPlayer player) {
        this.openGUI(player, 0);
    }

    public void openGUI(EntityPlayer player, int modGuiId) {
        player.openGui((Object)ExtraUtils2.instance, modGuiId, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        IItemHandler handler;
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability && (handler = this.getItemHandler(facing)) != null) {
            return (T)handler;
        }
        if (CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == capability && (handler = this.getFluidHandler(facing)) != null) {
            return (T)handler;
        }
        if (CapabilityEnergy.ENERGY == capability && (handler = this.getEnergyHandler(facing)) != null) {
            return (T)handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public void addToDescriptionPacket(XUPacketBuffer packet) {
    }

    public void handleDescriptionPacket(XUPacketBuffer packet) {
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public final void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("a", 7)) {
            this.handleDescriptionPacket(new XUPacketBuffer(Unpooled.wrappedBuffer((byte[])tag.func_74770_j("a"))));
        }
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        ByteBuf buffer = Unpooled.buffer();
        this.addToDescriptionPacket(new XUPacketBuffer(buffer));
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return super.func_189517_E_();
        }
        byte[] b = new byte[readableBytes];
        buffer.readBytes(b);
        NBTTagCompound tags = super.func_189517_E_();
        tags.func_74773_a("a", b);
        return tags;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbtCompound = pkt.func_148857_g();
        this.handleUpdateTag(nbtCompound);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBakedModel(IBlockAccess world, IVertexBuffer renderer, BlockRendererDispatcher blockRenderer, IBakedModel model) {
        blockRenderer.func_175019_b().func_178267_a(world, model, (IBlockState)this.getBlockState(), this.func_174877_v(), CompatClientHelper.unwrap(renderer), false);
    }

    public void markForUpdate() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        XUBlockState state = this.getBlockState();
        this.field_145850_b.func_184138_a(this.field_174879_c, (IBlockState)state, (IBlockState)state, 0);
    }

    public Optional<ItemStack> getPickBlock(EntityPlayer player, @Nullable RayTraceResult target) {
        Item item;
        NBTTagCompound saveInfo = this.getSaveInfo();
        if (saveInfo != null && (item = Item.func_150898_a((Block)this.getXUBlock().xuBlockState.mainBlock)) != null) {
            ItemStack stack = new ItemStack(item, 1, this.getXUBlock().func_180651_a((IBlockState)this.state));
            stack.func_77982_d(saveInfo);
            return Optional.of(stack);
        }
        return null;
    }

    public boolean hasComparatorLevels() {
        return false;
    }

    public int getComparatorLevel() {
        throw new IllegalStateException();
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    @Nullable
    public NBTTagCompound getSaveInfo() {
        return null;
    }

    public void loadSaveInfo(@Nonnull NBTTagCompound tag) {
    }

    public NBTTagCompound saveRegisteredNBT(NBTTagCompound tag, String ... data) {
        if (this.nbtHandlers == null) {
            throw new IllegalStateException();
        }
        for (String key : data) {
            NBTBase value = this.nbtHandlers.get(key).serializeNBT();
            tag.func_74782_a(key, value);
        }
        return tag;
    }

    public void loadRegisteredNBT(NBTTagCompound compound, String ... data) {
        if (this.nbtHandlers == null) {
            throw new IllegalStateException();
        }
        for (String key : data) {
            NBTBase tag = compound.func_74781_a(key);
            if (NullHelper.nullable(tag) == null) continue;
            ((INBTSerializable)Validate.notNull((Object)this.nbtHandlers.get(key))).deserializeNBT(tag);
        }
    }
}

